﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using SysCore.Model;
/// <summary>
///存货
/// </summary>
public class Inventory
{
    /// <summary>
    /// 存货id
    /// </summary>
    public int i_id { get; set; }
    /// <summary>
    /// 存货编码
    /// </summary>
    public string i_code { get; set; }
    /// <summary>
    /// 存货名称
    /// </summary>
    public string i_name { get; set; }
    /// <summary>
    /// 存货分类id
    /// </summary>
    public int ic_id { get; set; }
    /// <summary>
    /// 存货分类
    /// </summary>
    public InventoryClass inventory_class { get; set; }
    /// <summary>
    /// 停用日期
    /// </summary>
    public DateTime? stop_date { get; set; }
    /// <summary>
    /// 规格型号
    /// </summary>
    public string standard { get; set; }
    /// <summary>
    /// 主计量单位
    /// </summary>
    public string munit { get; set; }
    /// <summary>
    /// 辅计量单位
    /// </summary>
    public string aunit { get; set; }
    /// <summary>
    /// 单位换算率
    /// </summary>
    public decimal? convert_rate { get; set; }
    /// <summary>
    /// 计价方式(1,全月平均法 2,移动平均法)
    /// </summary>
    public string valuation { get; set; }
    /// <summary>
    /// 建档日期
    /// </summary>
    public DateTime? add_date { get; set; }
    /// <summary>
    /// 修改日期
    /// </summary>
    public DateTime? update_date { get; set; }
    /// <summary>
    /// 修改人id
    /// </summary>
    public int? updater_id { get; set; }
    /// <summary>
    /// 修改人
    /// </summary>
    public string updater_user { get; set; }
    /// <summary>
    /// 启用自由项1
    /// </summary>
    public int on_free1 { get; set; }
    /// <summary>
    /// 启用自由项2
    /// </summary>
    public int on_free2 { get; set; }
    /// <summary>
    /// 启用批次
    /// </summary>
    public int on_batch { get; set; }
    /// <summary>
    /// 存货图片
    /// </summary>
    public InventoryPhoto inventory_photo { get; set; }
    /// <summary>
    /// 是否销售
    /// </summary>
    public int? is_sale { get; set; }
    /// <summary>
    /// 是否外购
    /// </summary>
    public int? is_purchase { get; set; }
    /// <summary>
    /// 是否自制
    /// </summary>
    public int? is_self { get; set; }
    /// <summary>
    /// 是否委外
    /// </summary>
    public int? is_outsource { get; set; }
    /// <summary>
    /// 是否芝务费
    /// </summary>
    public int? is_service { get; set; }
    /// <summary>
    /// 安全库存
    /// </summary>
    public decimal? safety_stock { get; set; }
    /// <summary>
    /// 最低库存
    /// </summary>
    public decimal? min_stock { get; set; }
    /// <summary>
    /// 最高库存
    /// </summary>
    public decimal? max_stock { get; set; }
    /// <summary>
    /// 采购批量
    /// </summary>
    public decimal? purchase_batch { get; set; }
    /// <summary>
    /// 最新报价(原币含税)
    /// </summary>
    public decimal? new_tax_unit_price { get; set; }
    /// <summary>
    /// 最新成本(本币无税)
    /// </summary>
    public decimal? new_nat_unit_price { get; set; }
    /// <summary>
    /// 默认供应商id
    /// </summary>
    public int? vd_id { get; set; }
    /// <summary>
    /// 默认供应商
    /// </summary>
    public Vendor vendor { get; set; }
    /// <summary>
    /// 默认仓库id
    /// </summary>
    public int? wh_id { get; set; }
    /// <summary>
    /// 默认仓库
    /// </summary>
    public Warehouse warehouse { get; set; }
    /// <summary>
    /// 字符自定义项1
    /// </summary>
    public string sdefine1 { get; set; }
    /// <summary>
    /// 字符自定义项2
    /// </summary>
    public string sdefine2 { get; set; }
    /// <summary>
    /// 字符自定义项3
    /// </summary>
    public string sdefine3 { get; set; }
    /// <summary>
    /// 字符自定义项4
    /// </summary>
    public string sdefine4 { get; set; }
    /// <summary>
    /// 字符自定义项5
    /// </summary>
    public string sdefine5 { get; set; }
    /// <summary>
    /// 数值自定义项1
    /// </summary>
    public decimal? ndefine1 { get; set; }
    /// <summary>
    /// 数值自定义项2
    /// </summary>
    public decimal? ndefine2 { get; set; }
    /// <summary>
    /// 数值自定义项3
    /// </summary>
    public decimal? ndefine3 { get; set; }
    /// <summary>
    /// 数值自定义项4
    /// </summary>
    public decimal? ndefine4 { get; set; }
    /// <summary>
    /// 数值自定义项5
    /// </summary>
    public decimal? ndefine5 { get; set; }
}