﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

/// <summary>
///应收应付单子表
/// </summary>
public class APDetail
{
    /// <summary>
    /// 应收应付单主键ID
    /// </summary>
    public int apd_id { get; set; }
    /// <summary>
    /// 收付标志:AR应收、AP应付
    /// </summary>
    public string rp_flag { get; set; }
    /// <summary>
    /// 发票号
    /// </summary>
    public string invoice_no { get; set; }
    /// <summary>
    /// 存货ID
    /// </summary>
    public int? i_id { get; set; }
    /// <summary>
    /// 自由项1
    /// </summary>
    public string free1 { get; set; }
    /// <summary>
    /// 自由项2
    /// </summary>
    public string free2 { get; set; }
    /// <summary>
    /// 批次
    /// </summary>
    public string batch { get; set; }
    /// <summary>
    /// 对账单子表id
    /// </summary>
    public int? cas_id { get; set; }
    /// <summary>
    /// 对账单号
    /// </summary>
    public string ca_order_number { get; set; }
    /// <summary>
    /// 对账单子表实体
    /// </summary>
    public CheckAccounts check_accounts { get; set; }
    /// <summary>
    /// 其它应收应付单主表id
    /// </summary>
    public int? orp_id { get; set; }
    /// <summary>
    /// 其它应收应付单主表实体
    /// </summary>
    public OtherRP other_rp { get; set; }
    /// <summary>
    /// 存货实体
    /// </summary>
    public Inventory inventory { get; set; }
    /// <summary>
    /// 客户ID
    /// </summary>
    public int? cus_id { get; set; }
    /// <summary>
    /// 客户
    /// </summary>
    public Customer customer { get; set; }
    /// <summary>
    /// 供应商ID
    /// </summary>
    public int? vd_id { get; set; }
    /// <summary>
    /// 供应商
    /// </summary>
    public Vendor vendor { get; set; }
    /// <summary>
    /// 部门ID
    /// </summary>
    public int? dep_id { get; set; }
    /// <summary>
    /// 部门
    /// </summary>
    public Department department { get; set; }
    /// <summary>
    /// 员工ID
    /// </summary>
    public int? ele_id { get; set; }
    /// <summary>
    /// 员工
    /// </summary>
    public Employee employee { get; set; }
    /// <summary>
    /// 无税单价
    /// </summary>
    public decimal? unit_price { get; set; }
    /// <summary>
    /// 含税单价
    /// </summary>
    public decimal? tax_unit_price { get; set; }
    /// <summary>
    /// 数量
    /// </summary>
    public decimal? quantity { get; set; }
    /// <summary>
    /// 件数
    /// </summary>
    public decimal? num { get; set; }
    /// <summary>
    /// 出库数量
    /// </summary>
    public decimal? io_quantity { get; set; }
    /// <summary>
    /// 换算率
    /// </summary>
    public decimal? convert_rate { get; set; }
    /// <summary>
    /// 无税金额
    /// </summary>
    public decimal? total_price { get; set; }
    /// <summary>
    /// 含税金额
    /// </summary>
    public decimal? tax_total_price { get; set; }
    /// <summary>
    /// 本币单价
    /// </summary>
    public decimal? nat_unit_price { get; set; }
    /// <summary>
    /// 本币金额
    /// </summary>
    public decimal? nat_total_price { get; set; }
    /// <summary>
    /// 本币含税单价
    /// </summary>
    public decimal? nat_tax_unit_price { get; set; }
    /// <summary>
    /// 本币含税金额
    /// </summary>
    public decimal? nat_tax_total_price { get; set; }
    /// <summary>
    /// 币种ID
    /// </summary>
    public int? crc_id { get; set; }
    /// <summary>
    /// 币种
    /// </summary>
    public Currency currency { get; set; }
    /// <summary>
    /// 汇率
    /// </summary>
    public decimal? exchange_rate { get; set; }
    /// <summary>
    /// 税率
    /// </summary>
    public decimal? tax_rate { get; set; }
    /// <summary>
    /// 业务类型
    /// </summary>
    public string bus_type { get; set; }
    /// <summary>
    /// 单据来源
    /// </summary>
    public string from_type { get; set; }
    /// <summary>
    /// 来源单据ID
    /// </summary>
    public int? from_id { get; set; }
    /// <summary>
    /// 来源单据号(对账单号、其它应收应付单号或二开模块单据号)
    /// </summary>
    public string from_order_number { get; set; }
    /// <summary>
    /// 业务订单号(采购订单号或销售订单号)
    /// </summary>
    public string bus_order_number { get; set; }
        /// <summary>
    /// 新增人ID
    /// </summary>
    public int? new_uid { get; set; }
    /// <summary>
    /// 新增人名称
    /// </summary>
    public string new_user { get; set; }
    /// <summary>
    /// 新增日期
    /// </summary>
    public DateTime? new_date { get; set; }
    /// <summary>
    /// 修改人ID
    /// </summary>
    public int? update_uid { get; set; }
    /// <summary>
    /// 修改人名称
    /// </summary>
    public string update_user { get; set; }
    /// <summary>
    /// 修改日期
    /// </summary>
    public DateTime? update_date { get; set; }
    /// <summary>
    /// 审核人ID
    /// </summary>
    public int? verify_uid { get; set; }
    /// <summary>
    /// 审核人名称
    /// </summary>
    public string verify_user { get; set; }
    /// <summary>
    /// 备注
    /// </summary>
    public string remark { get; set; }
    /// <summary>
    /// 字符自定义项1
    /// </summary>
    public string d_sdefine1 { get; set; }
    /// <summary>
    /// 字符自定义项2
    /// </summary>
    public string d_sdefine2 { get; set; }
    /// <summary>
    /// 字符自定义项3
    /// </summary>
    public string d_sdefine3 { get; set; }
    /// <summary>
    /// 字符自定义项4
    /// </summary>
    public string d_sdefine4 { get; set; }
    /// <summary>
    /// 字符自定义项5
    /// </summary>
    public string d_sdefine5 { get; set; }
    /// <summary>
    /// 数值自定义项1
    /// </summary>
    public decimal? d_ndefine1 { get; set; }
    /// <summary>
    /// 数值自定义项2
    /// </summary>
    public decimal? d_ndefine2 { get; set; }
    /// <summary>
    /// 数值自定义项3
    /// </summary>
    public decimal? d_ndefine3 { get; set; }
    /// <summary>
    /// 数值自定义项4
    /// </summary>
    public decimal? d_ndefine4 { get; set; }
    /// <summary>
    /// 数值自定义项5
    /// </summary>
    public decimal? d_ndefine5 { get; set; }
}
