﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class TransfersDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(Transfers m)
    {
        string sql = @"insert Stock_Transfers(ts_id,i_id,free1,free2,batch,
                                quantity,num,convert_rate,
                                unit_price,total_price,d_remark,
                                d_sdefine1,d_sdefine2,d_sdefine3,d_sdefine4,d_sdefine5,
                                d_ndefine1,d_ndefine2,d_ndefine3,d_ndefine4,d_ndefine5)
                        select  @ts_id,@i_id,@free1,@free2,@batch,
                                @quantity,@num,@convert_rate,
                                @unit_price,@total_price,@d_remark,
                                @d_sdefine1,@d_sdefine2,@d_sdefine3,@d_sdefine4,@d_sdefine5,
                                @d_ndefine1,@d_ndefine2,@d_ndefine3,@d_ndefine4,@d_ndefine5";
        SqlParameter[] par = {
            new SqlParameter("@ts_id",m.ts_id),
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@free1",XTools.StringToDBNull(m.free1)),
            new SqlParameter("@free2",XTools.StringToDBNull(m.free2)),
            new SqlParameter("@batch",XTools.StringToDBNull(m.batch)),
            new SqlParameter("@quantity",XTools.DecimalToDBNull(m.quantity)),
            new SqlParameter("@num",XTools.DecimalToDBNull(m.num)),
            new SqlParameter("@convert_rate",XTools.DecimalToDBNull(m.convert_rate)),
            new SqlParameter("@unit_price",XTools.DecimalToDBNull(m.unit_price)),
            new SqlParameter("@total_price",XTools.DecimalToDBNull(m.total_price)),
            new SqlParameter("@d_remark",XTools.StringToDBNull(m.d_remark)),
            new SqlParameter("@d_sdefine1",XTools.StringToDBNull(m.d_sdefine1)),
            new SqlParameter("@d_sdefine2",XTools.StringToDBNull(m.d_sdefine2)),
            new SqlParameter("@d_sdefine3",XTools.StringToDBNull(m.d_sdefine3)),
            new SqlParameter("@d_sdefine4",XTools.StringToDBNull(m.d_sdefine4)),
            new SqlParameter("@d_sdefine5",XTools.StringToDBNull(m.d_sdefine5)),
            new SqlParameter("@d_ndefine1",XTools.DecimalToDBNull(m.d_ndefine1)),
            new SqlParameter("@d_ndefine2",XTools.DecimalToDBNull(m.d_ndefine2)),
            new SqlParameter("@d_ndefine3",XTools.DecimalToDBNull(m.d_ndefine3)),
            new SqlParameter("@d_ndefine4",XTools.DecimalToDBNull(m.d_ndefine4)),
            new SqlParameter("@d_ndefine5",XTools.DecimalToDBNull(m.d_ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">tss_id</param>
    /// <returns>Transfers</returns>
    public Transfers Get(int tss_id)
    {
        Transfers m = new Transfers();
        string sql = @"select d.*,
                    i.sdefine1 as d_inv_sdefine1,i.sdefine2 as d_inv_sdefine2,i.sdefine3 as d_inv_sdefine3,
                    i.sdefine4 as d_inv_sdefine4,i.sdefine5 as d_inv_sdefine5,
                    i.ndefine1 as d_inv_ndefine1,i.ndefine2 as d_inv_ndefine2,i.ndefine3 as d_inv_ndefine3,
                    i.ndefine4 as d_inv_ndefine4,i.ndefine5 as d_inv_ndefine5
                    from Stock_Transfers d
                    left join Base_Inventory i on d.i_id=i.i_id
                    where d.tss_id=@tss_id";
        sql = sql.Replace("@tss_id", tss_id.ToString());

        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, null))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.ts_id = Convert.ToInt32(r["ts_id"]);//主表id
                m.tss_id = Convert.ToInt32(r["tss_id"]);//子表id
                m.i_id = Convert.ToInt32(r["i_id"]);//存货id
                if (r["i_id"] != DBNull.Value)
                    m.inventory = new InventoryDAL().Get(m.i_id);
                m.free1 = r["free1"].ToString();
                m.free2 = r["free2"].ToString();
                m.batch = r["batch"].ToString();
                m.quantity = XTools.DBNullToDecimal(r["quantity"]);//数量
                m.num = XTools.DBNullToDecimal(r["num"]);//件数
                m.convert_rate = XTools.DBNullToDecimal(r["convert_rate"]);//换算率
                m.unit_price = XTools.DBNullToDecimal(r["unit_price"]);//无税单价
                m.total_price = XTools.DBNullToDecimal(r["total_price"]);//无税金额
                m.d_remark = r["d_remark"].ToString();//备注
                m.d_sdefine1 = r["d_sdefine1"].ToString();
                m.d_sdefine2 = r["d_sdefine2"].ToString();
                m.d_sdefine3 = r["d_sdefine3"].ToString();
                m.d_sdefine4 = r["d_sdefine4"].ToString();
                m.d_sdefine5 = r["d_sdefine5"].ToString();
                m.d_ndefine1 = XTools.DBNullToDecimal(r["d_ndefine1"]);
                m.d_ndefine2 = XTools.DBNullToDecimal(r["d_ndefine2"]);
                m.d_ndefine3 = XTools.DBNullToDecimal(r["d_ndefine3"]);
                m.d_ndefine4 = XTools.DBNullToDecimal(r["d_ndefine4"]);
                m.d_ndefine5 = XTools.DBNullToDecimal(r["d_ndefine5"]);
            }
        }
        return m;
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(Transfers m)
    {
        string sql = @"update Stock_Transfers set
                        ts_id=@ts_id,i_id=@i_id,free1=@free1,free2=@free2,batch=@batch,
                        unit_price=@unit_price,total_price=@total_price,
                        quantity=@quantity,num=@num,convert_rate=@convert_rate,d_remark=@d_remark,
                        d_sdefine1=@d_sdefine1,d_sdefine2=@d_sdefine2,d_sdefine3=@d_sdefine3,
                        d_sdefine4=@d_sdefine4,d_sdefine5=@d_sdefine5,
                        d_ndefine1=@d_ndefine1,d_ndefine2=@d_ndefine2,d_ndefine3=@d_ndefine3,
                        d_ndefine4=@d_ndefine4,d_ndefine5=@d_ndefine5
                        where tss_id=@tss_id";
        SqlParameter[] par = {
            new SqlParameter("@tss_id",m.tss_id),
            new SqlParameter("@ts_id",m.ts_id),
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@free1",XTools.StringToDBNull(m.free1)),
            new SqlParameter("@free2",XTools.StringToDBNull(m.free2)),
            new SqlParameter("@batch",XTools.StringToDBNull(m.batch)),
            new SqlParameter("@quantity",XTools.DecimalToDBNull(m.quantity)),
            new SqlParameter("@num",XTools.DecimalToDBNull(m.num)),
            new SqlParameter("@unit_price",XTools.DecimalToDBNull(m.unit_price)),
            new SqlParameter("@total_price",XTools.DecimalToDBNull(m.total_price)),
            new SqlParameter("@convert_rate",XTools.DecimalToDBNull(m.convert_rate)),
            new SqlParameter("@d_remark",XTools.StringToDBNull(m.d_remark)),
            new SqlParameter("@d_sdefine1",XTools.StringToDBNull(m.d_sdefine1)),
            new SqlParameter("@d_sdefine2",XTools.StringToDBNull(m.d_sdefine2)),
            new SqlParameter("@d_sdefine3",XTools.StringToDBNull(m.d_sdefine3)),
            new SqlParameter("@d_sdefine4",XTools.StringToDBNull(m.d_sdefine4)),
            new SqlParameter("@d_sdefine5",XTools.StringToDBNull(m.d_sdefine5)),
            new SqlParameter("@d_ndefine1",XTools.DecimalToDBNull(m.d_ndefine1)),
            new SqlParameter("@d_ndefine2",XTools.DecimalToDBNull(m.d_ndefine2)),
            new SqlParameter("@d_ndefine3",XTools.DecimalToDBNull(m.d_ndefine3)),
            new SqlParameter("@d_ndefine4",XTools.DecimalToDBNull(m.d_ndefine4)),
            new SqlParameter("@d_ndefine5",XTools.DecimalToDBNull(m.d_ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除子表
    /// </summary>
    /// <param name="tss_id">子表ID</param>
    public void Delete(int tss_id)
    {
        Transfers m = new Transfers();
        string sql = "delete Stock_Transfers where tss_id=@tss_id";
        SqlParameter[] par = {
                new SqlParameter("@tss_id",tss_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除整单子表
    /// </summary>
    /// <param name="ts_id">主表ID</param>
    public void DeleteByOrder(int ts_id)
    {
        Transfers m = new Transfers();
        string sql = "delete Stock_Transfers where ts_id=@ts_id";
        SqlParameter[] par = {
                new SqlParameter("@ts_id",ts_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }

    //打印用的SQL
    public string sql_print = "";
    /// <summary>
    /// 得到单据表体
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        //列表查询用的sql
        string sql_list = @"
	               select d.ts_id,d.tss_id,
									d.i_id,d.free1,d.free2,d.batch,
									i.i_code,i.i_name,i.standard,i.munit,i.aunit,
									d.quantity,d.num,d.convert_rate,d.d_remark,
									d.unit_price,d.total_price,
                                    oh1.quantity as oh_quantity_in,oh2.quantity as oh_quantity_out,
									d.d_sdefine1,d.d_sdefine2,d.d_sdefine3,d.d_sdefine4,d.d_sdefine5,
									d.d_ndefine1,d.d_ndefine2,d.d_ndefine3,d.d_ndefine4,d.d_ndefine5,
									i.sdefine1 as d_inv_sdefine1,i.sdefine2 as d_inv_sdefine2,i.sdefine3 as d_inv_sdefine3,
									i.sdefine4 as d_inv_sdefine4,i.sdefine5 as d_inv_sdefine5,
									i.ndefine1 as d_inv_ndefine1,i.ndefine2 as d_inv_ndefine2,i.ndefine3 as d_inv_ndefine3,
									i.ndefine4 as d_inv_ndefine4,i.ndefine5 as d_inv_ndefine5
									from Stock_Transfers d
									left join Stock_Transfer t on d.ts_id=t.ts_id
									left join Base_Inventory i on d.i_id=i.i_id
									left join Stock_OnHand oh1 on oh1.wh_id=t.wh_id_in and oh1.i_id=d.i_id 
                                    and isnull(oh1.free1,'')=isnull(d.free1,'') and isnull(oh1.free2,'')=isnull(d.free2,'') 
									and isnull(oh1.batch,'')=isnull(d.batch,'')
                                    left join Stock_OnHand oh2 on oh2.wh_id=t.wh_id_out and oh2.i_id=d.i_id 
									and isnull(oh2.free1,'')=isnull(d.free1,'') and isnull(oh2.free2,'')=isnull(d.free2,'') 
									and isnull(oh2.batch,'')=isnull(d.batch,'')";
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(@sql_list)t
                where 1=1 ";
        sql = sql.Replace("@sql_list", sql_list)
            .Replace("@order_field", order_field)
            .Replace("@sql_select_field", sql_select_field);
        //打印是则不需要分页,只需要加上筛选条件
        sql_print = "select top 1000000000 * from (" + sql + ") t where 1=1 " + pg["sql_end"] + " " + pg["order_field"].ToString();
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from Stock_Transfers where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
    /// <summary>
    /// 得到某张单所有明细
    /// </summary>
    /// <param name="ts_id"></param>
    /// <returns></returns>
    public DataTable GetDetails(int ts_id)
    {
        string sql = "select * from Stock_Transfers where ts_id=@ts_id";
        SqlParameter[] par = {
            new SqlParameter("@ts_id", ts_id)
        };
        return new SqlUtil().GetDataTable(sql, par);
    }
    /// <summary>
    /// 更新采购订单累计入库数
    /// </summary>
    /// <param name="pos_id">采购订单子表id</param>
    /// <param name="quantity">入库数量</param>
    /// <param name="num">入库件数</param>
    public void UpdatePurchaseInQuantity(int? pos_id, decimal? quantity, decimal? num)
    {
        string sql = @"
                update Purchase_PurchaseOrders set
                acc_in_quantity=isnull(acc_in_quantity,0)+@quantity,
                acc_in_num=isnull(acc_in_num,0)+@num
                where pos_id=@pos_id";
        SqlParameter[] par = {
            new SqlParameter("@pos_id", pos_id),
            new SqlParameter("@quantity", quantity),
            new SqlParameter("@num", XTools.DecimalToDBNull(num))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }

    /// <summary>
    /// 得到某张单据表体总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetOneOrder_TotalNumbers(int ts_id)
    {
        string sql = "select count(1) from Stock_Transfers where ts_id=@ts_id ";
        SqlParameter[] par = {
                new SqlParameter("@ts_id",ts_id)
            };
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, par);
        return total_numbers;
    }

}
