﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class StockCountsDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(StockCounts m)
    {
        string sql = @"insert Stock_StockCounts(sc_id,i_id,free1,free2,batch,
                                quantity_zm,num_zm,quantity,num,convert_rate,d_remark,
                                d_sdefine1,d_sdefine2,d_sdefine3,d_sdefine4,d_sdefine5,
                                d_ndefine1,d_ndefine2,d_ndefine3,d_ndefine4,d_ndefine5)
                        select  @sc_id,@i_id,@free1,@free2,@batch,
                                @quantity_zm,@num_zm,@quantity,@num,@convert_rate,@d_remark,
                                @d_sdefine1,@d_sdefine2,@d_sdefine3,@d_sdefine4,@d_sdefine5,
                                @d_ndefine1,@d_ndefine2,@d_ndefine3,@d_ndefine4,@d_ndefine5";
        SqlParameter[] par = {
            new SqlParameter("@sc_id",m.sc_id),
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@free1",XTools.StringToDBNull(m.free1)),
            new SqlParameter("@free2",XTools.StringToDBNull(m.free2)),
            new SqlParameter("@batch",XTools.StringToDBNull(m.batch)),
            new SqlParameter("@quantity_zm",XTools.DecimalToDBNull(m.quantity_zm)),
            new SqlParameter("@num_zm",XTools.DecimalToDBNull(m.num_zm)),
            new SqlParameter("@quantity",XTools.DecimalToDBNull(m.quantity)),
            new SqlParameter("@num",XTools.DecimalToDBNull(m.num)),
            new SqlParameter("@convert_rate",XTools.DecimalToDBNull(m.convert_rate)),
            new SqlParameter("@d_remark",XTools.StringToDBNull(m.d_remark)),
            new SqlParameter("@d_sdefine1",XTools.StringToDBNull(m.d_sdefine1)),
            new SqlParameter("@d_sdefine2",XTools.StringToDBNull(m.d_sdefine2)),
            new SqlParameter("@d_sdefine3",XTools.StringToDBNull(m.d_sdefine3)),
            new SqlParameter("@d_sdefine4",XTools.StringToDBNull(m.d_sdefine4)),
            new SqlParameter("@d_sdefine5",XTools.StringToDBNull(m.d_sdefine5)),
            new SqlParameter("@d_ndefine1",XTools.DecimalToDBNull(m.d_ndefine1)),
            new SqlParameter("@d_ndefine2",XTools.DecimalToDBNull(m.d_ndefine2)),
            new SqlParameter("@d_ndefine3",XTools.DecimalToDBNull(m.d_ndefine3)),
            new SqlParameter("@d_ndefine4",XTools.DecimalToDBNull(m.d_ndefine4)),
            new SqlParameter("@d_ndefine5",XTools.DecimalToDBNull(m.d_ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">scs_id</param>
    /// <returns>StockCounts</returns>
    public StockCounts Get(int scs_id)
    {
        StockCounts m = new StockCounts();
        string sql = @"select d.*
                      from Stock_StockCounts d
                      where d.scs_id=@scs_id";
        sql = sql.Replace("@scs_id", scs_id.ToString());

        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, null))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.sc_id = Convert.ToInt32(r["sc_id"]);//主表id
                m.scs_id = Convert.ToInt32(r["scs_id"]);//子表id
                m.i_id = Convert.ToInt32(r["i_id"]);//存货id
                if (r["i_id"] != DBNull.Value)
                    m.inventory = new InventoryDAL().Get(m.i_id);
                m.free1 = r["free1"].ToString();
                m.free2 = r["free2"].ToString();
                m.batch = r["batch"].ToString();
                m.quantity_zm = XTools.DBNullToDecimal(r["quantity_zm"]);//账面数量
                m.num_zm = XTools.DBNullToDecimal(r["num_zm"]);//账面件数
                m.quantity = XTools.DBNullToDecimal(r["quantity"]);//盘点数量
                m.num = XTools.DBNullToDecimal(r["num"]);//盘点件数
                m.convert_rate = XTools.DBNullToDecimal(r["convert_rate"]);//换算率
                m.d_remark = r["d_remark"].ToString();//备注
                m.d_sdefine1 = r["d_sdefine1"].ToString();
                m.d_sdefine2 = r["d_sdefine2"].ToString();
                m.d_sdefine3 = r["d_sdefine3"].ToString();
                m.d_sdefine4 = r["d_sdefine4"].ToString();
                m.d_sdefine5 = r["d_sdefine5"].ToString();
                m.d_ndefine1 = XTools.DBNullToDecimal(r["d_ndefine1"]);
                m.d_ndefine2 = XTools.DBNullToDecimal(r["d_ndefine2"]);
                m.d_ndefine3 = XTools.DBNullToDecimal(r["d_ndefine3"]);
                m.d_ndefine4 = XTools.DBNullToDecimal(r["d_ndefine4"]);
                m.d_ndefine5 = XTools.DBNullToDecimal(r["d_ndefine5"]);
            }
        }
        return m;
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(StockCounts m)
    {
        string sql = @"update Stock_StockCounts set
                        sc_id=@sc_id,   
                        i_id=@i_id,free1=@free1,free2=@free2,batch=@batch,
                        quantity_zm=@quantity_zm,num_zm=@num_zm,
                        quantity=@quantity,num=@num,
                        convert_rate=@convert_rate,d_remark=@d_remark,
                        d_sdefine1=@d_sdefine1,d_sdefine2=@d_sdefine2,d_sdefine3=@d_sdefine3,
                        d_sdefine4=@d_sdefine4,d_sdefine5=@d_sdefine5,
                        d_ndefine1=@d_ndefine1,d_ndefine2=@d_ndefine2,d_ndefine3=@d_ndefine3,
                        d_ndefine4=@d_ndefine4,d_ndefine5=@d_ndefine5
                        where scs_id=@scs_id";
        SqlParameter[] par = {
            new SqlParameter("@scs_id",m.scs_id),
            new SqlParameter("@sc_id",m.sc_id),
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@free1",XTools.StringToDBNull(m.free1)),
            new SqlParameter("@free2",XTools.StringToDBNull(m.free2)),
            new SqlParameter("@batch",XTools.StringToDBNull(m.batch)),
            new SqlParameter("@quantity_zm",XTools.DecimalToDBNull(m.quantity_zm)),
            new SqlParameter("@num_zm",XTools.DecimalToDBNull(m.num_zm)),
            new SqlParameter("@quantity",XTools.DecimalToDBNull(m.quantity)),
            new SqlParameter("@num",XTools.DecimalToDBNull(m.num)),
            new SqlParameter("@convert_rate",XTools.DecimalToDBNull(m.convert_rate)),
            new SqlParameter("@d_remark",XTools.StringToDBNull(m.d_remark)),
            new SqlParameter("@d_sdefine1",XTools.StringToDBNull(m.d_sdefine1)),
            new SqlParameter("@d_sdefine2",XTools.StringToDBNull(m.d_sdefine2)),
            new SqlParameter("@d_sdefine3",XTools.StringToDBNull(m.d_sdefine3)),
            new SqlParameter("@d_sdefine4",XTools.StringToDBNull(m.d_sdefine4)),
            new SqlParameter("@d_sdefine5",XTools.StringToDBNull(m.d_sdefine5)),
            new SqlParameter("@d_ndefine1",XTools.DecimalToDBNull(m.d_ndefine1)),
            new SqlParameter("@d_ndefine2",XTools.DecimalToDBNull(m.d_ndefine2)),
            new SqlParameter("@d_ndefine3",XTools.DecimalToDBNull(m.d_ndefine3)),
            new SqlParameter("@d_ndefine4",XTools.DecimalToDBNull(m.d_ndefine4)),
            new SqlParameter("@d_ndefine5",XTools.DecimalToDBNull(m.d_ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除子表
    /// </summary>
    /// <param name="scs_id">子表ID</param>
    public void Delete(int scs_id)
    {
        StockCounts m = new StockCounts();
        string sql = "delete Stock_StockCounts where scs_id=@scs_id";
        SqlParameter[] par = {
                new SqlParameter("@scs_id",scs_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除整单子表
    /// </summary>
    /// <param name="sc_id">主表ID</param>
    public void DeleteByOrder(int sc_id)
    {
        StockCounts m = new StockCounts();
        string sql = "delete Stock_StockCounts where sc_id=@sc_id";
        SqlParameter[] par = {
                new SqlParameter("@sc_id",sc_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }

    //打印用的SQL
    public string sql_print = "";
    /// <summary>
    /// 得到单据表体
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        //列表查询用的sql
        string sql_list = @"
	                select d.sc_id,d.scs_id,
                    d.i_id,d.free1,d.free2,d.batch,
                    i.i_code,i.i_name,i.standard,i.munit,i.aunit,
                    d.quantity_zm,d.num_zm,
	                d.quantity,d.num,d.convert_rate,d.d_remark,
	                d.d_sdefine1,d.d_sdefine2,d.d_sdefine3,d.d_sdefine4,d.d_sdefine5,
	                d.d_ndefine1,d.d_ndefine2,d.d_ndefine3,d.d_ndefine4,d.d_ndefine5,
                    i.sdefine1 as d_inv_sdefine1,i.sdefine2 as d_inv_sdefine2,i.sdefine3 as d_inv_sdefine3,
                    i.sdefine4 as d_inv_sdefine4,i.sdefine5 as d_inv_sdefine5,
                    i.ndefine1 as d_inv_ndefine1,i.ndefine2 as d_inv_ndefine2,i.ndefine3 as d_inv_ndefine3,
                    i.ndefine4 as d_inv_ndefine4,i.ndefine5 as d_inv_ndefine5
	                from Stock_StockCounts d
	                left join Base_Inventory i on d.i_id=i.i_id";

        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(@sql_list)t
                where 1=1 ";
        sql = sql.Replace("@sql_list", sql_list)
            .Replace("@order_field", order_field)
            .Replace("@sql_select_field", sql_select_field);
        //打印是则不需要分页,只需要加上筛选条件
        sql_print = "select top 1000000000 * from (" + sql_list + ") t where 1=1 " + pg["sql_end"] + " " + pg["order_field"].ToString();
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from Stock_StockCounts where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
    /// <summary>
    /// 得到某张单所有明细
    /// </summary>
    /// <param name="sc_id"></param>
    /// <returns></returns>
    public DataTable GetDetails(int sc_id)
    {
        string sql = "select * from Stock_StockCounts where sc_id=@sc_id";
        SqlParameter[] par = {
            new SqlParameter("@sc_id", sc_id)
        };
        return new SqlUtil().GetDataTable(sql, par);
    }
    /// <summary>
    /// 得到某张单据表体总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetOneOrder_TotalNumbers(int sc_id)
    {
        string sql = "select count(1) from Stock_StockCounts where sc_id=@sc_id ";
        SqlParameter[] par = {
                new SqlParameter("@sc_id",sc_id)
            };
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, par);
        return total_numbers;
    }

    /// <summary>
    /// 通过存货得到账面数
    /// </summary>
    /// <param name="wh_id">仓库id</param>
    /// <param name="i_id">存货id</param>
    /// <param name="pd_date">盘点日期</param>
    public DataTable GetZhangMian(int wh_id,int i_id, DateTime? pd_date)
    {
        string sql = "";
        sql = @"
            select isnull(sum(quantity),0) as quantity_zm,isnull(sum(num),0) as num_zm
            from
            (
                select case when io_flag=1 then d.quantity else -d.quantity end as quantity,
                case when io_flag=1 then d.num else -d.num end as num
                from Stock_InOuts d
                left join Stock_InOut t on t.io_id=d.io_id
                where isnull(t.verify_uid,0)!=0
	            and t.new_date<=@pd_date and d.d_wh_id=@wh_id and d.i_id=@i_id
            )t;";
        SqlParameter[] par = {
            new SqlParameter("@wh_id", wh_id),
            new SqlParameter("@i_id", i_id),
            new SqlParameter("@pd_date", pd_date)
        };
        return new SqlUtil().GetDataTable(sql, par);
    }

    /// <summary>
    /// 得到某张单盘盈或盘亏明细
    /// </summary>
    /// <param name="sc_id"></param>
    /// <returns></returns>
    public DataTable GetDetails(int sc_id, int io_flag)
    {
        string sql = "select * from Stock_StockCounts where sc_id=@sc_id";
        if (io_flag == 1)
        {
            //盘盈=盘点数>账面数
            sql += " and isnull(quantity,0)>isnull(quantity_zm,0)";
        }
        else
        {
            //盘亏=盘点数<账面数
            sql += " and isnull(quantity,0)<isnull(quantity_zm,0)";
        }
        
        SqlParameter[] par = {
            new SqlParameter("@sc_id", sc_id)
        };
        return new SqlUtil().GetDataTable(sql, par);
    }

}
