﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class DeliveryOrdersDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(DeliveryOrders m)
    {
        string sql = @"insert Sale_DeliveryOrders(do_id,sos_id,d_wh_id,i_id,
                                free1,free2,batch,unit_price,tax_unit_price,quantity,num,convert_rate,
                                total_price,tax_total_price,tax,
                                nat_unit_price,nat_total_price,nat_tax_unit_price,
                                nat_tax_total_price,nat_tax,
                                d_tax_rate,delivery_date,d_remark,gcs_id,
                                quoted_price,kl,zk,
                                d_sdefine1,d_sdefine2,d_sdefine3,d_sdefine4,d_sdefine5,
                                d_ndefine1,d_ndefine2,d_ndefine3,d_ndefine4,d_ndefine5)
                        select  @do_id,@sos_id,@d_wh_id,@i_id,@free1,@free2,@batch,
                                @unit_price,@tax_unit_price,@quantity,@num,@convert_rate,
                                @total_price,@tax_total_price,@tax,
                                @nat_unit_price,@nat_total_price,@nat_tax_unit_price,
                                @nat_tax_total_price,@nat_tax,
                                @d_tax_rate,@delivery_date,@d_remark,@gcs_id,
                                @quoted_price,@kl,@zk,
                                @d_sdefine1,@d_sdefine2,@d_sdefine3,@d_sdefine4,@d_sdefine5,
                                @d_ndefine1,@d_ndefine2,@d_ndefine3,@d_ndefine4,@d_ndefine5";
        SqlParameter[] par = {
            new SqlParameter("@do_id",m.do_id),
            new SqlParameter("@sos_id",XTools.IntToDBNull(m.sos_id)),
            new SqlParameter("@d_wh_id",XTools.IntToDBNull(m.d_wh_id)),
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@free1",XTools.StringToDBNull(m.free1)),
            new SqlParameter("@free2",XTools.StringToDBNull(m.free2)),
            new SqlParameter("@batch",XTools.StringToDBNull(m.batch)),
            new SqlParameter("@unit_price",XTools.DecimalToDBNull(m.unit_price)),
            new SqlParameter("@tax_unit_price",XTools.DecimalToDBNull(m.tax_unit_price)),
            new SqlParameter("@quantity",XTools.DecimalToDBNull(m.quantity)),
            new SqlParameter("@num",XTools.DecimalToDBNull(m.num)),
            new SqlParameter("@convert_rate",XTools.DecimalToDBNull(m.convert_rate)),
            new SqlParameter("@total_price",XTools.DecimalToDBNull(m.total_price)),
            new SqlParameter("@tax_total_price",XTools.DecimalToDBNull(m.tax_total_price)),
            new SqlParameter("@tax",XTools.DecimalToDBNull(m.tax)),
            new SqlParameter("@nat_unit_price",XTools.DecimalToDBNull(m.nat_unit_price)),
            new SqlParameter("@nat_total_price",XTools.DecimalToDBNull(m.nat_total_price)),
            new SqlParameter("@nat_tax_unit_price",XTools.DecimalToDBNull(m.nat_tax_unit_price)),
            new SqlParameter("@nat_tax_total_price",XTools.DecimalToDBNull(m.nat_tax_total_price)),
            new SqlParameter("@nat_tax",XTools.DecimalToDBNull(m.nat_tax)),
            new SqlParameter("@d_tax_rate",XTools.DecimalToDBNull(m.d_tax_rate)),
            new SqlParameter("@delivery_date",XTools.DateTimeToDBNull(m.delivery_date)),
            new SqlParameter("@d_remark",XTools.StringToDBNull(m.d_remark)),
            new SqlParameter("@gcs_id",XTools.IntToDBNull(m.gcs_id)),
            new SqlParameter("@quoted_price",XTools.DecimalToDBNull(m.quoted_price)),
            new SqlParameter("@kl",XTools.DecimalToDBNull(m.kl)),
            new SqlParameter("@zk",XTools.DecimalToDBNull(m.zk)),
            new SqlParameter("@d_sdefine1",XTools.StringToDBNull(m.d_sdefine1)),
            new SqlParameter("@d_sdefine2",XTools.StringToDBNull(m.d_sdefine2)),
            new SqlParameter("@d_sdefine3",XTools.StringToDBNull(m.d_sdefine3)),
            new SqlParameter("@d_sdefine4",XTools.StringToDBNull(m.d_sdefine4)),
            new SqlParameter("@d_sdefine5",XTools.StringToDBNull(m.d_sdefine5)),
            new SqlParameter("@d_ndefine1",XTools.DecimalToDBNull(m.d_ndefine1)),
            new SqlParameter("@d_ndefine2",XTools.DecimalToDBNull(m.d_ndefine2)),
            new SqlParameter("@d_ndefine3",XTools.DecimalToDBNull(m.d_ndefine3)),
            new SqlParameter("@d_ndefine4",XTools.DecimalToDBNull(m.d_ndefine4)),
            new SqlParameter("@d_ndefine5",XTools.DecimalToDBNull(m.d_ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">dos_id</param>
    /// <returns>DeliveryOrders</returns>
    public DeliveryOrders Get(int dos_id)
    {
        DeliveryOrders m = new DeliveryOrders();
        string sql = @"select dos.*,so.order_number as so_order_number,sos.quantity as order_quantity,
                    round(dos.quoted_price*dos.quantity,2) as quoted_total_price,
                    i.sdefine1 as d_inv_sdefine1,i.sdefine2 as d_inv_sdefine2,i.sdefine3 as d_inv_sdefine3,
                    i.sdefine4 as d_inv_sdefine4,i.sdefine5 as d_inv_sdefine5,
                    i.ndefine1 as d_inv_ndefine1,i.ndefine2 as d_inv_ndefine2,i.ndefine3 as d_inv_ndefine3,
                    i.ndefine4 as d_inv_ndefine4,i.ndefine5 as d_inv_ndefine5
                    from Sale_DeliveryOrders dos 
                    left join Sale_SalesOrders sos on sos.sos_id=dos.sos_id
                    left join Sale_SalesOrder so on so.so_id=sos.so_id
                    left join Base_Inventory i on sos.i_id=i.i_id
                    where dos.dos_id=@dos_id";
        SqlParameter[] par = {
                new SqlParameter("@dos_id",dos_id)
            };
        DeliveryOrderDAL parent_dal = new DeliveryOrderDAL();
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.do_id = Convert.ToInt32(r["do_id"]);//主表id
                m.parent_object = parent_dal.Get(m.do_id);//父对象
                m.dos_id = Convert.ToInt32(r["dos_id"]);//子表id
                m.sos_id = XTools.DBNullToInt(r["sos_id"]);//订单子表id
                if (r["sos_id"] != DBNull.Value)
                {
                    m.sos_id = XTools.DBNullToInt(r["sos_id"]);//订单子表id
                    m.sales_orders = new SalesOrdersDAL().Get((int)m.sos_id);//订单实体
                    m.so_order_number = r["so_order_number"].ToString();
                }
                m.d_wh_id = XTools.DBNullToInt(r["d_wh_id"]);//仓库id
                if (r["d_wh_id"] != DBNull.Value)
                    m.warehouse = new WarehouseDAL().Get((int)m.d_wh_id);
                m.i_id = Convert.ToInt32(r["i_id"]);//存货id
                if(r["i_id"] != null)
                    m.inventory = new InventoryDAL().Get(m.i_id);
                m.free1 = r["free1"].ToString();
                m.free2 = r["free2"].ToString();
                m.batch = r["batch"].ToString();
                m.unit_price = XTools.DBNullToDecimal(r["unit_price"]);//无税单价
                m.tax_unit_price = XTools.DBNullToDecimal(r["tax_unit_price"]);//含税单价
                m.quantity = XTools.DBNullToDecimal(r["quantity"]);//数量
                m.num = XTools.DBNullToDecimal(r["num"]);//件数
                m.acc_out_quantity = XTools.DBNullToDecimal(r["acc_out_quantity"]);//累计出库数量
                m.acc_out_num = XTools.DBNullToDecimal(r["acc_out_num"]);//累计出库件数
                m.convert_rate = XTools.DBNullToDecimal(r["convert_rate"]);//换算率
                m.total_price = XTools.DBNullToDecimal(r["total_price"]);//无税金额
                m.tax_total_price = XTools.DBNullToDecimal(r["tax_total_price"]);//含税金额
                m.tax = XTools.DBNullToDecimal(r["tax"]);//税额
                m.nat_unit_price = XTools.DBNullToDecimal(r["nat_unit_price"]);//本币单价
                m.nat_total_price = XTools.DBNullToDecimal(r["nat_total_price"]);//本币金额
                m.nat_tax_unit_price = XTools.DBNullToDecimal(r["nat_tax_unit_price"]);//本币含税单价
                m.nat_tax_total_price = XTools.DBNullToDecimal(r["nat_tax_total_price"]);//本币含税金额
                m.nat_tax = XTools.DBNullToDecimal(r["nat_tax"]);//本币税额
                m.d_tax_rate = XTools.DBNullToDecimal(r["d_tax_rate"]);//税率
                m.quoted_price = XTools.DBNullToDecimal(r["quoted_price"]);//报价
                m.quoted_total_price = XTools.DBNullToDecimal(r["quoted_total_price"]);//报价金额
                m.kl = XTools.DBNullToDecimal(r["kl"]);//扣率
                m.zk = XTools.DBNullToDecimal(r["zk"]);//折扣额
                m.delivery_date = XTools.DBNullToTime(r["delivery_date"]);//预交货日期
                m.d_remark = r["d_remark"].ToString();//备注
                m.gcs_id = XTools.DBNullToInt(r["gcs_id"]);//促销套餐子表id
                m.d_sdefine1 = r["d_sdefine1"].ToString();
                m.d_sdefine2 = r["d_sdefine2"].ToString();
                m.d_sdefine3 = r["d_sdefine3"].ToString();
                m.d_sdefine4 = r["d_sdefine4"].ToString();
                m.d_sdefine5 = r["d_sdefine5"].ToString();
                m.d_ndefine1 = XTools.DBNullToDecimal(r["d_ndefine1"]);
                m.d_ndefine2 = XTools.DBNullToDecimal(r["d_ndefine2"]);
                m.d_ndefine3 = XTools.DBNullToDecimal(r["d_ndefine3"]);
                m.d_ndefine4 = XTools.DBNullToDecimal(r["d_ndefine4"]);
                m.d_ndefine5 = XTools.DBNullToDecimal(r["d_ndefine5"]);
            }
        }
        return m;
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(DeliveryOrders m)
    {
        string sql = @"update Sale_DeliveryOrders set
                        do_id=@do_id,d_wh_id=@d_wh_id,i_id=@i_id,
                        free1=@free1,free2=@free2,batch=@batch,unit_price=@unit_price,
                        tax_unit_price=@tax_unit_price,quantity=@quantity,num=@num,convert_rate=@convert_rate,
                        total_price=@total_price,tax_total_price=@tax_total_price,tax=@tax,
                        nat_unit_price=@nat_unit_price,nat_total_price=@nat_total_price,
                        nat_tax_unit_price=@nat_tax_unit_price,
                        nat_tax_total_price=@nat_tax_total_price,nat_tax=@nat_tax,
                        d_tax_rate=@d_tax_rate,delivery_date=@delivery_date,d_remark=@d_remark,
                        quoted_price=@quoted_price,kl=@kl,zk=@zk,
                        d_sdefine1=@d_sdefine1,d_sdefine2=@d_sdefine2,d_sdefine3=@d_sdefine3,
                        d_sdefine4=@d_sdefine4,d_sdefine5=@d_sdefine5,
                        d_ndefine1=@d_ndefine1,d_ndefine2=@d_ndefine2,d_ndefine3=@d_ndefine3,
                        d_ndefine4=@d_ndefine4,d_ndefine5=@d_ndefine5
                        where dos_id=@dos_id";
        SqlParameter[] par = {
            new SqlParameter("@dos_id",m.dos_id),
            new SqlParameter("@do_id",m.do_id),
            new SqlParameter("@d_wh_id",XTools.IntToDBNull(m.d_wh_id)),
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@free1",XTools.StringToDBNull(m.free1)),
            new SqlParameter("@free2",XTools.StringToDBNull(m.free2)),
            new SqlParameter("@batch",XTools.StringToDBNull(m.batch)),
            new SqlParameter("@unit_price",XTools.DecimalToDBNull(m.unit_price)),
            new SqlParameter("@tax_unit_price",XTools.DecimalToDBNull(m.tax_unit_price)),
            new SqlParameter("@quantity",XTools.DecimalToDBNull(m.quantity)),
            new SqlParameter("@num",XTools.DecimalToDBNull(m.num)),
            new SqlParameter("@convert_rate",XTools.DecimalToDBNull(m.convert_rate)),
            new SqlParameter("@total_price",XTools.DecimalToDBNull(m.total_price)),
            new SqlParameter("@tax_total_price",XTools.DecimalToDBNull(m.tax_total_price)),
            new SqlParameter("@tax",XTools.DecimalToDBNull(m.tax)),
            new SqlParameter("@nat_unit_price",XTools.DecimalToDBNull(m.nat_unit_price)),
            new SqlParameter("@nat_total_price",XTools.DecimalToDBNull(m.nat_total_price)),
            new SqlParameter("@nat_tax_unit_price",XTools.DecimalToDBNull(m.nat_tax_unit_price)),
            new SqlParameter("@nat_tax_total_price",XTools.DecimalToDBNull(m.nat_tax_total_price)),
            new SqlParameter("@nat_tax",XTools.DecimalToDBNull(m.nat_tax)),
            new SqlParameter("@d_tax_rate",XTools.DecimalToDBNull(m.d_tax_rate)),
            new SqlParameter("@quoted_price",XTools.DecimalToDBNull(m.quoted_price)),
            new SqlParameter("@kl",XTools.DecimalToDBNull(m.kl)),
            new SqlParameter("@zk",XTools.DecimalToDBNull(m.zk)),
            new SqlParameter("@delivery_date",XTools.DateTimeToDBNull(m.delivery_date)),
            new SqlParameter("@d_remark",XTools.StringToDBNull(m.d_remark)),
            new SqlParameter("@d_sdefine1",XTools.StringToDBNull(m.d_sdefine1)),
            new SqlParameter("@d_sdefine2",XTools.StringToDBNull(m.d_sdefine2)),
            new SqlParameter("@d_sdefine3",XTools.StringToDBNull(m.d_sdefine3)),
            new SqlParameter("@d_sdefine4",XTools.StringToDBNull(m.d_sdefine4)),
            new SqlParameter("@d_sdefine5",XTools.StringToDBNull(m.d_sdefine5)),
            new SqlParameter("@d_ndefine1",XTools.DecimalToDBNull(m.d_ndefine1)),
            new SqlParameter("@d_ndefine2",XTools.DecimalToDBNull(m.d_ndefine2)),
            new SqlParameter("@d_ndefine3",XTools.DecimalToDBNull(m.d_ndefine3)),
            new SqlParameter("@d_ndefine4",XTools.DecimalToDBNull(m.d_ndefine4)),
            new SqlParameter("@d_ndefine5",XTools.DecimalToDBNull(m.d_ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除子表
    /// </summary>
    /// <param name="dos_id">子表ID</param>
    public void Delete(int dos_id)
    {
        DeliveryOrders m = new DeliveryOrders();
        string sql = "delete Sale_DeliveryOrders where dos_id=@dos_id";
        SqlParameter[] par = {
                new SqlParameter("@dos_id",dos_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除整单子表
    /// </summary>
    /// <param name="do_id">主表ID</param>
    public void DeleteByOrder(int do_id)
    {
        DeliveryOrders m = new DeliveryOrders();
        string sql = "delete Sale_DeliveryOrders where do_id=@do_id";
        SqlParameter[] par = {
                new SqlParameter("@do_id",do_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    //打印用的SQL
    public string sql_print = "";
    /// <summary>
    /// 得到单据表体
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(
	                select d.do_id,d.dos_id,
                    d.d_wh_id,wh.wh_name as d_wh_name,d.i_id,d.free1,d.free2,d.batch,
                    i.i_code,i.i_name,i.standard,i.munit,i.aunit,
	                d.unit_price,d.tax_unit_price,d.quantity,d.num,d.convert_rate,d.total_price,
	                d.tax_total_price,d.tax,d.nat_unit_price,d.nat_total_price,
	                d.nat_tax_unit_price,d.nat_tax_total_price,d.nat_tax,d.d_tax_rate,
                    d.quoted_price,d.kl,d.zk,
                    round(d.quoted_price*d.quantity,2) as quoted_total_price,
	                convert(char(10),d.delivery_date,23) as delivery_date,
                    d.sos_id,so.order_number as so_order_number,sos.quantity as order_quantity,
                    d.acc_out_quantity,d.acc_out_num,d.d_remark,
	                d.d_sdefine1,d.d_sdefine2,d.d_sdefine3,d.d_sdefine4,d.d_sdefine5,
	                d.d_ndefine1,d.d_ndefine2,d.d_ndefine3,d.d_ndefine4,d.d_ndefine5,
                    i.sdefine1 as d_inv_sdefine1,i.sdefine2 as d_inv_sdefine2,i.sdefine3 as d_inv_sdefine3,
                    i.sdefine4 as d_inv_sdefine4,i.sdefine5 as d_inv_sdefine5,
                    i.ndefine1 as d_inv_ndefine1,i.ndefine2 as d_inv_ndefine2,i.ndefine3 as d_inv_ndefine3,
                    i.ndefine4 as d_inv_ndefine4,i.ndefine5 as d_inv_ndefine5
	                from Sale_DeliveryOrders d
	                left join Base_Inventory i on d.i_id=i.i_id
                    left join Base_Warehouse wh on d.d_wh_id=wh.wh_id
                    left join Sale_SalesOrders sos on sos.sos_id=d.sos_id
                    left join Sale_SalesOrder so on so.so_id=sos.so_id
                )t
                where 1=1 ";
        sql = sql.Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);
        sql_print = "select top 1000000000 * from (" + sql + ") t where 1=1 " + pg["sql_end"] + " " + pg["order_field"].ToString();
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到分页查询结果总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from Sale_DeliveryOrders where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }

    /// <summary>
    /// 得到某张单据表体总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetOneOrder_TotalNumbers(int do_id)
    {
        string sql = "select count(1) from Sale_DeliveryOrders where do_id=@do_id ";
        SqlParameter[] par = {
                new SqlParameter("@do_id",do_id)
            };
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, par);
        return total_numbers;
    }
    /// <summary>
    /// 得到某张单所有明细
    /// </summary>
    /// <param name="ts_id"></param>
    /// <returns></returns>
    public DataTable GetDetails(int do_id)
    {
        string sql = "select * from Sale_DeliveryOrders where do_id=@do_id";
        SqlParameter[] par = {
            new SqlParameter("@do_id", do_id)
        };
        return new SqlUtil().GetDataTable(sql, par);
    }
}
