﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class PurchaseOrdersDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(PurchaseOrders m)
    {
        string sql = @"insert Purchase_PurchaseOrders(po_id,i_id,free1,free2,unit_price,tax_unit_price,
                                quantity,num,convert_rate,
                                total_price,tax_total_price,tax,
                                nat_unit_price,nat_total_price,nat_tax_unit_price,
                                nat_tax_total_price,nat_tax,
                                d_tax_rate,arrive_date,d_remark,
                                d_sdefine1,d_sdefine2,d_sdefine3,d_sdefine4,d_sdefine5,
                                d_ndefine1,d_ndefine2,d_ndefine3,d_ndefine4,d_ndefine5)
                        select  @po_id,@i_id,@free1,@free2,@unit_price,@tax_unit_price,@quantity,@num,@convert_rate,
                                @total_price,@tax_total_price,@tax,
                                @nat_unit_price,@nat_total_price,@nat_tax_unit_price,
                                @nat_tax_total_price,@nat_tax,
                                @d_tax_rate,@arrive_date,@d_remark,
                                @d_sdefine1,@d_sdefine2,@d_sdefine3,@d_sdefine4,@d_sdefine5,
                                @d_ndefine1,@d_ndefine2,@d_ndefine3,@d_ndefine4,@d_ndefine5";
        SqlParameter[] par = {
            new SqlParameter("@po_id",m.po_id),
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@free1",m.free1),
            new SqlParameter("@free2",m.free2),
            new SqlParameter("@unit_price",XTools.DecimalToDBNull(m.unit_price)),
            new SqlParameter("@tax_unit_price",XTools.DecimalToDBNull(m.tax_unit_price)),
            new SqlParameter("@quantity",XTools.DecimalToDBNull(m.quantity)),
            new SqlParameter("@acc_in_quantity",XTools.DecimalToDBNull(m.acc_in_quantity)),
            new SqlParameter("@num",XTools.DecimalToDBNull(m.num)),
            new SqlParameter("@convert_rate",XTools.DecimalToDBNull(m.convert_rate)),
            new SqlParameter("@total_price",XTools.DecimalToDBNull(m.total_price)),
            new SqlParameter("@tax_total_price",XTools.DecimalToDBNull(m.tax_total_price)),
            new SqlParameter("@acc_pay_money",XTools.DecimalToDBNull(m.acc_pay_money)),
            new SqlParameter("@tax",XTools.DecimalToDBNull(m.tax)),
            new SqlParameter("@nat_unit_price",XTools.DecimalToDBNull(m.nat_unit_price)),
            new SqlParameter("@nat_total_price",XTools.DecimalToDBNull(m.nat_total_price)),
            new SqlParameter("@nat_tax_unit_price",XTools.DecimalToDBNull(m.nat_tax_unit_price)),
            new SqlParameter("@nat_tax_total_price",XTools.DecimalToDBNull(m.nat_tax_total_price)),
            new SqlParameter("@nat_tax",XTools.DecimalToDBNull(m.nat_tax)),
            new SqlParameter("@d_tax_rate",XTools.DecimalToDBNull(m.d_tax_rate)),
            new SqlParameter("@arrive_date",XTools.DateTimeToDBNull(m.arrive_date)),
            new SqlParameter("@d_remark",XTools.StringToDBNull(m.d_remark)),
            new SqlParameter("@d_sdefine1",XTools.StringToDBNull(m.d_sdefine1)),
            new SqlParameter("@d_sdefine2",XTools.StringToDBNull(m.d_sdefine2)),
            new SqlParameter("@d_sdefine3",XTools.StringToDBNull(m.d_sdefine3)),
            new SqlParameter("@d_sdefine4",XTools.StringToDBNull(m.d_sdefine4)),
            new SqlParameter("@d_sdefine5",XTools.StringToDBNull(m.d_sdefine5)),
            new SqlParameter("@d_ndefine1",XTools.DecimalToDBNull(m.d_ndefine1)),
            new SqlParameter("@d_ndefine2",XTools.DecimalToDBNull(m.d_ndefine2)),
            new SqlParameter("@d_ndefine3",XTools.DecimalToDBNull(m.d_ndefine3)),
            new SqlParameter("@d_ndefine4",XTools.DecimalToDBNull(m.d_ndefine4)),
            new SqlParameter("@d_ndefine5",XTools.DecimalToDBNull(m.d_ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">pos_id</param>
    /// <returns>PurchaseOrders</returns>
    public PurchaseOrders Get(int pos_id)
    {
        PurchaseOrders m = new PurchaseOrders();
        string sql = @"select d.*,
                    i.sdefine1 as d_inv_sdefine1,i.sdefine2 as d_inv_sdefine2,i.sdefine3 as d_inv_sdefine3,
                    i.sdefine4 as d_inv_sdefine4,i.sdefine5 as d_inv_sdefine5,
                    i.ndefine1 as d_inv_ndefine1,i.ndefine2 as d_inv_ndefine2,i.ndefine3 as d_inv_ndefine3,
                    i.ndefine4 as d_inv_ndefine4,i.ndefine5 as d_inv_ndefine5
                    from Purchase_PurchaseOrders d 
                    left join Base_Inventory i on d.i_id=i.i_id 
                    where d.pos_id=@pos_id";
        SqlParameter[] par = {
                new SqlParameter("@pos_id",pos_id)
            };
        PurchaseOrderDAL parent_dal = new PurchaseOrderDAL();
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                
                m.po_id = Convert.ToInt32(r["po_id"]);//主表id
                m.parent_object = parent_dal.Get(m.po_id);//父对象
                m.pos_id = Convert.ToInt32(r["pos_id"]);//子表id
                m.i_id = Convert.ToInt32(r["i_id"]);//存货id
                if(r["i_id"] != null)
                    m.inventory = new InventoryDAL().Get(m.i_id);
                m.free1 = r["free1"].ToString();
                m.free2 = r["free2"].ToString();
                m.unit_price = XTools.DBNullToDecimal(r["unit_price"]);//无税单价
                m.tax_unit_price = XTools.DBNullToDecimal(r["tax_unit_price"]);//含税单价
                m.quantity = XTools.DBNullToDecimal(r["quantity"]);//数量
                m.acc_in_quantity = XTools.DBNullToDecimal(r["acc_in_quantity"]);//累计入库数量
                m.acc_in_num = XTools.DBNullToDecimal(r["acc_in_num"]);//累计入库件数
                m.num = XTools.DBNullToDecimal(r["num"]);//件数
                m.convert_rate = XTools.DBNullToDecimal(r["convert_rate"]);//换算率
                m.total_price = XTools.DBNullToDecimal(r["total_price"]);//无税金额
                m.tax_total_price = XTools.DBNullToDecimal(r["tax_total_price"]);//含税金额
                m.acc_pay_money = XTools.DBNullToDecimal(r["acc_pay_money"]);//累计付款金额
                m.tax = XTools.DBNullToDecimal(r["tax"]);//税额
                m.nat_unit_price = XTools.DBNullToDecimal(r["nat_unit_price"]);//本币单价
                m.nat_total_price = XTools.DBNullToDecimal(r["nat_total_price"]);//本币金额
                m.nat_tax_unit_price = XTools.DBNullToDecimal(r["nat_tax_unit_price"]);//本币含税单价
                m.nat_tax_total_price = XTools.DBNullToDecimal(r["nat_tax_total_price"]);//本币含税金额
                m.nat_tax = XTools.DBNullToDecimal(r["nat_tax"]);//本币税额
                m.d_tax_rate = XTools.DBNullToDecimal(r["d_tax_rate"]);//税率
                m.arrive_date = XTools.DBNullToTime(r["arrive_date"]);//预交货日期
                m.d_remark = r["d_remark"].ToString();//备注
                m.d_sdefine1 = r["d_sdefine1"].ToString();
                m.d_sdefine2 = r["d_sdefine2"].ToString();
                m.d_sdefine3 = r["d_sdefine3"].ToString();
                m.d_sdefine4 = r["d_sdefine4"].ToString();
                m.d_sdefine5 = r["d_sdefine5"].ToString();
                m.d_ndefine1 = XTools.DBNullToDecimal(r["d_ndefine1"]);
                m.d_ndefine2 = XTools.DBNullToDecimal(r["d_ndefine2"]);
                m.d_ndefine3 = XTools.DBNullToDecimal(r["d_ndefine3"]);
                m.d_ndefine4 = XTools.DBNullToDecimal(r["d_ndefine4"]);
                m.d_ndefine5 = XTools.DBNullToDecimal(r["d_ndefine5"]);
            }
        }
        return m;
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(PurchaseOrders m)
    {
        string sql = @"update Purchase_PurchaseOrders set
                        po_id=@po_id,i_id=@i_id,free1=@free1,free2=@free2,unit_price=@unit_price,
                        tax_unit_price=@tax_unit_price,quantity=@quantity,
                        acc_in_quantity=@acc_in_quantity,
                        num=@num,convert_rate=@convert_rate,
                        total_price=@total_price,tax_total_price=@tax_total_price,
                        acc_pay_money=@acc_pay_money,tax=@tax,
                        nat_unit_price=@nat_unit_price,nat_total_price=@nat_total_price,
                        nat_tax_unit_price=@nat_tax_unit_price,
                        nat_tax_total_price=@nat_tax_total_price,nat_tax=@nat_tax,
                        d_tax_rate=@d_tax_rate,arrive_date=@arrive_date,d_remark=@d_remark,
                        d_sdefine1=@d_sdefine1,d_sdefine2=@d_sdefine2,d_sdefine3=@d_sdefine3,
                        d_sdefine4=@d_sdefine4,d_sdefine5=@d_sdefine5,
                        d_ndefine1=@d_ndefine1,d_ndefine2=@d_ndefine2,d_ndefine3=@d_ndefine3,
                        d_ndefine4=@d_ndefine4,d_ndefine5=@d_ndefine5
                        where pos_id=@pos_id";
        SqlParameter[] par = {
            new SqlParameter("@pos_id",m.pos_id),
            new SqlParameter("@po_id",m.po_id),
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@free1",XTools.StringToDBNull(m.free1)),
            new SqlParameter("@free2",XTools.StringToDBNull(m.free2)),
            new SqlParameter("@unit_price",XTools.DecimalToDBNull(m.unit_price)),
            new SqlParameter("@tax_unit_price",XTools.DecimalToDBNull(m.tax_unit_price)),
            new SqlParameter("@quantity",XTools.DecimalToDBNull(m.quantity)),
            new SqlParameter("@acc_in_quantity",XTools.DecimalToDBNull(m.acc_in_quantity)),
            new SqlParameter("@num",XTools.DecimalToDBNull(m.num)),
            new SqlParameter("@convert_rate",XTools.DecimalToDBNull(m.convert_rate)),
            new SqlParameter("@total_price",XTools.DecimalToDBNull(m.total_price)),
            new SqlParameter("@acc_pay_money",XTools.DecimalToDBNull(m.acc_pay_money)),
            new SqlParameter("@tax_total_price",XTools.DecimalToDBNull(m.tax_total_price)),
            new SqlParameter("@tax",XTools.DecimalToDBNull(m.tax)),
            new SqlParameter("@nat_unit_price",XTools.DecimalToDBNull(m.nat_unit_price)),
            new SqlParameter("@nat_total_price",XTools.DecimalToDBNull(m.nat_total_price)),
            new SqlParameter("@nat_tax_unit_price",XTools.DecimalToDBNull(m.nat_tax_unit_price)),
            new SqlParameter("@nat_tax_total_price",XTools.DecimalToDBNull(m.nat_tax_total_price)),
            new SqlParameter("@nat_tax",XTools.DecimalToDBNull(m.nat_tax)),
            new SqlParameter("@d_tax_rate",XTools.DecimalToDBNull(m.d_tax_rate)),
            new SqlParameter("@arrive_date",XTools.DateTimeToDBNull(m.arrive_date)),
            new SqlParameter("@d_remark",XTools.StringToDBNull(m.d_remark)),
            new SqlParameter("@d_sdefine1",XTools.StringToDBNull(m.d_sdefine1)),
            new SqlParameter("@d_sdefine2",XTools.StringToDBNull(m.d_sdefine2)),
            new SqlParameter("@d_sdefine3",XTools.StringToDBNull(m.d_sdefine3)),
            new SqlParameter("@d_sdefine4",XTools.StringToDBNull(m.d_sdefine4)),
            new SqlParameter("@d_sdefine5",XTools.StringToDBNull(m.d_sdefine5)),
            new SqlParameter("@d_ndefine1",XTools.DecimalToDBNull(m.d_ndefine1)),
            new SqlParameter("@d_ndefine2",XTools.DecimalToDBNull(m.d_ndefine2)),
            new SqlParameter("@d_ndefine3",XTools.DecimalToDBNull(m.d_ndefine3)),
            new SqlParameter("@d_ndefine4",XTools.DecimalToDBNull(m.d_ndefine4)),
            new SqlParameter("@d_ndefine5",XTools.DecimalToDBNull(m.d_ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除子表
    /// </summary>
    /// <param name="pos_id">子表ID</param>
    public void Delete(int pos_id)
    {
        PurchaseOrders m = new PurchaseOrders();
        string sql = "delete Purchase_PurchaseOrders where pos_id=@pos_id";
        SqlParameter[] par = {
                new SqlParameter("@pos_id",pos_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除整单子表
    /// </summary>
    /// <param name="po_id">主表ID</param>
    public void DeleteByOrder(int po_id)
    {
        PurchaseOrders m = new PurchaseOrders();
        string sql = "delete Purchase_PurchaseOrders where po_id=@po_id";
        SqlParameter[] par = {
                new SqlParameter("@po_id",po_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    //打印用的SQL
    public string sql_print = "";
    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(
        	        select d.pos_id,d.po_id,d.i_id,d.free1,d.free2,d.unit_price,d.tax_unit_price,
                    d.quantity,d.acc_in_quantity,d.acc_in_num,d.num,
                    d.convert_rate,d.total_price,d.tax_total_price,
                    tax,d.nat_unit_price,d.nat_total_price,d.nat_tax_unit_price,
                    d.nat_tax_total_price,d.nat_tax,d.d_tax_rate,
                    convert(char(10),d.arrive_date,23) as arrive_date,d.d_remark,
                    d.d_sdefine1,d.d_sdefine2,d.d_sdefine3,d.d_sdefine4,d.d_sdefine5,
                    d.d_ndefine1,d.d_ndefine2,d.d_ndefine3,d.d_ndefine4,d.d_ndefine5, 
                    i.sdefine1 as d_inv_sdefine1,i.sdefine2 as d_inv_sdefine2,i.sdefine3 as d_inv_sdefine3,
                    i.sdefine4 as d_inv_sdefine4,i.sdefine5 as d_inv_sdefine5,
                    i.ndefine1 as d_inv_ndefine1,i.ndefine2 as d_inv_ndefine2,i.ndefine3 as d_inv_ndefine3,
                    i.ndefine4 as d_inv_ndefine4,i.ndefine5 as d_inv_ndefine5,
                    d.acc_pay_money,i.i_code,i.i_name,i.standard,i.munit,i.aunit
	                from Purchase_PurchaseOrders d
	                left join Base_Inventory i on d.i_id=i.i_id
                )t
                where 1=1 ";
        sql = sql.Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);
        sql_print = "select top 1000000000 * from (" + sql + ") t where 1=1 " + pg["sql_end"] + " " + pg["order_field"].ToString();
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from Purchase_PurchaseOrders where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
    /// <summary>
    /// 得到单据总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetOneOrder_TotalNumbers(int po_id)
    {
        string sql = "select count(1) from Purchase_PurchaseOrders where po_id=@po_id ";
        SqlParameter[] par = {
                new SqlParameter("@po_id",po_id)
            };
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, par);
        return total_numbers;
    }
}
