﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class PMCsDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(PMCs m)
    {
        string sql = @"insert Plan_PMCs(pmc_id,d_wh_id,d_dep_id,i_id,free1,free2,
                                num,convert_rate,quantity,
                                bo_quantity,att_rate,plan_quantity,d_remark,
                                d_sdefine1,d_sdefine2,d_sdefine3,d_sdefine4,d_sdefine5,
                                d_ndefine1,d_ndefine2,d_ndefine3,d_ndefine4,d_ndefine5)
                        select  @pmc_id,@d_wh_id,@d_dep_id,@i_id,@free1,@free2,
                                @num,@convert_rate,@quantity,
                                @bo_quantity,@att_rate,@plan_quantity,@d_remark,
                                @d_sdefine1,@d_sdefine2,@d_sdefine3,@d_sdefine4,@d_sdefine5,
                                @d_ndefine1,@d_ndefine2,@d_ndefine3,@d_ndefine4,@d_ndefine5";
        SqlParameter[] par = {
            new SqlParameter("@pmc_id",m.pmc_id),
            new SqlParameter("@d_wh_id",XTools.IntToDBNull(m.d_wh_id)),
            new SqlParameter("@d_dep_id",XTools.IntToDBNull(m.d_dep_id)),
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@free1",XTools.StringToDBNull(m.free1)),
            new SqlParameter("@free2",XTools.StringToDBNull(m.free2)),
            new SqlParameter("@num",XTools.DecimalToDBNull(m.num)),
            new SqlParameter("@convert_rate",XTools.DecimalToDBNull(m.convert_rate)),
            new SqlParameter("@quantity",XTools.DecimalToDBNull(m.quantity)),
            new SqlParameter("@bo_quantity",XTools.DecimalToDBNull(m.bo_quantity)),
            new SqlParameter("@att_rate",XTools.DecimalToDBNull(m.att_rate)),
            new SqlParameter("@plan_quantity",XTools.DecimalToDBNull(m.plan_quantity)),
            new SqlParameter("@d_remark",XTools.StringToDBNull(m.d_remark)),
            new SqlParameter("@d_sdefine1",XTools.StringToDBNull(m.d_sdefine1)),
            new SqlParameter("@d_sdefine2",XTools.StringToDBNull(m.d_sdefine2)),
            new SqlParameter("@d_sdefine3",XTools.StringToDBNull(m.d_sdefine3)),
            new SqlParameter("@d_sdefine4",XTools.StringToDBNull(m.d_sdefine4)),
            new SqlParameter("@d_sdefine5",XTools.StringToDBNull(m.d_sdefine5)),
            new SqlParameter("@d_ndefine1",XTools.DecimalToDBNull(m.d_ndefine1)),
            new SqlParameter("@d_ndefine2",XTools.DecimalToDBNull(m.d_ndefine2)),
            new SqlParameter("@d_ndefine3",XTools.DecimalToDBNull(m.d_ndefine3)),
            new SqlParameter("@d_ndefine4",XTools.DecimalToDBNull(m.d_ndefine4)),
            new SqlParameter("@d_ndefine5",XTools.DecimalToDBNull(m.d_ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">pmcs_id</param>
    /// <returns>PMCs</returns>
    public PMCs Get(int pmcs_id)
    {
        PMCs m = new PMCs();
        string sql = @"select d.*
                      from Plan_PMCs d
                      where d.pmcs_id=@pmcs_id";
        sql = sql.Replace("@pmcs_id", pmcs_id.ToString());

        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, null))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.pmc_id = Convert.ToInt32(r["pmc_id"]);//主表id
                m.pmcs_id = Convert.ToInt32(r["pmcs_id"]);//子表id
                m.d_wh_id = XTools.DBNullToInt(r["d_wh_id"]);//仓库id
                if (r["d_wh_id"] != DBNull.Value)
                    m.warehouse = new WarehouseDAL().Get((int)m.d_wh_id);
                m.d_dep_id = XTools.DBNullToInt(r["d_dep_id"]);//部门id
                if (r["d_dep_id"] != DBNull.Value)
                    m.department = new DepartmentDAL().Get((int)m.d_dep_id);
                m.i_id = Convert.ToInt32(r["i_id"]);//存货id
                if (r["i_id"] != DBNull.Value)
                    m.inventory = new InventoryDAL().Get(m.i_id);
                m.free1 = r["free1"].ToString();
                m.free2 = r["free2"].ToString();
                m.quantity = XTools.DBNullToDecimal(r["quantity"]);//数量
                m.bo_quantity = XTools.DBNullToDecimal(r["bo_quantity"]);//单件用量
                m.num = XTools.DBNullToDecimal(r["num"]);//件数
                m.convert_rate = XTools.DBNullToDecimal(r["convert_rate"]);//换算率
                m.att_rate = XTools.DBNullToDecimal(r["att_rate"]);//损耗率
                m.plan_quantity = XTools.DBNullToDecimal(r["plan_quantity"]);//计划数量
                m.d_remark = r["d_remark"].ToString();//备注
                m.d_sdefine1 = r["d_sdefine1"].ToString();
                m.d_sdefine2 = r["d_sdefine2"].ToString();
                m.d_sdefine3 = r["d_sdefine3"].ToString();
                m.d_sdefine4 = r["d_sdefine4"].ToString();
                m.d_sdefine5 = r["d_sdefine5"].ToString();
                m.d_ndefine1 = XTools.DBNullToDecimal(r["d_ndefine1"]);
                m.d_ndefine2 = XTools.DBNullToDecimal(r["d_ndefine2"]);
                m.d_ndefine3 = XTools.DBNullToDecimal(r["d_ndefine3"]);
                m.d_ndefine4 = XTools.DBNullToDecimal(r["d_ndefine4"]);
                m.d_ndefine5 = XTools.DBNullToDecimal(r["d_ndefine5"]);
            }
        }
        return m;
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(PMCs m)
    {
        string sql = @"update Plan_PMCs set
                        pmc_id=@pmc_id,d_wh_id=@d_wh_id,d_dep_id=@d_dep_id,
                        i_id=@i_id,free1=@free1,free2=@free2,
                        quantity=@quantity,bo_quantity=@bo_quantity,
                        num=@num,convert_rate=@convert_rate,
                        att_rate=@att_rate,plan_quantity=@plan_quantity,d_remark=@d_remark,
                        d_sdefine1=@d_sdefine1,d_sdefine2=@d_sdefine2,d_sdefine3=@d_sdefine3,
                        d_sdefine4=@d_sdefine4,d_sdefine5=@d_sdefine5,
                        d_ndefine1=@d_ndefine1,d_ndefine2=@d_ndefine2,d_ndefine3=@d_ndefine3,
                        d_ndefine4=@d_ndefine4,d_ndefine5=@d_ndefine5
                        where pmcs_id=@pmcs_id";
        SqlParameter[] par = {
            new SqlParameter("@pmc_id",m.pmc_id),
            new SqlParameter("@pmcs_id",m.pmcs_id),
            new SqlParameter("@d_wh_id",XTools.IntToDBNull(m.d_wh_id)),
            new SqlParameter("@d_dep_id",XTools.IntToDBNull(m.d_dep_id)),
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@free1",XTools.StringToDBNull(m.free1)),
            new SqlParameter("@free2",XTools.StringToDBNull(m.free2)),
            new SqlParameter("@quantity",XTools.DecimalToDBNull(m.quantity)),
            new SqlParameter("@bo_quantity",XTools.DecimalToDBNull(m.bo_quantity)),
            new SqlParameter("@num",XTools.DecimalToDBNull(m.num)),
            new SqlParameter("@convert_rate",XTools.DecimalToDBNull(m.convert_rate)),
            new SqlParameter("@att_rate",XTools.DecimalToDBNull(m.att_rate)),
            new SqlParameter("@plan_quantity",XTools.DecimalToDBNull(m.plan_quantity)),
            new SqlParameter("@d_remark",XTools.StringToDBNull(m.d_remark)),
            new SqlParameter("@d_sdefine1",XTools.StringToDBNull(m.d_sdefine1)),
            new SqlParameter("@d_sdefine2",XTools.StringToDBNull(m.d_sdefine2)),
            new SqlParameter("@d_sdefine3",XTools.StringToDBNull(m.d_sdefine3)),
            new SqlParameter("@d_sdefine4",XTools.StringToDBNull(m.d_sdefine4)),
            new SqlParameter("@d_sdefine5",XTools.StringToDBNull(m.d_sdefine5)),
            new SqlParameter("@d_ndefine1",XTools.DecimalToDBNull(m.d_ndefine1)),
            new SqlParameter("@d_ndefine2",XTools.DecimalToDBNull(m.d_ndefine2)),
            new SqlParameter("@d_ndefine3",XTools.DecimalToDBNull(m.d_ndefine3)),
            new SqlParameter("@d_ndefine4",XTools.DecimalToDBNull(m.d_ndefine4)),
            new SqlParameter("@d_ndefine5",XTools.DecimalToDBNull(m.d_ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除子表
    /// </summary>
    /// <param name="pmcs_id">子表ID</param>
    public void Delete(int pmcs_id)
    {
        PMCs m = new PMCs();
        string sql = "delete Plan_PMCs where pmcs_id=@pmcs_id";
        SqlParameter[] par = {
                new SqlParameter("@pmcs_id",pmcs_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除整单子表
    /// </summary>
    /// <param name="pmc_id">主表ID</param>
    public void DeleteByOrder(int pmc_id)
    {
        PMCs m = new PMCs();
        string sql = "delete Plan_PMCs where pmc_id=@pmc_id";
        SqlParameter[] par = {
                new SqlParameter("@pmc_id",pmc_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }

    //打印用的SQL
    public string sql_print = "";
    /// <summary>
    /// 得到单据表体
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        //列表查询用的sql
        string sql_list = @"
	                select d.pmc_id,d.pmcs_id,
                    d.d_wh_id,wh.wh_name as d_wh_name,
                    d.d_dep_id,dep.dep_name as d_dep_name,
                    d.i_id,d.free1,d.free2,
                    i.i_code,i.i_name,i.standard,i.munit,i.aunit,
	                d.quantity,d.bo_quantity,d.num,d.convert_rate,d.att_rate,d.plan_quantity,d.d_remark,
	                d.d_sdefine1,d.d_sdefine2,d.d_sdefine3,d.d_sdefine4,d.d_sdefine5,
	                d.d_ndefine1,d.d_ndefine2,d.d_ndefine3,d.d_ndefine4,d.d_ndefine5,
                    i.sdefine1 as d_inv_sdefine1,i.sdefine2 as d_inv_sdefine2,i.sdefine3 as d_inv_sdefine3,
                    i.sdefine4 as d_inv_sdefine4,i.sdefine5 as d_inv_sdefine5,
                    i.ndefine1 as d_inv_ndefine1,i.ndefine2 as d_inv_ndefine2,i.ndefine3 as d_inv_ndefine3,
                    i.ndefine4 as d_inv_ndefine4,i.ndefine5 as d_inv_ndefine5
	                from Plan_PMCs d
	                left join Base_Inventory i on d.i_id=i.i_id
                    left join Base_Warehouse wh on d.d_wh_id=wh.wh_id
                    left join Base_Department dep on d.d_dep_id=dep.dep_id";
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(@sql_list)t
                where 1=1 ";
        sql = sql.Replace("@sql_list", sql_list)
            .Replace("@order_field", order_field)
            .Replace("@sql_select_field", sql_select_field);
        //打印是则不需要分页,只需要加上筛选条件
        sql_print = sql + " " + pg["sql_end"];
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from Plan_PMCs where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
    /// <summary>
    /// 得到某张单所有明细
    /// </summary>
    /// <param name="pmc_id"></param>
    /// <returns></returns>
    public DataTable GetDetails(int pmc_id)
    {
        string sql = "select * from Plan_PMCs where pmc_id=@pmc_id";
        SqlParameter[] par = {
            new SqlParameter("@pmc_id", pmc_id)
        };
        return new SqlUtil().GetDataTable(sql, par);
    }
    /// <summary>
    /// 得到某张单据表体总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetOneOrder_TotalNumbers(int pmc_id)
    {
        string sql = "select count(1) from Plan_PMCs where pmc_id=@pmc_id ";
        SqlParameter[] par = {
                new SqlParameter("@pmc_id",pmc_id)
            };
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, par);
        return total_numbers;
    }

}
