﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class WarehouseDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(Warehouse m)
    {
        string sql = @"insert Base_Warehouse(wh_code,wh_name,is_control_stock,is_stop)
                        select @wh_code,@wh_name,@is_control_stock,@is_stop";
        SqlParameter[] par = {
            new SqlParameter("@wh_code",m.wh_code),
            new SqlParameter("@wh_name",m.wh_name),
            new SqlParameter("@is_control_stock",m.is_control_stock),
            new SqlParameter("@is_stop",m.is_stop)
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">wh_id</param>
    /// <returns>Warehouse</returns>
    public Warehouse Get(int wh_id)
    {
        Warehouse m = new Warehouse();
        string sql = @"select *
                      from Base_Warehouse where wh_id=@wh_id";
        SqlParameter[] par = {
                new SqlParameter("@wh_id",wh_id)
            };
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.wh_id = Convert.ToInt32(r["wh_id"]);
                m.wh_code = r["wh_code"].ToString();
                m.wh_name = r["wh_name"].ToString();
                m.is_control_stock = XTools.DBNullToInt(r["is_control_stock"]);
                m.is_stop = XTools.DBNullToInt(r["is_stop"]);
            }
        }
        return m;
    }
    /// <summary>
    /// 通过编码得到ID
    /// </summary>
    /// <param name="编码">wh_code</param>
    /// <returns>int</returns>
    public int GetIdByCode(string wh_code)
    {
        InventoryClass m = new InventoryClass();
        string sql = @"select wh_id
                      from Base_Warehouse where wh_code=@wh_code";
        SqlParameter[] par = {
                new SqlParameter("@wh_code",wh_code)
            };
        return Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(Warehouse m)
    {
        string sql = @"update Base_Warehouse set 
                        wh_code=@wh_code,
                        wh_name=@wh_name,
                        is_control_stock=@is_control_stock,
                        is_stop=@is_stop
                       where wh_id=@wh_id";
        SqlParameter[] par = {
                new SqlParameter("@wh_code",m.wh_code),
                new SqlParameter("@wh_name",m.wh_name),
                new SqlParameter("@is_stop",m.is_stop),
                new SqlParameter("@is_control_stock",m.is_control_stock),
                new SqlParameter("@wh_id",m.wh_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除
    /// </summary>
    /// <param name="id">ID</param>
    public void Delete(int wh_id)
    {
        Warehouse m = new Warehouse();
        string sql = "delete Base_Warehouse where wh_id in (@wh_id)";
        SqlParameter[] par = {
                new SqlParameter("@wh_id",wh_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到所有仓库
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetListAll()
    {
        string sql = @"select * from Base_Warehouse order by wh_code";
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到所有仓库
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetListAllWhere(string where)
    {
        string sql = @"select * from Base_Warehouse @where order by wh_code";
        sql = sql.Replace("@where", where);
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 快速下拉查询
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetList_FastSearch(string keyword)
    {
        string sql = @"select top 10 wh_id,wh_code,wh_name from Base_Warehouse 
                       where isnull(is_stop,0)=0 and (wh_code like '%'+@keyword+'%' or wh_name like '%'+@keyword+'%')";
        //当前用户是否管理员
        bool is_admin = new AuthUI().CheckLoginUserIsAdmin();
        if (!is_admin)
        {
            //值为1代表启用仓库权限控制
            string system_wh_auth = new ConfigReader().GetConfig("system_wh_auth");
            if (system_wh_auth.Equals("1"))
            {
                sql += " and wh_id in (" + new AuthEx().GetSqlForMyWarehouse() + ")";
            }
        }
        sql += " order by wh_code";
        SqlParameter[] par ={
            new SqlParameter("@keyword",keyword)
        };
        DataTable dt = new SqlUtil().GetDataTable(sql, par);
        return dt;
    }
    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(
                    select *
                    from Base_Warehouse
                )t
                where 1=1 ";
        sql = sql.Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);

        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from Base_Warehouse where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
    /// <summary>
    /// 验证编码是否存在
    /// </summary>
    /// <param name="wh_code">编码</param>
    /// <returns>bool</returns>
    public bool CheckExist(string wh_code)
    {
        string sql = "select count(1) from Base_Warehouse where wh_code=@wh_code";
        SqlParameter[] par ={
                new SqlParameter("@wh_code", wh_code)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            return true;
        return false;
    }
}
