﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class VendorClassDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(VendorClass m)
    {
        string sql = @"insert Base_VendorClass(vc_code,vc_name,parent_id)
                        select @vc_code,@vc_name,@parent_id";
        SqlParameter[] par = {
            new SqlParameter("@vc_code",m.vc_code),
            new SqlParameter("@vc_name",m.vc_name),
            new SqlParameter("@parent_id",m.parent_id)
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">vc_id</param>
    /// <returns>VendorClass</returns>
    public VendorClass Get(int vc_id)
    {
        VendorClass m = new VendorClass();
        string sql = @"select *
                      from Base_VendorClass where vc_id=@vc_id";
        SqlParameter[] par = {
                new SqlParameter("@vc_id",vc_id)
            };
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.vc_id = Convert.ToInt32(r["vc_id"]);
                m.vc_code = r["vc_code"].ToString();
                m.vc_name = r["vc_name"].ToString();
                m.parent_id = XTools.DBNullToInt(r["parent_id"]);
                if (r["parent_id"] != null)
                {
                    m.parent = Get(Convert.ToInt32(r["parent_id"]));
                }
           }
        }
        return m;
    }
    /// <summary>
    /// 通过编码得到ID
    /// </summary>
    /// <param name="编码">vc_code</param>
    /// <returns>int</returns>
    public int GetIdByCode(string vc_code)
    {
        string sql = @"select vc_id
                      from Base_VendorClass where vc_code=@vc_code";
        SqlParameter[] par = {
                new SqlParameter("@vc_code",vc_code)
            };
        return Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
    }
    /// <summary>
    /// 通过ID得到编码
    /// </summary>
    /// <param name="ID">vc_id</param>
    /// <returns>int</returns>
    public string GetCodeById(int vc_id)
    {
        string sql = @"select vc_code
                      from Base_VendorClass where vc_id=@vc_id";
        SqlParameter[] par = {
                new SqlParameter("@vc_id",vc_id)
            };
        return new SqlUtil().ExecuteScalar(sql, par).ToString();
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(VendorClass m)
    {
        string sql = @"update Base_VendorClass set 
                        vc_code=@vc_code,
                        vc_name=@vc_name,
                        parent_id=@parent_id
                       where vc_id=@vc_id";
        SqlParameter[] par = {
                new SqlParameter("@vc_code",m.vc_code),
                new SqlParameter("@vc_name",m.vc_name),
                new SqlParameter("@parent_id",m.parent_id),
                new SqlParameter("@vc_id",m.vc_id),
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除
    /// </summary>
    /// <param name="id">ID</param>
    public void Delete(int vc_id)
    {
        VendorClass m = new VendorClass();
        string sql = "delete Base_VendorClass where vc_id in (@vc_id)";
        SqlParameter[] par = {
                new SqlParameter("@vc_id",vc_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到所有分类
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetListAll(string where)
    {
        string sql = @"select * from Base_VendorClass @where order by vc_id";
        sql = sql.Replace("@where", where);
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 验证编码是否存在
    /// </summary>
    /// <param name="vc_code">编码</param>
    /// <returns>bool</returns>
    public bool CheckExist(string vc_code)
    {
        string sql = "select count(1) from Base_VendorClass where vc_code=@vc_code";
        SqlParameter[] par ={
                new SqlParameter("@vc_code", vc_code)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            return true;
        return false;
    }
    /// <summary>
    /// 验证是否有子类
    /// </summary>
    /// <param name="vc_id">主键id</param>
    /// <returns>bool</returns>
    public bool CheckHasChild(int vc_id)
    {
        string sql = "select count(1) from Base_VendorClass where parent_id=@vc_id";
        SqlParameter[] par ={
                new SqlParameter("@vc_id", vc_id)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            return true;
        return false;
    }
    /// <summary>
    /// 验证编码是否与父级分类一致
    /// </summary>
    /// <param name="vc_code">编码</param>
    /// <returns>bool</returns>
    public bool CheckLikeParent(string vc_code, string parent_code)
    {
        bool like = false;
        //父级分类编码与当前分类编码的前几位不一样，代表规则不一致
        if (vc_code.Length <= parent_code.Length) return false;
        if (vc_code.Substring(0, parent_code.Length).Equals(parent_code))
            like = true;
        //如果除父级分类编码外，还有规则与当前编码一样的且长度大于父级编码的,代表规则不对
        string sql = @"select count(1) from Base_VendorClass 
                        where  @vc_code like vc_code+'%'
                        and vc_code not in (@parent_code,@vc_code)
                        and len(vc_code)>len(@parent_code)";
        SqlParameter[] par = {
                new SqlParameter("@vc_code",vc_code),
                new SqlParameter("@parent_code",parent_code)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            like = false;
        return like;
    }

    /// <summary>
    /// 更新分类级次
    /// </summary>
    /// <param name="parent_id">当前ID</param>
    /// <param name="layer">当前级次</param>
    public void FetchNodeAndUpdateLayer(int parent_id, int layer)
    {
        DataTable dt = GetListAll("where isnull(parent_id,0)=" + parent_id);
        SqlUtil su = new SqlUtil();
        foreach (DataRow dr in dt.Rows)
        {
            int cur_id = Convert.ToInt32(dr["vc_id"]);
            string vc_name = dr["vc_name"].ToString();
            string sql = "update Base_VendorClass set layer=" + layer + " where vc_id=" + cur_id;
            su.ExecuteNonQuery(sql, null);
            bool has_child = CheckHasChild(cur_id);
            if (has_child)
            {
                FetchNodeAndUpdateLayer(cur_id, layer + 1);
            }
        }
    }
}
