﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

/// <summary>
/// 结算方式
/// </summary>
public class SettleStyleDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(SettleStyle m)
    {
        string sql = "";
        if (m.is_default == 1)
        {
            //先清掉所有记录的默认值
            sql += "update Base_SettleStyle set is_default=0";
        }
        sql += @"insert Base_SettleStyle(ss_code,ss_name,is_default)
                select @ss_code,@ss_name,@is_default";
        SqlParameter[] par = {
            new SqlParameter("@ss_code",m.ss_code),
            new SqlParameter("@ss_name",m.ss_name),
            new SqlParameter("@is_default",m.is_default)
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">ss_id</param>
    /// <returns>SettleStyle</returns>
    public SettleStyle Get(int ss_id)
    {
        SettleStyle m = new SettleStyle();
        string sql = @"select *
                      from Base_SettleStyle where ss_id=@ss_id";
        SqlParameter[] par = {
                new SqlParameter("@ss_id",ss_id)
            };
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.ss_id = Convert.ToInt32(r["ss_id"]);
                m.ss_code = r["ss_code"].ToString();
                m.ss_name = r["ss_name"].ToString();
                m.is_default = XTools.DBNullToInt(r["is_default"]);
            }
        }
        return m;
    }
    /// <summary>
    /// 得到默认结算方式
    /// </summary>
    /// <returns>SettleStyle</returns>
    public SettleStyle GetDefault()
    {
        SettleStyle m = new SettleStyle();
        string sql = @"select ss_id from Base_SettleStyle where is_default=1";
        try
        {
            int ss_id = (int)new SqlUtil().ExecuteScalar(sql, null);
            return Get(ss_id);
        }
        catch
        {
            return null;
        }
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(SettleStyle m)
    {
        string sql = "";
        if (m.is_default == 1)
        {
            //先清掉所有记录的默认值
            sql += "update Base_SettleStyle set is_default=0";
        }
        sql += @"update Base_SettleStyle set 
                ss_code=@ss_code,
                ss_name=@ss_name,
                is_default=@is_default
                where ss_id=@ss_id";
        SqlParameter[] par = {
                new SqlParameter("@ss_code",m.ss_code),
                new SqlParameter("@ss_name",m.ss_name),
                new SqlParameter("@is_default",m.is_default),
                new SqlParameter("@ss_id",m.ss_id),
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除
    /// </summary>
    /// <param name="id">ID</param>
    public void Delete(int ss_id)
    {
        SettleStyle m = new SettleStyle();
        string sql = "delete Base_SettleStyle where ss_id in (@ss_id)";
        SqlParameter[] par = {
                new SqlParameter("@ss_id",ss_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到所有
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetListAll()
    {
        string sql = @"select * from Base_SettleStyle order by ss_id";
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 快速下拉查询
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetList_FastSearch(string keyword)
    {
        string sql = @"select top 10 ss_id,ss_code,ss_name from Base_SettleStyle where (ss_code like '%'+@keyword+'%' or ss_name like '%'+@keyword+'%') order by ss_code";
        SqlParameter[] par ={
            new SqlParameter("@keyword",keyword)
        };
        DataTable dt = new SqlUtil().GetDataTable(sql, par);
        return dt;
    }
    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(
                    select *,
                    case when is_default=1 then '是' else '否' end as is_default_name
                    from Base_SettleStyle
                )t
                where 1=1 ";
        sql = sql.Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);

        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from Base_SettleStyle where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
    /// <summary>
    /// 验证编码是否存在
    /// </summary>
    /// <param name="ss_code">编码</param>
    /// <returns>bool</returns>
    public bool CheckExist(string ss_code)
    {
        string sql = "select count(1) from Base_SettleStyle where ss_code=@ss_code";
        SqlParameter[] par ={
                new SqlParameter("@ss_code", ss_code)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            return true;
        return false;
    }
}
