﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

/// <summary>
/// 销售类型
/// </summary>
public class SaleTypeDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(SaleType m)
    {
        string sql = "";
        if (m.is_default == 1)
        {
            //先清掉所有记录的默认值
            sql += "update Base_SaleType set is_default=0";
        }
        sql += @"insert Base_SaleType(st_code,st_name,is_default)
                select @st_code,@st_name,@is_default";
        SqlParameter[] par = {
            new SqlParameter("@st_code",m.st_code),
            new SqlParameter("@st_name",m.st_name),
            new SqlParameter("@is_default",m.is_default)
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">st_id</param>
    /// <returns>SaleType</returns>
    public SaleType Get(int st_id)
    {
        SaleType m = new SaleType();
        string sql = @"select *
                      from Base_SaleType where st_id=@st_id";
        SqlParameter[] par = {
                new SqlParameter("@st_id",st_id)
            };
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.st_id = Convert.ToInt32(r["st_id"]);
                m.st_code = r["st_code"].ToString();
                m.st_name = r["st_name"].ToString();
                m.is_default = XTools.DBNullToInt(r["is_default"]);
            }
        }
        return m;
    }
    /// <summary>
    /// 得到默认销售类型
    /// </summary>
    /// <returns>SaleType</returns>
    public SaleType GetDefault()
    {
        SaleType m = new SaleType();
        string sql = @"select st_id from Base_SaleType where is_default=1";
        try
        {
            int st_id = (int)new SqlUtil().ExecuteScalar(sql, null);
            return Get(st_id);
        }
        catch
        {
            return null;
        }
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(SaleType m)
    {
        string sql = "";
        if (m.is_default == 1)
        {
            //先清掉所有记录的默认值
            sql += "update Base_SaleType set is_default=0";
        }
        sql += @"update Base_SaleType set 
                st_code=@st_code,
                st_name=@st_name,
                is_default=@is_default
                where st_id=@st_id";
        SqlParameter[] par = {
                new SqlParameter("@st_code",m.st_code),
                new SqlParameter("@st_name",m.st_name),
                new SqlParameter("@is_default",m.is_default),
                new SqlParameter("@st_id",m.st_id),
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除
    /// </summary>
    /// <param name="id">ID</param>
    public void Delete(int st_id)
    {
        SaleType m = new SaleType();
        string sql = "delete Base_SaleType where st_id in (@st_id)";
        SqlParameter[] par = {
                new SqlParameter("@st_id",st_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到所有
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetListAll()
    {
        string sql = @"select * from Base_SaleType order by st_id";
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 快速下拉查询
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetList_FastSearch(string keyword)
    {
        string sql = @"select top 10 st_id,st_code,st_name from Base_SaleType where (st_code like '%'+@keyword+'%' or st_name like '%'+@keyword+'%') order by st_code";
        SqlParameter[] par ={
            new SqlParameter("@keyword",keyword)
        };
        DataTable dt = new SqlUtil().GetDataTable(sql, par);
        return dt;
    }
    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(
                    select *,
                    case when is_default=1 then '是' else '否' end as is_default_name
                    from Base_SaleType
                )t
                where 1=1 ";
        sql = sql.Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);

        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from Base_SaleType where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
    /// <summary>
    /// 验证编码是否存在
    /// </summary>
    /// <param name="st_code">编码</param>
    /// <returns>bool</returns>
    public bool CheckExist(string st_code)
    {
        string sql = "select count(1) from Base_SaleType where st_code=@st_code";
        SqlParameter[] par ={
                new SqlParameter("@st_code", st_code)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            return true;
        return false;
    }
    /// <summary>
    /// 通过编码得到ID
    /// </summary>
    /// <param name="编码">st_code</param>
    /// <returns>int</returns>
    public int GetIdByCode(string st_code)
    {
        string sql = @"select st_id
                      from Base_SaleType where st_code=@st_code";
        SqlParameter[] par = {
                new SqlParameter("@st_code",st_code)
            };
        return Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
    }
}
