﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class RunningNumberRuleDAL
{
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">module_code</param>
    /// <returns>RunningNumberRule</returns>
    public RunningNumberRule Get(string module_code)
    {
        RunningNumberRule m = new RunningNumberRule();
        string sql = @"select * from Base_RunningNumberRule where module_code=@module_code";
        SqlParameter[] par = {
                new SqlParameter("@module_code",module_code)
            };
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.module_code = r["module_code"].ToString();
                m.rule1 = r["rule1"].ToString();
                m.rule1_value = r["rule1_value"].ToString();
                m.rule2 = r["rule2"].ToString();
                m.rule2_value = r["rule2_value"].ToString();
                m.rule3 = r["rule3"].ToString();
                m.rule3_value = r["rule3_value"].ToString();
                m.length = Convert.ToInt32(r["length"]);
            }
        }
        return m;
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(RunningNumberRule m)
    {
        string sql = @"update Base_RunningNumberRule set 
                        rule1=@rule1,
                        rule2=@rule2,
                        rule3=@rule3,
                        rule1_value=@rule1_value,
                        rule2_value=@rule2_value,
                        rule3_value=@rule3_value,
                        length=@length
                       where module_code=@module_code";
        SqlParameter[] par = {
                new SqlParameter("@rule1",XTools.StringToDBNull(m.rule1)),
                new SqlParameter("@rule2",XTools.StringToDBNull(m.rule2)),
                new SqlParameter("@rule3",XTools.StringToDBNull(m.rule3)),
                new SqlParameter("@rule1_value",XTools.StringToDBNull(m.rule1_value)),
                new SqlParameter("@rule2_value",XTools.StringToDBNull(m.rule2_value)),
                new SqlParameter("@rule3_value",XTools.StringToDBNull(m.rule3_value)),
                new SqlParameter("@length",m.length),
                new SqlParameter("@module_code",m.module_code)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到指定模块流水号前缀
    /// </summary>
    /// <param name="module">模块号</param>
    /// <returns>流水号前缀</returns>
    public string GetModuleRunningNumber(string module, Hashtable ht_num)
    {
        RunningNumberRuleDAL num_dal = new RunningNumberRuleDAL();
        RunningNumberRule rnr = num_dal.Get(module);
        string prefix = rnr.rule1_value + rnr.rule2_value + rnr.rule3_value;
        string year = DateTime.Now.Year.ToString();
        string month = DateTime.Now.Month.ToString();
        string day = DateTime.Now.Day.ToString();
        if (month.Length == 1) month = "0" + month;
        if (day.Length == 1) day = "0" + day;
        prefix = prefix.Replace("[year]", year)
                       .Replace("[month]", month)
                       .Replace("[day]", day);
        
        foreach (DictionaryEntry de in ht_num)
        {
            if (de.Value != null)
            {
                prefix = prefix.Replace(de.Key.ToString(), de.Value.ToString());
            }
        }
        
        RunningNumberDAL rn_dal = new RunningNumberDAL();

        RunningNumber rn = rn_dal.Get(module, prefix);
        
        if(rn.module_code==null){
            rn.module_code = module;
            rn.seed = prefix;
            rn.current_number = 1;
            rn_dal.Add(rn);
        }else{
            
            rn.current_number = rn.current_number + 1;
            rn_dal.Update(rn);
        }

        int current = rn.current_number;
        
        int length = rnr.length;
        string str = "";
        for(int i=0;i<length;i++){
            str += "0";
        }
        str = str.Substring(0, str.Length - current.ToString().Length) + current.ToString();

        return prefix + str;
    }
}
