﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class RunningNumberPrefixDAL
{
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">rnp_id</param>
    /// <returns>RunningNumberPrefix</returns>
    public RunningNumberPrefix Get(int rnp_id)
    {
        RunningNumberPrefix m = new RunningNumberPrefix();
        string sql = @"select * from Base_RunningNumberPrefix where rnp_id=@rnp_id";
        SqlParameter[] par = {
                new SqlParameter("@rnp_id",rnp_id)
            };
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.rnp_id = Convert.ToInt32(r["rnp_id"]);
                m.module_code = r["module_code"].ToString();
                m.prefix_code = r["prefix_code"].ToString();
                m.prefix_name = r["prefix_name"].ToString();
                m.link_table = r["link_table"].ToString();
            }
        }
        return m;
    }
    /// <summary>
    /// 通过模块号得到前缀
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetListByModule(string module_code)
    {
        string sql = @"select rnp_id,module_code,prefix_code,prefix_name,link_table from Base_RunningNumberPrefix 
                       where module_code=@module_code order by prefix_code";
        SqlParameter[] par ={
            new SqlParameter("@module_code",module_code)
        };
        DataTable dt = new SqlUtil().GetDataTable(sql, par);
        return dt;
    }

}
