﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class RunningNumberDAL
{
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">module_code</param>
    /// <returns>RunningNumber</returns>
    public RunningNumber Get(string module_code,string seed)
    {
        RunningNumber m = new RunningNumber();
        string sql = @"select * from Base_RunningNumber where module_code=@module_code and seed=@seed order by rn_id";
        SqlParameter[] par = {
                new SqlParameter("@module_code",module_code),
                new SqlParameter("@seed",seed)
            };
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.module_code = r["module_code"].ToString();
                m.rn_id = Convert.ToInt32(r["rn_id"]);
                m.seed = r["seed"].ToString();
                m.current_number = Convert.ToInt32(r["current_number"]);
            }
        }
        return m;
    }

    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(RunningNumber m)
    {
        string sql = @"insert Base_RunningNumber(module_code,seed,current_number)
                       select @module_code,@seed,@current_number";
        SqlParameter[] par = {
                new SqlParameter("@module_code",m.module_code),
                new SqlParameter("@seed",m.seed),
                new SqlParameter("@current_number",m.current_number)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(RunningNumber m)
    {
        string sql = @"update Base_RunningNumber set 
                        module_code=@module_code,
                        seed=@seed,
                        current_number=@current_number
                       where module_code=@module_code and isnull(seed,'')=@seed";
        SqlParameter[] par = {
                new SqlParameter("@module_code",m.module_code),
                new SqlParameter("@seed",m.seed),
                new SqlParameter("@current_number",m.current_number)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到列表
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,* 
                from(
                    select rn_id,module_code,seed,current_number
                    from Base_RunningNumber
                )t
                where 1=1 ";
        sql = sql.Replace("@order_field", order_field);

        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from Base_RunningNumber where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
}
