﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class PurchaseTypeDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(PurchaseType m)
    {
        string sql = "";
        if (m.is_default == 1)
        {
            //先清掉所有记录的默认值
            sql += "update Base_PurchaseType set is_default=0";
        }
        sql += @"insert Base_PurchaseType(pt_code,pt_name,is_default)
                select @pt_code,@pt_name,@is_default";
        SqlParameter[] par = {
            new SqlParameter("@pt_code",m.pt_code),
            new SqlParameter("@pt_name",m.pt_name),
            new SqlParameter("@is_default",m.is_default),
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">pt_id</param>
    /// <returns>PurchaseType</returns>
    public PurchaseType Get(int pt_id)
    {
        PurchaseType m = new PurchaseType();
        string sql = @"select *
                      from Base_PurchaseType where pt_id=@pt_id";
        SqlParameter[] par = {
                new SqlParameter("@pt_id",pt_id)
            };
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.pt_id = Convert.ToInt32(r["pt_id"]);
                m.pt_code = r["pt_code"].ToString();
                m.pt_name = r["pt_name"].ToString();
                m.is_default = XTools.DBNullToInt(r["is_default"]);
            }
        }
        return m;
    }
    /// <summary>
    /// 快速下拉查询
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetList_FastSearch(string keyword)
    {
        string sql = @"select top 10 pt_id,pt_code,pt_name from Base_PurchaseType where (pt_code like '%'+@keyword+'%' or pt_name like '%'+@keyword+'%') order by pt_code";
        SqlParameter[] par ={
            new SqlParameter("@keyword",keyword)
        };
        DataTable dt = new SqlUtil().GetDataTable(sql, par);
        return dt;
    }
    /// <summary>
    /// 得到默认采购类型
    /// </summary>
    /// <returns>PurchaseType</returns>
    public PurchaseType GetDefault()
    {
        PurchaseType m = new PurchaseType();
        string sql = @"select pt_id from Base_PurchaseType where is_default=1";
        try
        {
            int pt_id = (int)new SqlUtil().ExecuteScalar(sql, null);
            return Get(pt_id);
        }catch
        {
            return null;
        }
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(PurchaseType m)
    {
        string sql = "";
        if (m.is_default == 1)
        {
            //先清掉所有记录的默认值
            sql += "update Base_PurchaseType set is_default=0";
        }
        sql += @"update Base_PurchaseType set 
                pt_code=@pt_code,
                pt_name=@pt_name,
                is_default=@is_default
                where pt_id=@pt_id";
        SqlParameter[] par = {
                new SqlParameter("@pt_code",m.pt_code),
                new SqlParameter("@pt_name",m.pt_name),
                new SqlParameter("@is_default",m.is_default),
                new SqlParameter("@pt_id",m.pt_id),
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除
    /// </summary>
    /// <param name="id">ID</param>
    public void Delete(int pt_id)
    {
        PurchaseType m = new PurchaseType();
        string sql = "delete Base_PurchaseType where pt_id in (@pt_id)";
        SqlParameter[] par = {
                new SqlParameter("@pt_id",pt_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到所有
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetListAll()
    {
        string sql = @"select * from Base_PurchaseType order by pt_id";
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(
                    select *,
                    case when is_default=1 then '是' else '否' end as is_default_name
                    from Base_PurchaseType
                )t
                where 1=1 ";
        sql = sql.Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);

        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetLipt_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from Base_PurchaseType where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
    /// <summary>
    /// 验证编码是否存在
    /// </summary>
    /// <param name="pt_code">编码</param>
    /// <returns>bool</returns>
    public bool CheckExist(string pt_code)
    {
        string sql = "select count(1) from Base_PurchaseType where pt_code=@pt_code";
        SqlParameter[] par ={
                new SqlParameter("@pt_code", pt_code)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            return true;
        return false;
    }
}
