﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class InventoryPhotoDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(InventoryPhoto m)
    {
        string sql = @"insert Base_InventoryPhoto(i_id,pic_url,small_pic_url)
                        select @i_id,@pic_url,@small_pic_url";
        SqlParameter[] par = {
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@pic_url",m.pic_url),
            new SqlParameter("@small_pic_url",m.small_pic_url)
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 通过存货id得到图片
    /// </summary>
    /// <param name="存货id">i_id</param>
    /// <returns>InventoryPhoto</returns>
    public InventoryPhoto GetByInventory(int i_id)
    {
        InventoryPhoto m = new InventoryPhoto();
        string sql = @"select *
                      from Base_InventoryPhoto where i_id=@i_id";
        SqlParameter[] par = {
                new SqlParameter("@i_id",i_id)
            };
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.ip_id = Convert.ToInt32(r["ip_id"]);
                m.i_id = Convert.ToInt32(r["i_id"]);
                m.pic_url = r["pic_url"].ToString();
                m.small_pic_url = r["small_pic_url"].ToString();
            }
        }
        return m;
    }
    /// <summary>
    /// 通过存货id更新图片
    /// </summary>
    /// <param name="m">实体</param>
    public void UpdateByInventory(InventoryPhoto m)
    {
        string sql = @"update Base_InventoryPhoto set 
                        i_id=@i_id,
                        pic_url=@pic_url,
                        small_pic_url=@small_pic_url
                       where i_id=@i_id";
        SqlParameter[] par = {
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@pic_url",m.pic_url),
            new SqlParameter("@small_pic_url",m.small_pic_url)
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 通过存货id删除图片
    /// </summary>
    /// <param name="i_id">存货id</param>
    public void DeleteByInventory(int i_id)
    {
        InventoryPhoto m = new InventoryPhoto();
        string sql = "delete Base_InventoryPhoto where i_id in (@i_id)";
        SqlParameter[] par = {
                new SqlParameter("@i_id",i_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    
    /// <summary>
    /// 验证存货图片是否存在
    /// </summary>
    /// <param name="i_id">编码</param>
    /// <returns>bool</returns>
    public bool CheckExist(int i_id)
    {
        string sql = "select count(1) from Base_InventoryPhoto where i_id=@i_id";
        SqlParameter[] par ={
                new SqlParameter("@i_id", i_id)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            return true;
        return false;
    }
}
