﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class InventoryClassDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(InventoryClass m)
    {
        string sql = @"insert Base_InventoryClass(ic_code,ic_name,parent_id)
                        select @ic_code,@ic_name,@parent_id";
        SqlParameter[] par = {
            new SqlParameter("@ic_code",m.ic_code),
            new SqlParameter("@ic_name",m.ic_name),
            new SqlParameter("@parent_id",m.parent_id)
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 通过ID得到实体
    /// </summary>
    /// <param name="主键id">ic_id</param>
    /// <returns>InventoryClass</returns>
    public InventoryClass Get(int ic_id)
    {
        InventoryClass m = new InventoryClass();
        string sql = @"select *
                      from Base_InventoryClass where ic_id=@ic_id";
        SqlParameter[] par = {
                new SqlParameter("@ic_id",ic_id)
            };
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.ic_id = Convert.ToInt32(r["ic_id"]);
                m.ic_code = r["ic_code"].ToString();
                m.ic_name = r["ic_name"].ToString();
                m.parent_id = XTools.DBNullToInt(r["parent_id"]);
                if (r["parent_id"] != null)
                {
                    m.parent = Get(Convert.ToInt32(r["parent_id"]));
                }
           }
        }
        return m;
    }
    /// <summary>
    /// 通过编码得到ID
    /// </summary>
    /// <param name="编码">ic_code</param>
    /// <returns>int</returns>
    public int GetIdByCode(string ic_code)
    {
        string sql = @"select ic_id
                      from Base_InventoryClass where ic_code=@ic_code";
        SqlParameter[] par = {
                new SqlParameter("@ic_code",ic_code)
            };
        return Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
    }
    /// <summary>
    /// 通过ID得到编码
    /// </summary>
    /// <param name="ID">ic_id</param>
    /// <returns>int</returns>
    public string GetCodeById(int ic_id)
    {
        string sql = @"select ic_code
                      from Base_InventoryClass where ic_id=@ic_id";
        SqlParameter[] par = {
                new SqlParameter("@ic_id",ic_id)
            };
        return new SqlUtil().ExecuteScalar(sql, par).ToString();
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(InventoryClass m)
    {
        string sql = @"update Base_InventoryClass set 
                        ic_code=@ic_code,
                        ic_name=@ic_name,
                        parent_id=@parent_id
                       where ic_id=@ic_id";
        SqlParameter[] par = {
                new SqlParameter("@ic_code",m.ic_code),
                new SqlParameter("@ic_name",m.ic_name),
                new SqlParameter("@parent_id",m.parent_id),
                new SqlParameter("@ic_id",m.ic_id),
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除
    /// </summary>
    /// <param name="id">ID</param>
    public void Delete(int ic_id)
    {
        InventoryClass m = new InventoryClass();
        string sql = "delete Base_InventoryClass where ic_id in (@ic_id)";
        SqlParameter[] par = {
                new SqlParameter("@ic_id",ic_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到所有分类
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetListAll(string where)
    {
        string sql = @"select * from Base_InventoryClass @where order by ic_code";
        sql = sql.Replace("@where", where);
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 验证编码是否存在
    /// </summary>
    /// <param name="ic_code">编码</param>
    /// <returns>bool</returns>
    public bool CheckExist(string ic_code)
    {
        string sql = "select count(1) from Base_InventoryClass where ic_code=@ic_code";
        SqlParameter[] par ={
                new SqlParameter("@ic_code", ic_code)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            return true;
        return false;
    }
    /// <summary>
    /// 验证是否有子类
    /// </summary>
    /// <param name="ic_id">主键id</param>
    /// <returns>bool</returns>
    public bool CheckHasChild(int ic_id)
    {
        string sql = "select count(1) from Base_InventoryClass where parent_id=@ic_id";
        SqlParameter[] par ={
                new SqlParameter("@ic_id", ic_id)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            return true;
        return false;
    }
    /// <summary>
    /// 验证编码是否与父级分类一致
    /// </summary>
    /// <param name="ic_code">编码</param>
    /// <returns>bool</returns>
    public bool CheckLikeParent(string ic_code, string parent_code)
    {
        bool like = false;
        //父级分类编码与当前分类编码的前几位不一样，代表规则不一致
        if (ic_code.Length <= parent_code.Length) return false;
        if (ic_code.Substring(0, parent_code.Length).Equals(parent_code))
            like = true;
        //如果除父级分类编码外，还有规则与当前编码一样的且长度大于父级编码的,代表规则不对
        string sql = @"select count(1) from Base_InventoryClass 
                        where  @ic_code like ic_code+'%'
                        and ic_code not in (@parent_code,@ic_code)
                        and len(ic_code)>len(@parent_code)";
        SqlParameter[] par = {
                new SqlParameter("@ic_code",ic_code),
                new SqlParameter("@parent_code",parent_code)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            like = false;
        return like;
    }

    /// <summary>
    /// 更新分类级次
    /// </summary>
    /// <param name="parent_id">当前ID</param>
    /// <param name="layer">当前级次</param>
    public void FetchNodeAndUpdateLayer(int parent_id, int layer)
    {
        DataTable dt = GetListAll("where isnull(parent_id,0)=" + parent_id);
        SqlUtil su = new SqlUtil();
        foreach (DataRow dr in dt.Rows)
        {
            int cur_id = Convert.ToInt32(dr["ic_id"]);
            string ic_name = dr["ic_name"].ToString();
            string sql = "update Base_InventoryClass set layer=" + layer + " where ic_id=" + cur_id;
            su.ExecuteNonQuery(sql, null);
            bool has_child = CheckHasChild(cur_id);
            if (has_child)
            {
                FetchNodeAndUpdateLayer(cur_id, layer + 1);
            }
        }
    }
}
