﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class CustomerClassDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(CustomerClass m)
    {
        string sql = @"insert Base_CustomerClass(cc_code,cc_name,parent_id)
                        select @cc_code,@cc_name,@parent_id";
        SqlParameter[] par = {
            new SqlParameter("@cc_code",m.cc_code),
            new SqlParameter("@cc_name",m.cc_name),
            new SqlParameter("@parent_id",m.parent_id)
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">cc_id</param>
    /// <returns>CustomerClass</returns>
    public CustomerClass Get(int cc_id)
    {
        CustomerClass m = new CustomerClass();
        string sql = @"select *
                      from Base_CustomerClass where cc_id=@cc_id";
        SqlParameter[] par = {
                new SqlParameter("@cc_id",cc_id)
            };
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.cc_id = Convert.ToInt32(r["cc_id"]);
                m.cc_code = r["cc_code"].ToString();
                m.cc_name = r["cc_name"].ToString();
                m.parent_id = XTools.DBNullToInt(r["parent_id"]);
                if (r["parent_id"] != null)
                {
                    m.parent = Get(Convert.ToInt32(r["parent_id"]));
                }
           }
        }
        return m;
    }
    /// <summary>
    /// 通过编码得到ID
    /// </summary>
    /// <param name="编码">vc_code</param>
    /// <returns>int</returns>
    public int GetIdByCode(string cc_code)
    {
        string sql = @"select cc_id
                      from Base_CustomerClass where cc_code=@cc_code";
        SqlParameter[] par = {
                new SqlParameter("@cc_code",cc_code)
            };
        return Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
    }
    /// <summary>
    /// 通过ID得到编码
    /// </summary>
    /// <param name="ID">ic_id</param>
    /// <returns>int</returns>
    public string GetCodeById(int cc_id)
    {
        string sql = @"select cc_code
                      from Base_CustomerClass where cc_id=@cc_id";
        SqlParameter[] par = {
                new SqlParameter("@cc_id",cc_id)
            };
        return new SqlUtil().ExecuteScalar(sql, par).ToString();
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(CustomerClass m)
    {
        string sql = @"update Base_CustomerClass set 
                        cc_code=@cc_code,
                        cc_name=@cc_name,
                        parent_id=@parent_id
                       where cc_id=@cc_id";
        SqlParameter[] par = {
                new SqlParameter("@cc_code",m.cc_code),
                new SqlParameter("@cc_name",m.cc_name),
                new SqlParameter("@parent_id",m.parent_id),
                new SqlParameter("@cc_id",m.cc_id),
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除
    /// </summary>
    /// <param name="id">ID</param>
    public void Delete(int cc_id)
    {
        CustomerClass m = new CustomerClass();
        string sql = "delete Base_CustomerClass where cc_id in (@cc_id)";
        SqlParameter[] par = {
                new SqlParameter("@cc_id",cc_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到所有分类
    /// </summary>
    /// <returns>DataTable</returns>
    public DataTable GetListAll(string where)
    {
        string sql = @"select * from Base_CustomerClass @where order by cc_id";
        sql = sql.Replace("@where", where);
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 验证编码是否存在
    /// </summary>
    /// <param name="cc_code">编码</param>
    /// <returns>bool</returns>
    public bool CheckExist(string cc_code)
    {
        string sql = "select count(1) from Base_CustomerClass where cc_code=@cc_code";
        SqlParameter[] par ={
                new SqlParameter("@cc_code", cc_code)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            return true;
        return false;
    }
    /// <summary>
    /// 验证是否有子类
    /// </summary>
    /// <param name="cc_id">主键id</param>
    /// <returns>bool</returns>
    public bool CheckHasChild(int cc_id)
    {
        string sql = "select count(1) from Base_CustomerClass where parent_id=@cc_id";
        SqlParameter[] par ={
                new SqlParameter("@cc_id", cc_id)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            return true;
        return false;
    }
    /// <summary>
    /// 验证编码是否与父级分类一致
    /// </summary>
    /// <param name="cc_code">编码</param>
    /// <returns>bool</returns>
    public bool CheckLikeParent(string cc_code, string parent_code)
    {
        bool like = false;
        //父级分类编码与当前分类编码的前几位不一样，代表规则不一致
        if (cc_code.Length <= parent_code.Length) return false;
        if (cc_code.Substring(0, parent_code.Length).Equals(parent_code))
            like = true;
        //如果除父级分类编码外，还有规则与当前编码一样的且长度大于父级编码的,代表规则不对
        string sql = @"select count(1) from Base_CustomerClass 
                        where  @cc_code like cc_code+'%'
                        and cc_code not in (@parent_code,@cc_code)
                        and len(cc_code)>len(@parent_code)";
        SqlParameter[] par = {
                new SqlParameter("@cc_code",cc_code),
                new SqlParameter("@parent_code",parent_code)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            like = false;
        return like;
    }
    /// <summary>
    /// 更新分类级次
    /// </summary>
    /// <param name="parent_id">当前ID</param>
    /// <param name="layer">当前级次</param>
    public void FetchNodeAndUpdateLayer(int parent_id, int layer)
    {
        DataTable dt = GetListAll("where isnull(parent_id,0)=" + parent_id);
        SqlUtil su = new SqlUtil();
        foreach (DataRow dr in dt.Rows)
        {
            int cur_id = Convert.ToInt32(dr["cc_id"]);
            string cc_name = dr["cc_name"].ToString();
            string sql = "update Base_CustomerClass set layer=" + layer + " where cc_id=" + cur_id;
            su.ExecuteNonQuery(sql, null);
            bool has_child = CheckHasChild(cur_id);
            if (has_child)
            {
                FetchNodeAndUpdateLayer(cur_id, layer + 1);
            }
        }
    }
}
