﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

/// <summary>
/// 收付款
/// </summary>
public class SFKuanDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(SFKuan m)
    {
        string sql = @"insert ARAP_SFKuan(rp_flag,order_number,invoice_no,ss_id,cus_id,vd_id,
			                        dep_id,ele_id,crc_id,exchange_rate,remark,
                                    amount,acc_hx_amount,
                                    nat_amount,acc_hx_nat_amount,
                                    ac_id,new_uid,new_user,new_date,
                                    update_uid,update_user,update_date,
                                    verify_uid,verify_user,
                                    sdefine1,sdefine2,sdefine3,sdefine4,sdefine5,
                                    ndefine1,ndefine2,ndefine3,ndefine4,ndefine5)
                        select  @rp_flag,@order_number,@invoice_no,@ss_id,@cus_id,@vd_id,
			                    @dep_id,@ele_id,@crc_id,@exchange_rate,@remark,
                                @amount,@acc_hx_amount,
                                @nat_amount,@acc_hx_nat_amount,
                                @ac_id,@new_uid,@new_user,@new_date,
                                @update_uid,@update_user,@update_date,
                                @verify_uid,@verify_user,
                                @sdefine1,@sdefine2,@sdefine3,@sdefine4,@sdefine5,
                                @ndefine1,@ndefine2,@ndefine3,@ndefine4,@ndefine5";
        SqlParameter[] par = {
            new SqlParameter("@rp_flag",m.rp_flag),
            new SqlParameter("@order_number",m.order_number),
            new SqlParameter("@invoice_no",XTools.StringToDBNull(m.invoice_no)),
            new SqlParameter("@ss_id",XTools.IntToDBNull(m.ss_id)),
            new SqlParameter("@cus_id",XTools.IntToDBNull(m.cus_id)),
            new SqlParameter("@vd_id",XTools.IntToDBNull(m.vd_id)),
            new SqlParameter("@dep_id",XTools.IntToDBNull(m.dep_id)),
            new SqlParameter("@ele_id",XTools.IntToDBNull(m.ele_id)),
            new SqlParameter("@crc_id",XTools.IntToDBNull(m.crc_id)),
            new SqlParameter("@exchange_rate",XTools.DecimalToDBNull(m.exchange_rate)),
            new SqlParameter("@remark",XTools.StringToDBNull(m.remark)),

            new SqlParameter("@amount",XTools.DecimalToDBNull(m.amount)),
            new SqlParameter("@acc_hx_amount",XTools.DecimalToDBNull(m.acc_hx_amount)),
            new SqlParameter("@nat_amount",XTools.DecimalToDBNull(m.nat_amount)),
            new SqlParameter("@acc_hx_nat_amount",XTools.DecimalToDBNull(m.acc_hx_nat_amount)),

            new SqlParameter("@ac_id",XTools.IntToDBNull(m.ac_id)),
            new SqlParameter("@new_uid",XTools.IntToDBNull(m.new_uid)),
            new SqlParameter("@new_user",XTools.StringToDBNull(m.new_user)),
            new SqlParameter("@new_date",m.new_date),
            new SqlParameter("@update_uid",XTools.IntToDBNull(m.update_uid)),
            new SqlParameter("@update_user",XTools.StringToDBNull(m.update_user)),
            new SqlParameter("@update_date",XTools.DateTimeToDBNull(m.update_date)),
            new SqlParameter("@verify_uid",XTools.IntToDBNull(m.verify_uid)),
            new SqlParameter("@verify_user",XTools.StringToDBNull(m.verify_user)),
            new SqlParameter("@sdefine1",XTools.StringToDBNull(m.sdefine1)),
            new SqlParameter("@sdefine2",XTools.StringToDBNull(m.sdefine2)),
            new SqlParameter("@sdefine3",XTools.StringToDBNull(m.sdefine3)),
            new SqlParameter("@sdefine4",XTools.StringToDBNull(m.sdefine4)),
            new SqlParameter("@sdefine5",XTools.StringToDBNull(m.sdefine5)),
            new SqlParameter("@ndefine1",XTools.DecimalToDBNull(m.ndefine1)),
            new SqlParameter("@ndefine2",XTools.DecimalToDBNull(m.ndefine2)),
            new SqlParameter("@ndefine3",XTools.DecimalToDBNull(m.ndefine3)),
            new SqlParameter("@ndefine4",XTools.DecimalToDBNull(m.ndefine4)),
            new SqlParameter("@ndefine5",XTools.DecimalToDBNull(m.ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    //打印用的SQL
    public string sql_print = "";
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">sfk_id</param>
    /// <returns>SFKuan</returns>
    public SFKuan Get(int sfk_id)
    {
        SFKuan m = new SFKuan();
        string sql = @"select ca.*,convert(char(10),ca.new_date,23) as new_date_format,
                    round(isnull(ca.amount,0)-isnull(ca.acc_hx_amount,0),2) as wait_hx_amount,
                    round(isnull(ca.nat_amount,0)-isnull(ca.acc_hx_nat_amount,0),2) as wait_hx_nat_amount,
                    cus.cus_name,vd.vd_name,d.dep_name,
                    ele.ele_name,crc.crc_name,ss.ss_code,ss.ss_name,
                    cus.sdefine1 as cus_sdefine1,cus.sdefine2 as cus_sdefine2,cus.sdefine3 as cus_sdefine3,
                    cus.sdefine4 as cus_sdefine4,cus.sdefine5 as cus_sdefine5,
                    cus.ndefine1 as cus_ndefine1,cus.ndefine2 as cus_ndefine2,cus.ndefine3 as cus_ndefine3,
                    cus.ndefine4 as cus_ndefine4,cus.ndefine5 as cus_ndefine5
                    from ARAP_SFKuan ca
                    left join Base_Customer cus on ca.cus_id=cus.cus_id
                    left join Base_Vendor vd on ca.vd_id=vd.vd_id
                    left join Base_Department d on ca.dep_id=d.dep_id
                    left join Base_Employee ele on ca.ele_id=ele.ele_id
                    left join Base_Currency crc on ca.crc_id=crc.crc_id
                    left join Base_SettleStyle ss on ss.ss_id=ca.ss_id
                    where ca.sfk_id=@sfk_id";
        sql = sql.Replace("@sfk_id", sfk_id.ToString());
        //提供sql给打印用
        sql_print = sql;
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, null))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.sfk_id = Convert.ToInt32(r["sfk_id"]);
                m.rp_flag = r["rp_flag"].ToString();//收付标志:AR应收、AP应付
                m.order_number = r["order_number"].ToString();
                m.invoice_no = r["invoice_no"].ToString();
                m.new_date = XTools.DBNullToTime(r["new_date"]);
                m.cus_id = XTools.DBNullToInt(r["cus_id"]);
                if(r["cus_id"] != DBNull.Value)
                    m.customer = new CustomerDAL().Get(Convert.ToInt32(m.cus_id));
                m.vd_id = XTools.DBNullToInt(r["vd_id"]);
                if(r["vd_id"] != DBNull.Value)
                    m.vendor = new VendorDAL().Get(Convert.ToInt32(m.vd_id));
                m.dep_id = XTools.DBNullToInt(r["dep_id"]);
                if (r["dep_id"] != DBNull.Value)
                    m.department = new DepartmentDAL().Get(Convert.ToInt32(m.dep_id));
                m.ele_id = XTools.DBNullToInt(r["ele_id"]);
                if (r["ele_id"] != DBNull.Value)
                    m.employee = new EmployeeDAL().Get(Convert.ToInt32(m.ele_id));
                m.ss_id = XTools.DBNullToInt(r["ss_id"]);
                if (r["ss_id"] != DBNull.Value)
                    m.settle_style = new SettleStyleDAL().Get(Convert.ToInt32(m.ss_id));
                m.ac_id = XTools.DBNullToInt(r["ac_id"]);
                if (r["ac_id"] != DBNull.Value)
                    m.account = new AccountDAL().Get(Convert.ToInt32(m.ac_id));
                m.crc_id = XTools.DBNullToInt(r["crc_id"]);
                if (r["crc_id"] != DBNull.Value)
                    m.currency = new CurrencyDAL().Get(Convert.ToInt32(m.crc_id));
                m.exchange_rate = XTools.DBNullToDecimal(r["exchange_rate"]);
                m.remark = r["remark"].ToString();

                m.amount = XTools.DBNullToDecimal(r["amount"]);
                m.nat_amount = XTools.DBNullToDecimal(r["nat_amount"]);
                m.acc_hx_amount = XTools.DBNullToDecimal(r["acc_hx_amount"]);
                m.acc_hx_nat_amount = XTools.DBNullToDecimal(r["acc_hx_nat_amount"]);

                m.wait_hx_amount = XTools.DBNullToDecimal(r["wait_hx_amount"]);
                m.wait_hx_nat_amount = XTools.DBNullToDecimal(r["wait_hx_nat_amount"]);

                m.new_uid = XTools.DBNullToInt(r["new_uid"]);
                m.new_user = r["new_user"].ToString();
                m.verify_uid = XTools.DBNullToInt(r["verify_uid"]);
                m.verify_user = r["verify_user"].ToString();
                m.update_uid = XTools.DBNullToInt(r["update_uid"]);
                m.update_user = r["update_user"].ToString();
                m.update_date = XTools.DBNullToTime(r["update_date"]);
                m.sdefine1 = r["sdefine1"].ToString();
                m.sdefine2 = r["sdefine2"].ToString();
                m.sdefine3 = r["sdefine3"].ToString();
                m.sdefine4 = r["sdefine4"].ToString();
                m.sdefine5 = r["sdefine5"].ToString();
                m.ndefine1 = XTools.DBNullToDecimal(r["ndefine1"]);
                m.ndefine2 = XTools.DBNullToDecimal(r["ndefine2"]);
                m.ndefine3 = XTools.DBNullToDecimal(r["ndefine3"]);
                m.ndefine4 = XTools.DBNullToDecimal(r["ndefine4"]);
                m.ndefine5 = XTools.DBNullToDecimal(r["ndefine5"]);
            }
        }
        return m;
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(SFKuan m)
    {
        string sql = @"update ARAP_SFKuan set 
                        rp_flag=@rp_flag,
                        order_number=@order_number,
                        invoice_no=@invoice_no,
                        cus_id=@cus_id,
                        vd_id=@vd_id,
                        dep_id=@dep_id,
                        ele_id=@ele_id,
                        crc_id=@crc_id,
                        exchange_rate=@exchange_rate,
                        ac_id=@ac_id,
                        ss_id=@ss_id,
                        remark=@remark,
                        amount=@amount,
                        nat_amount=@nat_amount,
                        acc_hx_amount=@acc_hx_amount,
                        acc_hx_nat_amount=@acc_hx_nat_amount,
                        new_uid=@new_uid,
                        new_user=@new_user,
                        new_date=@new_date,
                        update_uid=@update_uid,
                        update_user=@update_user,
                        update_date=@update_date,
                        verify_uid=@verify_uid,
                        verify_user=@verify_user,
                        sdefine1=@sdefine1,
                        sdefine2=@sdefine2,
                        sdefine3=@sdefine3,
                        sdefine4=@sdefine4,
                        sdefine5=@sdefine5,
                        ndefine1=@ndefine1,
                        ndefine2=@ndefine2,
                        ndefine3=@ndefine3,
                        ndefine4=@ndefine4,
                        ndefine5=@ndefine5
                       where sfk_id=@sfk_id";
        SqlParameter[] par = {
            new SqlParameter("@sfk_id",m.sfk_id),
            new SqlParameter("@rp_flag",m.rp_flag),
            new SqlParameter("@order_number",m.order_number),
            new SqlParameter("@invoice_no",XTools.StringToDBNull(m.invoice_no)),
            new SqlParameter("@cus_id",XTools.IntToDBNull(m.cus_id)),
            new SqlParameter("@vd_id",XTools.IntToDBNull(m.vd_id)),
            new SqlParameter("@dep_id",XTools.IntToDBNull(m.dep_id)),
            new SqlParameter("@ele_id",XTools.IntToDBNull(m.ele_id)),
            new SqlParameter("@crc_id",XTools.IntToDBNull(m.crc_id)),
            new SqlParameter("@exchange_rate",XTools.DecimalToDBNull(m.exchange_rate)),
            new SqlParameter("@ac_id",XTools.DecimalToDBNull(m.ac_id)),
            new SqlParameter("@ss_id",XTools.DecimalToDBNull(m.ss_id)),
            new SqlParameter("@remark",XTools.StringToDBNull(m.remark)),
            new SqlParameter("@amount",XTools.DecimalToDBNull(m.amount)),
            new SqlParameter("@acc_hx_amount",XTools.DecimalToDBNull(m.acc_hx_amount)),
            new SqlParameter("@nat_amount",XTools.DecimalToDBNull(m.nat_amount)),
            new SqlParameter("@acc_hx_nat_amount",XTools.DecimalToDBNull(m.acc_hx_nat_amount)),
            new SqlParameter("@new_uid",XTools.IntToDBNull(m.new_uid)),
            new SqlParameter("@new_user",XTools.StringToDBNull(m.new_user)),
            new SqlParameter("@new_date",XTools.DateTimeToDBNull(m.new_date)),
            new SqlParameter("@update_uid",XTools.IntToDBNull(m.update_uid)),
            new SqlParameter("@update_user",XTools.StringToDBNull(m.update_user)),
            new SqlParameter("@update_date",XTools.DateTimeToDBNull(m.update_date)),
            new SqlParameter("@verify_uid",XTools.IntToDBNull(m.verify_uid)),
            new SqlParameter("@verify_user",XTools.StringToDBNull(m.verify_user)),
            new SqlParameter("@sdefine1",XTools.StringToDBNull(m.sdefine1)),
            new SqlParameter("@sdefine2",XTools.StringToDBNull(m.sdefine2)),
            new SqlParameter("@sdefine3",XTools.StringToDBNull(m.sdefine3)),
            new SqlParameter("@sdefine4",XTools.StringToDBNull(m.sdefine4)),
            new SqlParameter("@sdefine5",XTools.StringToDBNull(m.sdefine5)),
            new SqlParameter("@ndefine1",XTools.DecimalToDBNull(m.ndefine1)),
            new SqlParameter("@ndefine2",XTools.DecimalToDBNull(m.ndefine2)),
            new SqlParameter("@ndefine3",XTools.DecimalToDBNull(m.ndefine3)),
            new SqlParameter("@ndefine4",XTools.DecimalToDBNull(m.ndefine4)),
            new SqlParameter("@ndefine5",XTools.DecimalToDBNull(m.ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除
    /// </summary>
    /// <param name="id">ID</param>
    public string Delete(int sfk_id)
    {
        //删除子表
        new APCancelDAL().DeleteByOrder(sfk_id);
        //删除主表
        string sql = @"delete ARAP_SFKuan where sfk_id=@sfk_id";
        SqlParameter[] par = {
            new SqlParameter("@sfk_id",sfk_id)
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
        return "success";
    }
    /// <summary>
    /// 验证单据号是否存在
    /// </summary>
    /// <param name="order_number">编码</param>
    /// <returns>bool</returns>
    public bool CheckExist(string order_number)
    {
        string sql = "select count(1) from ARAP_SFKuan where order_number=@order_number";
        SqlParameter[] par ={
                new SqlParameter("@order_number", order_number)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            return true;
        return false;
    }
    /// <summary>
    /// 得到最大ID号
    /// </summary>
    public int GetMaxID()
    {
        string sql = "select isnull(max(sfk_id),0) from ARAP_SFKuan";
        return Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, null));
    }
    /// <summary>
    /// 得到上一个ID
    /// </summary>
    /// <param name="current_id">当前id</param>
    /// <param name="type">1上翻,2下翻</param>
    /// <param name="rp_flag">AR收款,AP付款</param>
    /// <returns></returns>
    public int GetPrevNextID(int current_id, string type, string rp_flag)
    {
        string sql = @"select isnull(max(sfk_id),0) from ARAP_SFKuan 
                    where rp_flag=@rp_flag and (sfk_id<@current_id or isnull(@current_id,0)=0)";
        if (type.Equals("2"))
        {
            sql = "select isnull(min(sfk_id),0) from ARAP_SFKuan where rp_flag=@rp_flag and sfk_id>@current_id";
        }
        SqlParameter[] par ={
                new SqlParameter("@rp_flag", rp_flag),
                new SqlParameter("@current_id", current_id)
            };
        return Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
    }
    /// <summary>
    /// 检查必填项
    /// </summary>
    /// <param name="do_id">单据ID</param>
    /// <returns>返回success为通过，否则为提示信息</returns>
    public string CheckMustInput(int sfk_id)
    {
        return "success";
    }
    /// <summary>
    /// 得到某张收付款单的所有核销明细
    /// </summary>
    /// <param name="ca_id"></param>
    /// <returns></returns>
    public DataTable GetDetailsByOrder(int sfk_id)
    {
        string sql = "select * from ARAP_APCancel where sfk_id=@sfk_id";
        SqlParameter[] par = {
            new SqlParameter("@sfk_id", sfk_id)
        };
        return new SqlUtil().GetDataTable(sql, par);
    }
    /// <summary>
    /// 得到某张收付款单所有未核销的明细
    /// </summary>
    /// <param name="ca_id"></param>
    /// <returns></returns>
    public DataTable GetDetailsUnCancel(int sfk_id)
    {
        string sql = @"
                select acl.acl_id,
                round(isnull(apd.tax_total_price,0)-isnull(apd.acc_hx_amount,0),2) as wait_hx_amount
                from ARAP_APCancel acl
                left join ARAP_APDetail apd on acl.apd_id=apd.apd_id
                where acl.sfk_id=@sfk_id
                order by acl.acl_id";
        SqlParameter[] par = {
            new SqlParameter("@sfk_id", sfk_id)
        };
        return new SqlUtil().GetDataTable(sql, par);
    }
    /// <summary>
    /// 加载需要核销的应收应付账
    /// </summary>
    /// <param name="sfk_id">收款单主表ID</param>
    /// <returns></returns>
    public string LoadNeedForCancel(int sfk_id)
    {
        SFKuan m = Get(sfk_id);
        int? cus_id = m.cus_id;
        int? vd_id = m.vd_id;
        int? crc_id = m.crc_id;
        string rp_flag = m.rp_flag;
        string cl_type;
        if (rp_flag.Equals("AR"))
            cl_type = "1";//付款
        else
            cl_type = "2";//收款
        DateTime dt = DateTime.Parse(m.new_date.ToString());
        string crc_year = dt.Year.ToString();
        string crc_month = dt.Month.ToString();
        //isnull(apd.tax_total_price,0)-ISNULL(apd.acc_hx_amount,0) as hx_amount,
        //isnull(apd.nat_tax_total_price,0)-isnull(apd.acc_hx_nat_amount,0) as nat_hx_amount
        string sql = @"
                    delete ARAP_APCancel where sfk_id=@sfk_id;
                    insert ARAP_APCancel(sfk_id,cl_type,apd_id,
                    hx_amount,nat_hx_amount)
                    select @sfk_id as sfk_id,@cl_type,apd.apd_id,
                    0 as hx_amount,
                    0 as nat_hx_amount
                    from ARAP_APDetail apd
                    left join Base_CurrencyRate cr on cr.crc_year=@crc_year and cr.crc_month=@crc_month
                    and cr.crc_id=@crc_id
                    where apd.rp_flag='@rp_flag' ";
        sql += " and apd.crc_id=@crc_id";
        //蓝票
        if(m.amount>0){
            sql += "and isnull(apd.tax_total_price,0)>0 and round(isnull(apd.tax_total_price,0)-ISNULL(apd.acc_hx_amount,0),2)>0";
        }
        //红票
        if (m.amount < 0)
        {
            sql += "and isnull(apd.tax_total_price,0)<0 and round(isnull(apd.tax_total_price,0)-ISNULL(apd.acc_hx_amount,0),2)<0";
        }
        if (m.rp_flag.Equals("AR"))
        {
            sql += " and cus_id=@cus_id";
            sql = sql.Replace("@cus_id", cus_id.ToString());
        }
        else
        {
            sql += " and vd_id=@vd_id";
            sql = sql.Replace("@vd_id", vd_id.ToString());
        }

        sql = sql.Replace("@sfk_id", sfk_id.ToString())
                .Replace("@crc_id", crc_id.ToString())
                .Replace("@cl_type", cl_type.ToString())
                .Replace("@crc_year", crc_year)
                .Replace("@crc_month", crc_month)
                .Replace("@crc_id", crc_id.ToString())
                .Replace("@rp_flag", rp_flag);
        new SqlUtil().ExecuteNonQuery(sql, null);
        return "success";
    }

    /// <summary>
    /// 得到某张收付款单已核销金额
    /// </summary>
    /// <param name="sfk_id">收付款单主表ID</param>
    /// <returns></returns>
    public DataTable GetCanceledAmount(int sfk_id)
    {
        string sql = @"select isnull(sum(hx_amount),0) as hx_amount,
                    isnull(sum(nat_hx_amount),0) as nat_hx_amount
                    from ARAP_APCancel where sfk_id=@sfk_id";
        sql = sql.Replace("@sfk_id", sfk_id.ToString());
        return new SqlUtil().GetDataTable(sql, null);
    }
    /// <summary>
    /// 收付款单审核更新应收应付账的累计核销金额
    /// </summary>
    /// <param name="sfk_id">收付款单主表ID</param>
    /// <param name="direction">方向：1,加累计核销金额;-1,减累计核销金额</param>
    /// <returns></returns>
    public string UpdateAPDetailHxAmount(int sfk_id, int direction)
    {
        string sql = @"
            update ARAP_APDetail set 
            acc_hx_amount=isnull(acc_hx_amount,0) @plus ISNULL(acl.hx_amount,0),
            acc_hx_nat_amount=isnull(acc_hx_nat_amount,0) @plus ISNULL(acl.nat_hx_amount,0)
            from ARAP_APCancel acl
            where acl.apd_id=ARAP_APDetail.apd_id
            and acl.sfk_id=@sfk_id;

            update ARAP_SFKuan set 
            acc_hx_amount=isnull(acc_hx_amount,0) @plus t.hx_amount,
            acc_hx_nat_amount=isnull(acc_hx_nat_amount,0) @plus t.nat_hx_amount
            from
            (
	            select sfk_id,sum(hx_amount) as hx_amount,sum(nat_hx_amount) as nat_hx_amount
	            from ARAP_APCancel where sfk_id=@sfk_id
	            group by sfk_id
            )t where ARAP_SFKuan.sfk_id=t.sfk_id;
            
            delete ARAP_APCancel where sfk_id=@sfk_id and isnull(hx_amount,0)=0;";
        sql = sql.Replace("@sfk_id", sfk_id.ToString());
        if (direction == 1)
        {
            //加
            sql = sql.Replace("@plus", "+");
        }
        else
        {
            //减
            sql = sql.Replace("@plus", "-");
        }
        new SqlUtil().ExecuteNonQuery(sql, null);
        return "success";
    }

    /// <summary>
    /// 检查是否超收款单金额核销
    /// </summary>
    /// <param name="sfk_id">收款单D</param>
    /// <returns>返回success为通过，否则为提示信息</returns>
    public string CheckOverSFKuanAmount(int sfk_id, int action_type)
    {
        string sql = @"SELECT top 1 info FROM
                    (
                        select '单据：' + t.order_number + ' 核销金额:'+cast(isnull(sum(d.nat_hx_amount),0) as varchar(50))+' 超本单金额:'+cast(isnull(t.nat_amount,0) as varchar(50)) + ' (本币)'as info
                        from ARAP_SFKuan t
                        left join ARAP_APCancel d on t.sfk_id=d.sfk_id
                        where t.sfk_id=@sfk_id
                        group by t.order_number,t.nat_amount,d.sfk_id
                        having round(isnull(sum(d.nat_hx_amount),0),2) > round(ISNULL(t.nat_amount,0),2)
                        
                    )x";
        SqlParameter[] par ={
                new SqlParameter("@sfk_id", sfk_id)
            };
        DataTable dt = new SqlUtil().GetDataTable(sql, par);
        if (dt.Rows.Count > 0)
        {
            return dt.Rows[0]["info"].ToString();
        }
        return "success";
    }
    /// <summary>
    /// 判断收款单有没发生后续业务,有发生业务返回true
    /// </summary>
    /// <returns>int</returns>
    public bool CheckHasDoNext(int sfk_id)
    {
        string sql = "select count(*) from ARAP_APCancel where sfk_id=@sfk_id and cl_type not in (1,2)";
        SqlParameter[] par ={
                new SqlParameter("@sfk_id", sfk_id)
            };
        int result = (int)new SqlUtil().ExecuteScalar(sql, par);
        if (result > 0)
            return true;
        return false;
    }

}
