﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class CheckAccountsDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(CheckAccounts m)
    {
        string sql = @"insert ARAP_CheckAccounts(ca_id,d_wh_id,i_id,free1,free2,batch,ios_id,
                                unit_price,tax_unit_price,quantity,num,convert_rate,
                                total_price,tax_total_price,tax,
                                nat_unit_price,nat_total_price,nat_tax_unit_price,
                                nat_tax_total_price,nat_tax,
                                d_tax_rate,d_remark,
                                d_sdefine1,d_sdefine2,d_sdefine3,d_sdefine4,d_sdefine5,
                                d_ndefine1,d_ndefine2,d_ndefine3,d_ndefine4,d_ndefine5)
                        select  @ca_id,@d_wh_id,@i_id,@free1,@free2,@batch,@ios_id,
                                @unit_price,@tax_unit_price,@quantity,@num,@convert_rate,
                                @total_price,@tax_total_price,@tax,
                                @nat_unit_price,@nat_total_price,@nat_tax_unit_price,
                                @nat_tax_total_price,@nat_tax,
                                @d_tax_rate,@d_remark,
                                @d_sdefine1,@d_sdefine2,@d_sdefine3,@d_sdefine4,@d_sdefine5,
                                @d_ndefine1,@d_ndefine2,@d_ndefine3,@d_ndefine4,@d_ndefine5";
        SqlParameter[] par = {
            new SqlParameter("@ca_id",m.ca_id),
            new SqlParameter("@d_wh_id",XTools.IntToDBNull(m.d_wh_id)),
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@free1",m.free1),
            new SqlParameter("@free2",m.free2),
            new SqlParameter("@batch",m.batch),
            new SqlParameter("@ios_id",XTools.IntToDBNull(m.ios_id)),
            new SqlParameter("@unit_price",XTools.DecimalToDBNull(m.unit_price)),
            new SqlParameter("@tax_unit_price",XTools.DecimalToDBNull(m.tax_unit_price)),
            new SqlParameter("@quantity",XTools.DecimalToDBNull(m.quantity)),
            new SqlParameter("@num",XTools.DecimalToDBNull(m.num)),
            new SqlParameter("@convert_rate",XTools.DecimalToDBNull(m.convert_rate)),
            new SqlParameter("@total_price",XTools.DecimalToDBNull(m.total_price)),
            new SqlParameter("@tax_total_price",XTools.DecimalToDBNull(m.tax_total_price)),
            new SqlParameter("@tax",XTools.DecimalToDBNull(m.tax)),
            new SqlParameter("@nat_unit_price",XTools.DecimalToDBNull(m.nat_unit_price)),
            new SqlParameter("@nat_total_price",XTools.DecimalToDBNull(m.nat_total_price)),
            new SqlParameter("@nat_tax_unit_price",XTools.DecimalToDBNull(m.nat_tax_unit_price)),
            new SqlParameter("@nat_tax_total_price",XTools.DecimalToDBNull(m.nat_tax_total_price)),
            new SqlParameter("@nat_tax",XTools.DecimalToDBNull(m.nat_tax)),
            new SqlParameter("@d_tax_rate",XTools.DecimalToDBNull(m.d_tax_rate)),
            new SqlParameter("@d_remark",XTools.StringToDBNull(m.d_remark)),
            new SqlParameter("@d_sdefine1",XTools.StringToDBNull(m.d_sdefine1)),
            new SqlParameter("@d_sdefine2",XTools.StringToDBNull(m.d_sdefine2)),
            new SqlParameter("@d_sdefine3",XTools.StringToDBNull(m.d_sdefine3)),
            new SqlParameter("@d_sdefine4",XTools.StringToDBNull(m.d_sdefine4)),
            new SqlParameter("@d_sdefine5",XTools.StringToDBNull(m.d_sdefine5)),
            new SqlParameter("@d_ndefine1",XTools.DecimalToDBNull(m.d_ndefine1)),
            new SqlParameter("@d_ndefine2",XTools.DecimalToDBNull(m.d_ndefine2)),
            new SqlParameter("@d_ndefine3",XTools.DecimalToDBNull(m.d_ndefine3)),
            new SqlParameter("@d_ndefine4",XTools.DecimalToDBNull(m.d_ndefine4)),
            new SqlParameter("@d_ndefine5",XTools.DecimalToDBNull(m.d_ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">cas_id</param>
    /// <returns>CheckAccounts</returns>
    public CheckAccounts Get(int cas_id)
    {
        CheckAccounts m = new CheckAccounts();
        string sql = @"select d.*,
                    i.sdefine1 as d_inv_sdefine1,i.sdefine2 as d_inv_sdefine2,i.sdefine3 as d_inv_sdefine3,
                    i.sdefine4 as d_inv_sdefine4,i.sdefine5 as d_inv_sdefine5,
                    i.ndefine1 as d_inv_ndefine1,i.ndefine2 as d_inv_ndefine2,i.ndefine3 as d_inv_ndefine3,
                    i.ndefine4 as d_inv_ndefine4,i.ndefine5 as d_inv_ndefine5
                    from ARAP_CheckAccounts d 
                    left join Base_Inventory i on d.i_id=i.i_id
                    where d.cas_id=@cas_id";
        SqlParameter[] par = {
                new SqlParameter("@cas_id",cas_id)
            };
        CheckAccountDAL parent_dal = new CheckAccountDAL();
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, par))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.ca_id = Convert.ToInt32(r["ca_id"]);//主表id
                m.parent_object = parent_dal.Get(m.ca_id);//父对象
                m.cas_id = Convert.ToInt32(r["cas_id"]);//子表id
                m.d_wh_id = XTools.DBNullToInt(r["d_wh_id"]);//仓库id
                if (r["d_wh_id"] != DBNull.Value)
                    m.warehouse = new WarehouseDAL().Get((int)m.d_wh_id);
                m.i_id = Convert.ToInt32(r["i_id"]);//存货id
                if(r["i_id"] != DBNull.Value)
                    m.inventory = new InventoryDAL().Get(m.i_id);
                m.free1 = r["free1"].ToString();
                m.free2 = r["free2"].ToString();
                m.batch = r["batch"].ToString();
                m.ios_id = XTools.DBNullToInt(r["ios_id"]);//进出单子表ID
                m.unit_price = XTools.DBNullToDecimal(r["unit_price"]);//无税单价
                m.tax_unit_price = XTools.DBNullToDecimal(r["tax_unit_price"]);//含税单价
                m.quantity = XTools.DBNullToDecimal(r["quantity"]);//数量
                m.ios_id = XTools.DBNullToInt(r["ios_id"]);
                if (r["ios_id"] != DBNull.Value)
                    m.inouts = new InOutsDAL().Get((int)m.ios_id, 0);
                m.num = XTools.DBNullToDecimal(r["num"]);//件数
                m.convert_rate = XTools.DBNullToDecimal(r["convert_rate"]);//换算率
                m.total_price = XTools.DBNullToDecimal(r["total_price"]);//无税金额
                m.tax_total_price = XTools.DBNullToDecimal(r["tax_total_price"]);//含税金额
                m.tax = XTools.DBNullToDecimal(r["tax"]);//税额
                m.nat_unit_price = XTools.DBNullToDecimal(r["nat_unit_price"]);//本币单价
                m.nat_total_price = XTools.DBNullToDecimal(r["nat_total_price"]);//本币金额
                m.nat_tax_unit_price = XTools.DBNullToDecimal(r["nat_tax_unit_price"]);//本币含税单价
                m.nat_tax_total_price = XTools.DBNullToDecimal(r["nat_tax_total_price"]);//本币含税金额
                m.nat_tax = XTools.DBNullToDecimal(r["nat_tax"]);//本币税额
                m.d_tax_rate = XTools.DBNullToDecimal(r["d_tax_rate"]);//税率
                m.d_remark = r["d_remark"].ToString();//备注
                m.d_sdefine1 = r["d_sdefine1"].ToString();
                m.d_sdefine2 = r["d_sdefine2"].ToString();
                m.d_sdefine3 = r["d_sdefine3"].ToString();
                m.d_sdefine4 = r["d_sdefine4"].ToString();
                m.d_sdefine5 = r["d_sdefine5"].ToString();
                m.d_ndefine1 = XTools.DBNullToDecimal(r["d_ndefine1"]);
                m.d_ndefine2 = XTools.DBNullToDecimal(r["d_ndefine2"]);
                m.d_ndefine3 = XTools.DBNullToDecimal(r["d_ndefine3"]);
                m.d_ndefine4 = XTools.DBNullToDecimal(r["d_ndefine4"]);
                m.d_ndefine5 = XTools.DBNullToDecimal(r["d_ndefine5"]);

            }
        }
        return m;
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(CheckAccounts m)
    {
        string sql = @"update ARAP_CheckAccounts set
                        ca_id=@ca_id,d_wh_id=@d_wh_id,i_id=@i_id,free1=@free1,free2=@free2,
                        batch=@batch,ios_id=@ios_id,
                        unit_price=@unit_price,tax_unit_price=@tax_unit_price,
                        quantity=@quantity,num=@num,convert_rate=@convert_rate,
                        total_price=@total_price,tax_total_price=@tax_total_price,tax=@tax,
                        nat_unit_price=@nat_unit_price,nat_total_price=@nat_total_price,
                        nat_tax_unit_price=@nat_tax_unit_price,
                        nat_tax_total_price=@nat_tax_total_price,nat_tax=@nat_tax,
                        d_tax_rate=@d_tax_rate,d_remark=@d_remark,
                        d_sdefine1=@d_sdefine1,d_sdefine2=@d_sdefine2,d_sdefine3=@d_sdefine3,
                        d_sdefine4=@d_sdefine4,d_sdefine5=@d_sdefine5,
                        d_ndefine1=@d_ndefine1,d_ndefine2=@d_ndefine2,d_ndefine3=@d_ndefine3,
                        d_ndefine4=@d_ndefine4,d_ndefine5=@d_ndefine5
                        where cas_id=@cas_id";
        SqlParameter[] par = {
            new SqlParameter("@cas_id",m.cas_id),
            new SqlParameter("@ca_id",m.ca_id),
            new SqlParameter("@d_wh_id",XTools.IntToDBNull(m.d_wh_id)),
            new SqlParameter("@i_id",m.i_id),
            new SqlParameter("@free1",XTools.StringToDBNull(m.free1)),
            new SqlParameter("@free2",XTools.StringToDBNull(m.free2)),
            new SqlParameter("@batch",XTools.StringToDBNull(m.batch)),
            new SqlParameter("@ios_id",XTools.IntToDBNull(m.ios_id)),
            new SqlParameter("@unit_price",XTools.DecimalToDBNull(m.unit_price)),
            new SqlParameter("@tax_unit_price",XTools.DecimalToDBNull(m.tax_unit_price)),
            new SqlParameter("@quantity",XTools.DecimalToDBNull(m.quantity)),
            new SqlParameter("@num",XTools.DecimalToDBNull(m.num)),
            new SqlParameter("@convert_rate",XTools.DecimalToDBNull(m.convert_rate)),
            new SqlParameter("@total_price",XTools.DecimalToDBNull(m.total_price)),
            new SqlParameter("@tax_total_price",XTools.DecimalToDBNull(m.tax_total_price)),
            new SqlParameter("@tax",XTools.DecimalToDBNull(m.tax)),
            new SqlParameter("@nat_unit_price",XTools.DecimalToDBNull(m.nat_unit_price)),
            new SqlParameter("@nat_total_price",XTools.DecimalToDBNull(m.nat_total_price)),
            new SqlParameter("@nat_tax_unit_price",XTools.DecimalToDBNull(m.nat_tax_unit_price)),
            new SqlParameter("@nat_tax_total_price",XTools.DecimalToDBNull(m.nat_tax_total_price)),
            new SqlParameter("@nat_tax",XTools.DecimalToDBNull(m.nat_tax)),
            new SqlParameter("@d_tax_rate",XTools.DecimalToDBNull(m.d_tax_rate)),
            new SqlParameter("@d_remark",XTools.StringToDBNull(m.d_remark)),
            new SqlParameter("@d_sdefine1",XTools.StringToDBNull(m.d_sdefine1)),
            new SqlParameter("@d_sdefine2",XTools.StringToDBNull(m.d_sdefine2)),
            new SqlParameter("@d_sdefine3",XTools.StringToDBNull(m.d_sdefine3)),
            new SqlParameter("@d_sdefine4",XTools.StringToDBNull(m.d_sdefine4)),
            new SqlParameter("@d_sdefine5",XTools.StringToDBNull(m.d_sdefine5)),
            new SqlParameter("@d_ndefine1",XTools.DecimalToDBNull(m.d_ndefine1)),
            new SqlParameter("@d_ndefine2",XTools.DecimalToDBNull(m.d_ndefine2)),
            new SqlParameter("@d_ndefine3",XTools.DecimalToDBNull(m.d_ndefine3)),
            new SqlParameter("@d_ndefine4",XTools.DecimalToDBNull(m.d_ndefine4)),
            new SqlParameter("@d_ndefine5",XTools.DecimalToDBNull(m.d_ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除子表
    /// </summary>
    /// <param name="cas_id">子表ID</param>
    public void Delete(int cas_id)
    {
        CheckAccounts m = new CheckAccounts();
        string sql = "delete ARAP_CheckAccounts where cas_id=@cas_id";
        SqlParameter[] par = {
                new SqlParameter("@cas_id",cas_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除整单子表
    /// </summary>
    /// <param name="ca_id">主表ID</param>
    public void DeleteByOrder(int ca_id)
    {
        CheckAccounts m = new CheckAccounts();
        string sql = "delete ARAP_CheckAccounts where ca_id=@ca_id";
        SqlParameter[] par = {
                new SqlParameter("@ca_id",ca_id)
            };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    //打印用的SQL
    public string sql_print = "";
    /// <summary>
    /// 得到单据表体
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(
	                select d.ca_id,d.cas_id,d.i_id,d.free1,d.free2,d.batch,d.ios_id,
                    d.d_wh_id,wh.wh_code as d_wh_code,wh.wh_name as d_wh_name,
                    i.i_code,i.i_name,i.standard,i.munit,i.aunit,
	                d.unit_price,d.tax_unit_price,d.quantity,d.num,
                    ios.quantity as io_quantity,io.order_number as io_order_number,
                    do.order_number as do_order_number,so.order_number as so_order_number,
                    po.order_number as po_order_number,
                    d.convert_rate,d.total_price,
	                d.tax_total_price,d.tax,d.nat_unit_price,d.nat_total_price,
	                d.nat_tax_unit_price,d.nat_tax_total_price,d.nat_tax,d.d_tax_rate,d.d_remark,
	                d.d_sdefine1,d.d_sdefine2,d.d_sdefine3,d.d_sdefine4,d.d_sdefine5,
	                d.d_ndefine1,d.d_ndefine2,d.d_ndefine3,d.d_ndefine4,d.d_ndefine5,
                    i.sdefine1 as d_inv_sdefine1,i.sdefine2 as d_inv_sdefine2,i.sdefine3 as d_inv_sdefine3,
                    i.sdefine4 as d_inv_sdefine4,i.sdefine5 as d_inv_sdefine5,
                    i.ndefine1 as d_inv_ndefine1,i.ndefine2 as d_inv_ndefine2,i.ndefine3 as d_inv_ndefine3,
                    i.ndefine4 as d_inv_ndefine4,i.ndefine5 as d_inv_ndefine5
	                from ARAP_CheckAccounts d
	                left join Base_Inventory i on d.i_id=i.i_id
                    left join Base_Warehouse wh on d.d_wh_id=wh.wh_id
                    left join Stock_InOuts ios on ios.ios_id=d.ios_id
                    left join Stock_InOut io on io.io_id=ios.io_id
                    left join Sale_DeliveryOrders dos on dos.dos_id=ios.dos_id
                    left join Sale_DeliveryOrder do on do.do_id=dos.do_id
                    left join Sale_SalesOrders sos on sos.sos_id=dos.sos_id
                    left join Sale_SalesOrder so on so.so_id=sos.so_id
                    left join Purchase_PurchaseOrders pos on pos.pos_id=ios.pos_id
                    left join Purchase_PurchaseOrder po on po.po_id=pos.po_id
                )t
                where 1=1 ";
        sql = sql.Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);
        sql_print = "select top 1000000000 * from (" + sql + ") t where 1=1 " + pg["sql_end"] + " " + pg["order_field"].ToString();
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from ARAP_CheckAccounts where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
    /// <summary>
    /// 得到某张单据表体总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetOneOrder_TotalNumbers(int ca_id)
    {
        string sql = "select count(1) from ARAP_CheckAccounts where ca_id=@ca_id ";
        SqlParameter[] par = {
                new SqlParameter("@ca_id",ca_id)
            };
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, par);
        return total_numbers;
    }
    /// <summary>
    /// 得到某张单所有明细
    /// </summary>
    /// <param name="ca_id"></param>
    /// <returns></returns>
    public DataTable GetDetails(int ca_id)
    {
        string sql = "select * from ARAP_CheckAccounts where ca_id=@ca_id";
        SqlParameter[] par = {
            new SqlParameter("@ca_id", ca_id)
        };
        return new SqlUtil().GetDataTable(sql, par);
    }
}
