﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public class CheckAccountDAL
{
    /// <summary>
    /// 新增
    /// </summary>
    /// <param name="m">实体</param>
    public void Add(CheckAccount m)
    {
        string sql = @"insert ARAP_CheckAccount(rp_flag,order_number,invoice_no,wh_id,cus_id,vd_id,
			                        dep_id,ele_id,crc_id,exchange_rate,remark,
                                    tax_rate,new_uid,new_user,new_date,
                                    update_uid,update_user,update_date,
                                    verify_uid,verify_user,from_id,from_type,
                                    sdefine1,sdefine2,sdefine3,sdefine4,sdefine5,
                                    ndefine1,ndefine2,ndefine3,ndefine4,ndefine5)
                        select  @rp_flag,@order_number,@invoice_no,@wh_id,@cus_id,@vd_id,
			                    @dep_id,@ele_id,@crc_id,@exchange_rate,@remark,
                                @tax_rate,@new_uid,@new_user,@new_date,
                                @update_uid,@update_user,@update_date,
                                @verify_uid,@verify_user,@from_id,@from_type,
                                @sdefine1,@sdefine2,@sdefine3,@sdefine4,@sdefine5,
                                @ndefine1,@ndefine2,@ndefine3,@ndefine4,@ndefine5";
        SqlParameter[] par = {
            new SqlParameter("@rp_flag",m.rp_flag),
            new SqlParameter("@order_number",m.order_number),
            new SqlParameter("@invoice_no",XTools.StringToDBNull(m.invoice_no)),
            new SqlParameter("@wh_id",XTools.IntToDBNull(m.wh_id)),
            new SqlParameter("@cus_id",XTools.IntToDBNull(m.cus_id)),
            new SqlParameter("@vd_id",XTools.IntToDBNull(m.vd_id)),
            new SqlParameter("@dep_id",XTools.IntToDBNull(m.dep_id)),
            new SqlParameter("@ele_id",XTools.IntToDBNull(m.ele_id)),
            new SqlParameter("@crc_id",XTools.IntToDBNull(m.crc_id)),
            new SqlParameter("@exchange_rate",XTools.DecimalToDBNull(m.exchange_rate)),
            new SqlParameter("@remark",XTools.StringToDBNull(m.remark)),
            new SqlParameter("@tax_rate",XTools.DecimalToDBNull(m.tax_rate)),
            new SqlParameter("@new_uid",XTools.IntToDBNull(m.new_uid)),
            new SqlParameter("@new_user",XTools.StringToDBNull(m.new_user)),
            new SqlParameter("@new_date",m.new_date),
            new SqlParameter("@update_uid",XTools.IntToDBNull(m.update_uid)),
            new SqlParameter("@update_user",XTools.StringToDBNull(m.update_user)),
            new SqlParameter("@update_date",XTools.DateTimeToDBNull(m.update_date)),
            new SqlParameter("@verify_uid",XTools.IntToDBNull(m.verify_uid)),
            new SqlParameter("@verify_user",XTools.StringToDBNull(m.verify_user)),
            new SqlParameter("@from_id",XTools.IntToDBNull(m.from_id)),
            new SqlParameter("@from_type",XTools.StringToDBNull(m.from_type)),
            new SqlParameter("@sdefine1",XTools.StringToDBNull(m.sdefine1)),
            new SqlParameter("@sdefine2",XTools.StringToDBNull(m.sdefine2)),
            new SqlParameter("@sdefine3",XTools.StringToDBNull(m.sdefine3)),
            new SqlParameter("@sdefine4",XTools.StringToDBNull(m.sdefine4)),
            new SqlParameter("@sdefine5",XTools.StringToDBNull(m.sdefine5)),
            new SqlParameter("@ndefine1",XTools.DecimalToDBNull(m.ndefine1)),
            new SqlParameter("@ndefine2",XTools.DecimalToDBNull(m.ndefine2)),
            new SqlParameter("@ndefine3",XTools.DecimalToDBNull(m.ndefine3)),
            new SqlParameter("@ndefine4",XTools.DecimalToDBNull(m.ndefine4)),
            new SqlParameter("@ndefine5",XTools.DecimalToDBNull(m.ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    //打印用的SQL
    public string sql_print = "";
    /// <summary>
    /// 得到实体
    /// </summary>
    /// <param name="主键id">ca_id</param>
    /// <returns>CheckAccount</returns>
    public CheckAccount Get(int ca_id)
    {
        CheckAccount m = new CheckAccount();
        string sql = @"select ca.*,
                    convert(char(10),ca.new_date,23) as new_date_format,
                    cus.cus_name,vd.vd_name,d.dep_name,
                    ele.ele_name,crc.crc_name,wh.wh_code,wh.wh_name,
                    cus.sdefine1 as cus_sdefine1,cus.sdefine2 as cus_sdefine2,cus.sdefine3 as cus_sdefine3,
                    cus.sdefine4 as cus_sdefine4,cus.sdefine5 as cus_sdefine5,
                    cus.ndefine1 as cus_ndefine1,cus.ndefine2 as cus_ndefine2,cus.ndefine3 as cus_ndefine3,
                    cus.ndefine4 as cus_ndefine4,cus.ndefine5 as cus_ndefine5
                    from ARAP_CheckAccount ca
                    left join Base_Customer cus on ca.cus_id=cus.cus_id
                    left join Base_Vendor vd on ca.vd_id=vd.vd_id
                    left join Base_Department d on ca.dep_id=d.dep_id
                    left join Base_Employee ele on ca.ele_id=ele.ele_id
                    left join Base_Currency crc on ca.crc_id=crc.crc_id
                    left join Base_Warehouse wh on wh.wh_id=ca.wh_id
                    where ca.ca_id=@ca_id";
        sql = sql.Replace("@ca_id", ca_id.ToString());
        //提供sql给打印用
        sql_print = sql;
        SqlUtil su = new SqlUtil();
        using (DataSet dt = su.GetDataSet(sql, null))
        {
            foreach (DataRow r in dt.Tables[0].Rows)
            {
                m.ca_id = Convert.ToInt32(r["ca_id"]);
                m.rp_flag = r["rp_flag"].ToString();//收付标志:AR应收、AP应付
                m.order_number = r["order_number"].ToString();
                m.invoice_no = r["invoice_no"].ToString();
                m.new_date = XTools.DBNullToTime(r["new_date"]);
                m.cus_id = XTools.DBNullToInt(r["cus_id"]);
                if(r["cus_id"] != DBNull.Value)
                    m.customer = new CustomerDAL().Get(Convert.ToInt32(m.cus_id));
                m.vd_id = XTools.DBNullToInt(r["vd_id"]);
                if(r["vd_id"] != DBNull.Value)
                    m.vendor = new VendorDAL().Get(Convert.ToInt32(m.vd_id));
                m.dep_id = XTools.DBNullToInt(r["dep_id"]);
                if (r["dep_id"] != DBNull.Value)
                    m.department = new DepartmentDAL().Get(Convert.ToInt32(m.dep_id));
                m.ele_id = XTools.DBNullToInt(r["ele_id"]);
                if (r["ele_id"] != DBNull.Value)
                    m.employee = new EmployeeDAL().Get(Convert.ToInt32(m.ele_id));
                m.wh_id = XTools.DBNullToInt(r["wh_id"]);
                if (r["wh_id"] != DBNull.Value)
                    m.warehouse = new WarehouseDAL().Get(Convert.ToInt32(m.wh_id));
                m.crc_id = XTools.DBNullToInt(r["crc_id"]);
                if (r["crc_id"] != DBNull.Value)
                    m.currency = new CurrencyDAL().Get(Convert.ToInt32(m.crc_id));
                m.exchange_rate = XTools.DBNullToDecimal(r["exchange_rate"]);
                m.tax_rate = XTools.DBNullToDecimal(r["tax_rate"]);
                m.remark = r["remark"].ToString();
                m.new_uid = XTools.DBNullToInt(r["new_uid"]);
                m.new_user = r["new_user"].ToString();
                m.verify_uid = XTools.DBNullToInt(r["verify_uid"]);
                m.verify_user = r["verify_user"].ToString();
                m.update_uid = XTools.DBNullToInt(r["update_uid"]);
                m.update_user = r["update_user"].ToString();
                m.update_date = XTools.DBNullToTime(r["update_date"]);
                m.from_id = XTools.DBNullToInt(r["from_id"]);
                m.from_type = r["from_type"].ToString();
                m.sdefine1 = r["sdefine1"].ToString();
                m.sdefine2 = r["sdefine2"].ToString();
                m.sdefine3 = r["sdefine3"].ToString();
                m.sdefine4 = r["sdefine4"].ToString();
                m.sdefine5 = r["sdefine5"].ToString();
                m.ndefine1 = XTools.DBNullToDecimal(r["ndefine1"]);
                m.ndefine2 = XTools.DBNullToDecimal(r["ndefine2"]);
                m.ndefine3 = XTools.DBNullToDecimal(r["ndefine3"]);
                m.ndefine4 = XTools.DBNullToDecimal(r["ndefine4"]);
                m.ndefine5 = XTools.DBNullToDecimal(r["ndefine5"]);
            }
        }
        return m;
    }
    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="m">实体</param>
    public void Update(CheckAccount m)
    {
        string sql = @"update ARAP_CheckAccount set 
                        rp_flag=@rp_flag,
                        order_number=@order_number,
                        invoice_no=@invoice_no,
                        cus_id=@cus_id,
                        vd_id=@vd_id,
                        dep_id=@dep_id,
                        ele_id=@ele_id,
                        crc_id=@crc_id,
                        exchange_rate=@exchange_rate,
                        tax_rate=@tax_rate,
                        remark=@remark,
                        new_uid=@new_uid,
                        new_user=@new_user,
                        new_date=@new_date,
                        update_uid=@update_uid,
                        update_user=@update_user,
                        update_date=@update_date,
                        verify_uid=@verify_uid,
                        verify_user=@verify_user,
                        from_id=@from_id,
                        from_type=@from_type,
                        sdefine1=@sdefine1,
                        sdefine2=@sdefine2,
                        sdefine3=@sdefine3,
                        sdefine4=@sdefine4,
                        sdefine5=@sdefine5,
                        ndefine1=@ndefine1,
                        ndefine2=@ndefine2,
                        ndefine3=@ndefine3,
                        ndefine4=@ndefine4,
                        ndefine5=@ndefine5
                       where ca_id=@ca_id";
        SqlParameter[] par = {
            new SqlParameter("@ca_id",m.ca_id),
            new SqlParameter("@rp_flag",m.rp_flag),
            new SqlParameter("@order_number",m.order_number),
            new SqlParameter("@invoice_no",XTools.StringToDBNull(m.invoice_no)),
            new SqlParameter("@cus_id",XTools.IntToDBNull(m.cus_id)),
            new SqlParameter("@vd_id",XTools.IntToDBNull(m.vd_id)),
            new SqlParameter("@dep_id",XTools.IntToDBNull(m.dep_id)),
            new SqlParameter("@ele_id",XTools.IntToDBNull(m.ele_id)),
            new SqlParameter("@crc_id",XTools.IntToDBNull(m.crc_id)),
            new SqlParameter("@exchange_rate",XTools.DecimalToDBNull(m.exchange_rate)),
            new SqlParameter("@tax_rate",XTools.DecimalToDBNull(m.tax_rate)),
            new SqlParameter("@remark",XTools.StringToDBNull(m.remark)),
            new SqlParameter("@new_uid",XTools.IntToDBNull(m.new_uid)),
            new SqlParameter("@new_user",XTools.StringToDBNull(m.new_user)),
            new SqlParameter("@new_date",XTools.DateTimeToDBNull(m.new_date)),
            new SqlParameter("@update_uid",XTools.IntToDBNull(m.update_uid)),
            new SqlParameter("@update_user",XTools.StringToDBNull(m.update_user)),
            new SqlParameter("@update_date",XTools.DateTimeToDBNull(m.update_date)),
            new SqlParameter("@verify_uid",XTools.IntToDBNull(m.verify_uid)),
            new SqlParameter("@verify_user",XTools.StringToDBNull(m.verify_user)),
            new SqlParameter("@from_id",XTools.IntToDBNull(m.from_id)),
            new SqlParameter("@from_type",XTools.StringToDBNull(m.from_type)),
            new SqlParameter("@sdefine1",XTools.StringToDBNull(m.sdefine1)),
            new SqlParameter("@sdefine2",XTools.StringToDBNull(m.sdefine2)),
            new SqlParameter("@sdefine3",XTools.StringToDBNull(m.sdefine3)),
            new SqlParameter("@sdefine4",XTools.StringToDBNull(m.sdefine4)),
            new SqlParameter("@sdefine5",XTools.StringToDBNull(m.sdefine5)),
            new SqlParameter("@ndefine1",XTools.DecimalToDBNull(m.ndefine1)),
            new SqlParameter("@ndefine2",XTools.DecimalToDBNull(m.ndefine2)),
            new SqlParameter("@ndefine3",XTools.DecimalToDBNull(m.ndefine3)),
            new SqlParameter("@ndefine4",XTools.DecimalToDBNull(m.ndefine4)),
            new SqlParameter("@ndefine5",XTools.DecimalToDBNull(m.ndefine5))
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 删除
    /// </summary>
    /// <param name="id">ID</param>
    public string Delete(int ca_id)
    {
            //删除子表
            new CheckAccountsDAL().DeleteByOrder(ca_id);
            //删除主表
            string sql = "delete ARAP_CheckAccount where ca_id=@ca_id";
            SqlParameter[] par = {
                new SqlParameter("@ca_id",ca_id)
            };
            new SqlUtil().ExecuteNonQuery(sql, par);

        return "success";
    }
    /// <summary>
    /// 验证单据号是否存在
    /// </summary>
    /// <param name="order_number">编码</param>
    /// <returns>bool</returns>
    public bool CheckExist(string order_number)
    {
        string sql = "select count(1) from ARAP_CheckAccount where order_number=@order_number";
        SqlParameter[] par ={
                new SqlParameter("@order_number", order_number)
            };
        int rows = Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
        if (rows > 0)
            return true;
        return false;
    }
    /// <summary>
    /// 得到最大ID号
    /// </summary>
    public int GetMaxID()
    {
        string sql = "select isnull(max(ca_id),0) from ARAP_CheckAccount";
        return Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, null));
    }
    /// <summary>
    /// 得到上一个ID
    /// </summary>
    /// <param name="current_id">当前id</param>
    /// <param name="type">1上翻,2下翻</param>
    /// <param name="rp_flag">AR销售对账,AP采购对账</param>
    /// <returns></returns>
    public int GetPrevNextID(int current_id, string type, string rp_flag)
    {
        string sql = @"select isnull(max(ca_id),0) from ARAP_CheckAccount 
                    where rp_flag=@rp_flag and (ca_id<@current_id or isnull(@current_id,0)=0)";
        if (type.Equals("2"))
        {
            sql = "select isnull(min(ca_id),0) from ARAP_CheckAccount where rp_flag=@rp_flag and ca_id>@current_id";
        }
        SqlParameter[] par ={
                new SqlParameter("@rp_flag", rp_flag),
                new SqlParameter("@current_id", current_id)
            };
        return Convert.ToInt32(new SqlUtil().ExecuteScalar(sql, par));
    }
    /// <summary>
    /// 检查必填项
    /// </summary>
    /// <param name="do_id">单据ID</param>
    /// <returns>返回success为通过，否则为提示信息</returns>
    public string CheckMustInput(int ca_id)
    {
        string sql = @"SELECT top 1 info,msg FROM
                    (
	                    select d.cas_id,i.i_code+' ' +i.i_name as info,
	                    case when
                        i.on_free1=1 and isnull(d.free1,'')=''
	                    then '未填自由项1'
	                    when
	                    i.on_free2=1 and isnull(d.free2,'')=''
	                    then '未填自由项2'
	                    when
	                    i.on_batch=1 and isnull(d.batch,'')=''
	                    then '未填批次'
                        when
	                    isnull(d.quantity,0)=0
	                    then '未填数量'
	                    else 'success' end as msg
	                    from ARAP_CheckAccounts d
	                    left join Base_Inventory i on d.i_id=i.i_id
	                    where d.ca_id=@ca_id
                    )t where msg!='success'
                    order by cas_id";
        SqlParameter[] par ={
                new SqlParameter("@ca_id", ca_id)
            };
        DataTable dt = new SqlUtil().GetDataTable(sql, par);
        if (dt.Rows.Count > 0)
        {
            return dt.Rows[0]["info"].ToString() + " " + dt.Rows[0]["msg"].ToString();
        }
        return "success";
    }
    /// <summary>
    /// 批量设置表体仓库
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="wh_id">仓库id</param>
    public void BatchSetWarehouse(int ca_id, int wh_id)
    {
        string sql = @"
                update ARAP_CheckAccounts set
                d_wh_id=@wh_id where ca_id=@ca_id";
        SqlParameter[] par = {
            new SqlParameter("@wh_id", wh_id),
            new SqlParameter("@ca_id", ca_id)
        };
        new SqlUtil().ExecuteNonQuery(sql, par);
    }
    /// <summary>
    /// 更新销售出库单累计对账数
    /// </summary>
    /// <param name="do_id">对账单主表id</param>
    /// <param name="direction">方向：1,加累对账数;0,减累对账数</param>
    public void UpdateDuiZhangQuantityByOrder(int ca_id, int direction)
    {
        string sql = @"
                update Stock_InOuts set
                dz_quantity=isnull(dz_quantity,0) @plus isnull(t.quantity,0),
                dz_num=isnull(dz_num,0) @plus isnull(t.num,0)
                from(
                    select ios_id,sum(d.quantity) as quantity,sum(d.num) as num
                    from ARAP_CheckAccounts d 
                    where d.ca_id=@ca_id and isnull(ios_id,0)!=0
                    group by ios_id 
                )t where Stock_InOuts.ios_id=t.ios_id";
        if (direction == 1)
        {
            //加现存量
            sql = sql.Replace("@plus", "+");
        }
        else
        {
            //减现存量
            sql = sql.Replace("@plus", "-");
        }
        sql = sql.Replace("@ca_id", ca_id.ToString());
        new SqlUtil().ExecuteNonQuery(sql, null);
    }
    /// <summary>
    /// 得到对账单生成的应收单主表ID集合
    /// </summary>
    public DataTable GetAPDetailID(int ca_id)
    {
        string sql = @"
            select  apd_id from ARAP_APDetail
            where cas_id in (select cas_id from ARAP_CheckAccounts where ca_id=@ca_id)
            group by apd_id";
        SqlParameter[] par ={
            new SqlParameter("@ca_id", ca_id)
        };
        DataTable dt = new SqlUtil().GetDataTable(sql, par);
        return dt;
    }
    /// <summary>
    /// 对账单生成应收应付明细账
    /// </summary>
    /// <param name="ca_id">对账单主表ID</param>
    /// <returns></returns>
    public string DuiZhangToAPDetail(int ca_id)
    {
        CheckAccountsDAL cas_dal = new CheckAccountsDAL();
        CheckAccountDAL dal = new CheckAccountDAL();
        APDetailDAL ap_dal = new APDetailDAL();
        CheckAccount m = dal.Get(ca_id);
        string title;
        if (m.rp_flag.Equals("AR"))
        {
            title = "销售对账单";
        }
        else
        {
            title = "采购对账单";
        }
        DataTable dt = cas_dal.GetDetails(ca_id);
        if (dt.Rows.Count == 0)
        {
            return "表体不可为空！";
        }
        foreach (DataRow dr in dt.Rows)
        {

            int cas_id = Convert.ToInt32(dr["cas_id"]);
            CheckAccounts cas = cas_dal.Get(cas_id);
            APDetail ap = new APDetail();
            ap.rp_flag = m.rp_flag;//收付标志:AR应收、AP应付
            ap.cas_id = cas.cas_id;//对账单子表ID
            ap.from_id = m.ca_id;//对账单主表ID
            ap.from_type = title;//单据来源
            ap.from_order_number = cas.parent_object.order_number;//对账单号
            if (cas.inouts != null)
            {
                //如果有销售订单
                if (m.rp_flag.Equals("AR") && cas.inouts.sales_orders != null)
                {
                    ap.bus_order_number = cas.inouts.sales_orders.parent_object.order_number;//销售订单号
                }
                //如果有采购订单
                if (m.rp_flag.Equals("AP") && cas.inouts.purchase_orders != null)
                {
                    ap.bus_order_number = cas.inouts.purchase_orders.parent_object.order_number;//采购订单号
                }

            }
            ap.invoice_no = m.invoice_no;//发票号
            ap.cus_id = m.cus_id;
            ap.vd_id = m.vd_id;
            ap.dep_id = m.dep_id;
            ap.ele_id = m.ele_id;
            ap.new_date = m.new_date;
            ap.new_uid = m.new_uid;
            ap.new_user = m.new_user;
            ap.verify_uid = m.verify_uid;
            ap.verify_user = m.verify_user;

            ap.i_id = cas.i_id;
            ap.free1 = cas.free1;
            ap.free2 = cas.free2;
            ap.batch = cas.batch;
            ap.quantity = cas.quantity;
            ap.num = cas.num;
            ap.convert_rate = cas.convert_rate;
            ap.unit_price = cas.unit_price;
            ap.tax_unit_price = cas.tax_unit_price;
            ap.total_price = cas.total_price;
            ap.tax_total_price = cas.tax_total_price;
            ap.tax_rate = cas.d_tax_rate;
            ap.nat_unit_price = cas.nat_unit_price;
            ap.nat_tax_unit_price = cas.nat_tax_unit_price;
            ap.nat_total_price = cas.nat_total_price;
            ap.nat_tax_total_price = cas.nat_tax_total_price;
            ap.crc_id = m.crc_id;
            ap.exchange_rate = m.exchange_rate;
            ap.remark = cas.d_remark;
            ap.d_sdefine1 = cas.d_sdefine1;
            ap.d_sdefine2 = cas.d_sdefine2;
            ap.d_sdefine3 = cas.d_sdefine3;
            ap.d_sdefine4 = cas.d_sdefine4;
            ap.d_sdefine5 = cas.d_sdefine5;
            ap.d_ndefine1 = cas.d_ndefine1;
            ap.d_ndefine2 = cas.d_ndefine2;
            ap.d_ndefine3 = cas.d_ndefine3;
            ap.d_ndefine4 = cas.d_ndefine4;
            ap.d_ndefine5 = cas.d_ndefine5;
            ap_dal.Add(ap);
        }
        return "success";
    }

    /// <summary>
    /// 取消对账单生成的应收应付明细账
    /// </summary>
    /// <param name="ca_id">对账单主表ID</param>
    /// <returns></returns>
    public string DeleteAPDetail(int ca_id)
    {
        //检查是否已核销
        string result = CheckIsCanceled(ca_id);
        if (!result.Equals("success"))
            return result;
        APDetailDAL ap_dal = new APDetailDAL();
        //得到对账单生成的应收明细b表ID
        foreach (DataRow dr in GetAPDetailID(ca_id).Rows)
        {
            int apd_id = Convert.ToInt32(dr["apd_id"]);
            ap_dal.Delete(apd_id);//删除应收明细
        }
        return "success";
    }

    /// <summary>
    /// 检查是否超数量对账
    /// </summary>
    /// <param name="ca_id">对账单D</param>
    /// <returns>返回success为通过，否则为提示信息</returns>
    public string CheckOverDuiZhang(int ca_id, int action_type)
    {
        string sql = @"SELECT top 1 info FROM
                    (
                        select i.i_code+' '+i.i_name
                        +' 对账数量:'+cast(t.quantity as varchar(50))+' 超实际数量:'+cast(isnull(ios.quantity,0) as varchar(50)) as info
                        from 
                        (
                            select ios_id,sum(quantity) as quantity
                            from ARAP_CheckAccounts
                            where ca_id=@ca_id and isnull(ios_id,0)!=0
                            group by ios_id
                        ) t left join Stock_InOuts ios on ios.ios_id=t.ios_id
                        left join Base_Inventory i on i.i_id=ios.i_id
                        where round(isnull(t.quantity,0),10)>round(isnull(ios.quantity,0),10)
                        and t.quantity>0 and ios.quantity>0
                    )x";
        SqlParameter[] par ={
                new SqlParameter("@ca_id", ca_id)
            };
        DataTable dt = new SqlUtil().GetDataTable(sql, par);
        if (dt.Rows.Count > 0)
        {
            return dt.Rows[0]["info"].ToString();
        }
        return "success";
    }
    /// <summary>
    /// 检查是否已核销
    /// </summary>
    /// <param name="ca_id">对账单D</param>
    /// <returns>返回success为通过，否则为提示信息</returns>
    public string CheckIsCanceled(int ca_id)
    {
        string sql = @"SELECT top 1 info FROM
                    (
                        select '本单已核销，收付款单号:'+sfk.order_number as info
                        from ARAP_APCancel acl
                        left join ARAP_SFKuan sfk on acl.sfk_id=sfk.sfk_id
                        left join ARAP_APDetail apd on apd.apd_id=acl.apd_id
                        left join ARAP_CheckAccounts cas on cas.cas_id=apd.cas_id
                        left join ARAP_CheckAccount ca on cas.ca_id=ca.ca_id
                        where ca.ca_id=@ca_id
                    ) x";
        SqlParameter[] par ={
                new SqlParameter("@ca_id", ca_id)
            };
        DataTable dt = new SqlUtil().GetDataTable(sql, par);
        if (dt.Rows.Count > 0)
        {
            return dt.Rows[0]["info"].ToString();
        }
        return "success";
    }
}
