﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using SysCore.Model;
using SysCore.DAL;
/// <summary>
///系统配置参数读取工具
/// </summary>
public class ConfigReader
{
    /// <summary>
    /// 得到某个参数的值
    /// </summary>
    /// <param name="cf_code">参数编码</param>
    /// <returns>参数值</returns>
    public string GetConfig(string cf_code)
    {
        ConfigDAL dal = new ConfigDAL();
        return dal.GetByCode(cf_code).cf_value;
    }
    /// <summary>
    /// 得到自由项1的标题
    /// </summary>
    /// <returns>标题</returns>
	public string Free1Title()
	{
        ConfigDAL dal = new ConfigDAL();
        return dal.GetByCode("free1_title").cf_value;
	}
    /// <summary>
    /// 得到自由项2的标题
    /// </summary>
    /// <returns>标题</returns>
    public string Free2Title()
    {
        ConfigDAL dal = new ConfigDAL();
        return dal.GetByCode("free2_title").cf_value;
    }
    /// <summary>
    /// 控制显示是否自由项1
    /// </summary>
    /// <returns>不显示时返回css样式display:none</returns>
    public string DisplayFree1()
    {
        string title = Free1Title();
        if (title == null || title.Equals(""))
            return "display:none";
        return "";
    }
    /// <summary>
    /// 控制显示是否自由项2
    /// </summary>
    /// <returns>不显示时返回css样式display:none</returns>
    public string DisplayFree2()
    {
        string title = Free2Title();
        if (title == null || title.Equals(""))
            return "display:none";
        return "";
    }
}