﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using SysCore;
/// <summary>
/// AuthEx 的摘要说明
/// </summary>
public class AuthEx
{
    /// <summary>
    /// 得到我及下级的员工ID
    /// </summary>
    /// <returns>sql</returns>
    public string GetSqlForMyEmployee()
    {
        LoginInfo li = new LoginInfo();
        int ele_id = new EmployeeDAL().GetEmployeeIdByUserId(li.uid);
        if (ele_id == 0)
        {
            return " (select -1)";
        }
        string sql = @"
            (
		        select ele.ele_id
		        from Base_Employee ele 
		        left join Base_Employee_Child ec on ec.child_ele_id=ele.ele_id
		        where (ele.ele_id=@ele_id or ec.parent_ele_id=@ele_id)
            )";
        sql = sql.Replace("@ele_id", ele_id.ToString());
        return sql;
    }
    /// <summary>
    /// 得到有权限的部门ID
    /// </summary>
    /// <returns>sql</returns>
    public string GetSqlForMyDepartment()
    {
        LoginInfo li = new LoginInfo();
        int uid = li.uid;
        string sql = @"
            (
		        select dep_id from System_DepAuth where uid=@uid
            )";
        sql = sql.Replace("@uid", uid.ToString());
        return sql;
    }
    /// <summary>
    /// 得到有权限的仓库ID
    /// </summary>
    /// <returns>sql</returns>
    public string GetSqlForMyWarehouse()
    {
        LoginInfo li = new LoginInfo();
        int uid = li.uid;
        string sql = @"
            (
		        select wh_id from System_WhAuth where uid=@uid
            )";
        sql = sql.Replace("@uid", uid.ToString());
        return sql;
    }
}