﻿<%@ WebService Language="C#" Class="ARAP_SFKuan_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Collections;
using System.Transactions;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.DAL;
using SysCore.Model;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class ARAP_SFKuan_Service : System.Web.Services.WebService
{
    /// <summary>
    /// 保存单据
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string rp_flag, string action, string sfk_id, string order_number, string invoice_no, string new_date,
        string cus_id, string cus_name,string vd_id, string vd_name,
        string ss_id, string ss_name, string ac_id, string ac_name, 
        string dep_id, string dep_name,string ele_id, string ele_name, 
        string crc_id, string crc_name, string exchange_rate, string remark,
        string amount, string nat_amount,  string acc_hx_amount, string acc_hx_nat_amount, 
        string sdefine1, string sdefine2, string sdefine3, string sdefine4, string sdefine5,
        string ndefine1, string ndefine2, string ndefine3, string ndefine4, string ndefine5)
    {
        string title, prefix;
        if (rp_flag.Equals("AR"))
        {
            title = "收款单";
            prefix = "ShouKuan";
        }
        else
        {
            title = "付款单";
            prefix = "FuKuan";
        }
        if (cus_name.Equals("")) cus_id = "";
        if (vd_name.Equals("")) vd_id = "";
        if (ele_name.Equals("")) ele_id = "";
        if (ss_name.Equals("")) ss_id = "";
        if (ac_name.Equals("")) ac_id = "";
        if (dep_name.Equals("")) dep_id = "";
        if (crc_name.Equals("")) crc_id = "";

        if (string.IsNullOrWhiteSpace(new_date))
        {
            return "对账单日期不可为空！";
        }
        if (rp_flag.Equals("AR"))
        {
            if (string.IsNullOrWhiteSpace(cus_id))
            {
                return "客户不可为空！";
            }
        }
        else
        {
            if (string.IsNullOrWhiteSpace(vd_id))
            {
                return "供应商不可为空！";
            }
        }
        if (string.IsNullOrWhiteSpace(ss_id))
        {
            return "结算方式不可为空！";
        }
        if (string.IsNullOrWhiteSpace(crc_id))
        {
            return "币种不可为空！";
        }
        if (string.IsNullOrWhiteSpace(amount) || Convert.ToDecimal(amount)==0)
        {
            return "收款金额不可为空或零！";
        }
        //汇率为空或0时让等于1
        if (exchange_rate.Trim().Equals("") || exchange_rate.Trim().Equals("0"))
        {
            exchange_rate = "1";
        }
        try
        {
            if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(new_date)))
            {
                return "操作月份已业务结账,不允许修改!";
            }
            SFKuanDAL dal = new SFKuanDAL();
            SFKuan m = new SFKuan();
            LoginInfo li = new LoginInfo();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(sfk_id));
                m.update_uid = li.uid;
                m.update_user = li.nickname;//修改人名称
                m.update_date = DateTime.Now;//修改日期
                if (m.verify_uid != null)
                {
                    return "已审核不允许改单";
                }
                if (!m.order_number.Equals(order_number))
                {
                    if (dal.CheckExist(order_number))
                    {
                        return "您修改了单号，然而单号：" + order_number + "已存在，请尝试别的号码！";
                    }
                }
            }
            else
            {
                m.new_uid = li.uid;
                m.new_user = li.nickname;//新增人名称
            }
            try
            {
                m.rp_flag = rp_flag;//AR应收(收款),AP应付(付款)
                m.new_date = Convert.ToDateTime(new_date);
                m.order_number = order_number;
                m.invoice_no = invoice_no;
                m.cus_id = XTools.ObjectNullToInt(cus_id);
                m.vd_id = XTools.ObjectNullToInt(vd_id);
                m.ss_id = XTools.ObjectNullToInt(ss_id);
                m.dep_id = XTools.ObjectNullToInt(dep_id); 
                m.ele_id = XTools.ObjectNullToInt(ele_id);
                m.crc_id = XTools.ObjectNullToInt(crc_id);
                m.exchange_rate = XTools.ObjectNullToDecimal(exchange_rate);
                m.ac_id = XTools.ObjectNullToInt(ac_id);
                m.amount = XTools.ObjectNullToDecimal(amount);
                m.nat_amount = XTools.ObjectNullToDecimal(nat_amount);
                //m.acc_hx_amount = XTools.ObjectNullToDecimal(acc_hx_amount);
                //m.acc_hx_nat_amount = XTools.ObjectNullToDecimal(acc_hx_nat_amount);
                m.remark = remark.ToString();
                m.sdefine1 = sdefine1.ToString();
                m.sdefine2 = sdefine2.ToString();
                m.sdefine3 = sdefine3.ToString();
                m.sdefine4 = sdefine4.ToString();
                m.sdefine5 = sdefine5.ToString();
                m.ndefine1 = XTools.ObjectNullToDecimal(ndefine1);
                m.ndefine2 = XTools.ObjectNullToDecimal(ndefine2);
                m.ndefine3 = XTools.ObjectNullToDecimal(ndefine3);
                m.ndefine4 = XTools.ObjectNullToDecimal(ndefine4);
                m.ndefine5 = XTools.ObjectNullToDecimal(ndefine5);
            }
            catch (Exception err)
            {
                return err.Message;
            }
            if (action.Equals("Update"))
            {
                                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    //更新表头
                    dal.Update(m);
                    new UserLogDAL().AddUserLog(title, "修改表头", m.sfk_id, m.order_number);
                    //提交事务
                    scope.Complete();
                }
            }
            else
            {
                //如果新增时单据号不为空说明是手工输入单号
                if (!order_number.Equals(""))
                {
                    if (dal.CheckExist(order_number))
                    {
                        return "单据号：" + order_number + "已存在！";
                    }
                }
                new UserLogDAL().AddUserLog(title, "新增单据", m.sfk_id, m.order_number);
                
                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    try
                    {
                        
                        //新增表头
                        dal.Add(m);
                    }
                    catch (Exception err)
                    {
                        return err.Message;
                    } 
                    //得到新增保存后的最大ID号
                    int MaxID = dal.GetMaxID();
                    sfk_id = MaxID.ToString();
                    m = dal.Get(MaxID);
                    //如果流水号为空代表是系统自动流水
                    if (order_number.Equals(""))
                    {
                        //更新实体
                        try
                        {
                            //根据规则生成流水号
                            Hashtable ht_num = new Hashtable();
                            if(m.customer != null)
                                ht_num.Add("[cus_code]", m.customer.cus_code);
                            if (m.vendor != null)
                                ht_num.Add("[vd_code]", m.vendor.vd_code);
                            string running_number = new RunningNumberRuleDAL().GetModuleRunningNumber("ARAP_" + prefix, ht_num);
                            if(running_number.LastIndexOf("[") > -1)
                                return "自动生成流水号出错,请检查必填项目!";
                            m.order_number = running_number;
                            //更新实体
                            dal.Update(m);
                        }
                        catch
                        {
                            return "自动生成流水号出错!";
                        }
                    }
                    //提交事务
                    scope.Complete();
                }
            }
        }
        catch (Exception e)
        {
            return e.Message;
        }
        return "success|" + sfk_id;
    }

    /// <summary>
    /// 删单
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids, string rp_flag)
    {
        string title;
        if (rp_flag.Equals("AR"))
        {
            title = "收款单";
        }
        else
        {
            title = "付款单";
        }
        string prev_id = "";
        try
        {
            SFKuanDAL dal = new SFKuanDAL();
            string sql = "select distinct sfk_id from ARAP_SFKuan where sfk_id in (" + ids + ")";
            using(SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
            {
                while (reader.Read())
                {
                    int id = reader.GetInt32(0);
                    SFKuan m = dal.Get(id);
                    if (m.verify_uid != null)
                    {
                        return "单据:" + m.order_number + "已审核不允许删单!";
                    }
                    if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(m.new_date)))
                    {
                        return "操作月份已业务结账,不允许修改!";
                    }
                    prev_id = GetPrevNextID(id, "1", rp_flag);//得到上一张单据ID
                    string msg = "";
                    //启用事务
                    using (TransactionScope scope = new TransactionScope())
                    {
                        new UserLogDAL().AddUserLog(title, "删除单据", m.sfk_id, m.order_number);
                        msg = dal.Delete(id);
                        if (!msg.Equals("success"))
                        {
                            return msg;
                        }
                        //提交事务
                        scope.Complete();
                    }
                }//end of reader
            }//end of using
            return "success|" + prev_id;
        }
        catch (Exception err)
        {
            return err.Message;
        }
        
    }
    /// <summary>
    /// 核销
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string CancelDoc(int id)
    {
        try
        {
            SFKuanDAL dal = new SFKuanDAL();
            SFKuan m = dal.Get(id);
            if (m.rp_flag.Equals("AR"))
            {
                if (m.cus_id == null)
                {
                    return "请填写客户!";
                }
            }
            else
            {
                if (m.vd_id == null)
                {
                    return "请填写供应商!";
                }
            }
            //加载待核销数据
            dal.LoadNeedForCancel(id);

            return "success";
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }
    
        
    /// <summary>
    /// 检查
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Check(int id, int action_type)
    {
        try
        {
            SFKuanDAL dal = new SFKuanDAL();
            SFKuan m = dal.Get(id);
            if (m.rp_flag.Equals("AR"))
            {
                if (m.cus_id == null)
                {
                    return "请填写客户!";
                }
            }
            else
            {
                if (m.vd_id == null)
                {
                    return "请填写供应商!";
                }
            }
            //检查必填项
            string result = dal.CheckMustInput(id);
            if (!result.Equals("success"))
            {
                return result;
            }
            if (action_type == 1)
            {
                //检查是否超收款单金额核销
                result = dal.CheckOverSFKuanAmount(id, action_type);
                if (!result.Equals("success"))
                {
                    return result;
                }
            }
            return "success";
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }
    /// <summary>
    /// 审核或弃审
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Verify(string ids, int action_type)
    {
        try
        {
            SFKuanDAL dal = new SFKuanDAL();
            string sql = "select distinct sfk_id from ARAP_SFKuan where sfk_id in (" + ids + ")";
            if (action_type == 1)
            {
                sql += " and isnull(verify_user,'')=''";
            }
            else
            {
                sql += " and isnull(verify_user,'')!=''";
            }

            using(SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
            {
                while (reader.Read())
                {
                    int id = reader.GetInt32(0);
                    SFKuan m = dal.Get(id);
                    string title;
                    if (m.rp_flag.Equals("AR"))
                    {
                        title = "收款单";
                    }
                    else
                    {
                        title = "付款单";
                    }
                    
                    if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(m.new_date)))
                    {
                        return "操作月份已业务结账,不允许修改!";
                    }
                    LoginInfo li = new LoginInfo();
                    if (action_type == 1)
                    {
                        if (m.verify_uid != null)
                        {
                            return "不允许重复审核";
                        }
                        /*
                        if (new APCancelDAL().GetOneOrder_TotalNumbers(id) == 0)
                        {
                            return "表体为空不允许审核!";
                        }*/
                        m.verify_uid = li.uid;
                        m.verify_user = li.nickname;
                        //审核前检查
                        string result = Check(id, action_type);
                        if (!result.Equals("success"))
                        {
                            return result;
                        }
                    }
                    else
                    {
                        if (m.verify_uid == null)
                        {
                            return "不允许重复弃审";
                        }
                        if (dal.CheckHasDoNext(id))
                        {
                            return "此单已发生后续业务，不允许弃审!";
                        }
                        m.verify_uid = null;
                        m.verify_user = null;
                    }
                    
                    //启用事务
                    using (TransactionScope scope = new TransactionScope())
                    {
                        decimal acc_amount;//本次更新结算账户金额
                        //更新实体
                        dal.Update(m);
                        AccountDAL ac_dal = new AccountDAL();
                        if (action_type == 1)
                        {
                            if (m.rp_flag.Equals("AR"))
                            {
                                acc_amount = (decimal)m.nat_amount;
                            }
                            else
                            {
                                acc_amount = -(decimal)m.nat_amount;
                            }
                            new UserLogDAL().AddUserLog(title, "审核单据", m.sfk_id, m.order_number);
                        }
                        else
                        {
                            if (m.rp_flag.Equals("AR"))
                            {
                                acc_amount = -(decimal)m.nat_amount;
                            }
                            else
                            {
                                acc_amount = (decimal)m.nat_amount;
                            }
                            new UserLogDAL().AddUserLog(title, "弃审单据", m.sfk_id, m.order_number);
                        }
                        
                        SFKuanDAL sfk_dal = new SFKuanDAL();
                        APCancelDAL acl_dal = new APCancelDAL();
                        try
                        {
                            
                            if (m.ac_id != null)
                            {
                                //更新账户余额
                                ac_dal.UpdateAccountBalance((int)m.ac_id, acc_amount);
                            }
                        }
                        catch (Exception err)
                        {
                            return err.Message;
                        }
                        try
                        {
                            //更新应收应付账款的累计核销金额
                            sfk_dal.UpdateAPDetailHxAmount(m.sfk_id, action_type);
                        }
                        catch (Exception err)
                        {
                            return err.Message;
                        }
                        
                        //提交事务
                        scope.Complete();
                    }//end of trans
                }//end of while
            }//end of reader
            return "success";
        }//end of try
        catch (Exception e)
        {
            return e.Message;
        }

    }
    
    /// <summary>
    /// 上张或下张
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="type">操作类型</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string GetPrevNextID(int id, string type, string rp_flag)
    {
        SFKuanDAL dal = new SFKuanDAL();
        return dal.GetPrevNextID(id, type, rp_flag).ToString();
    }
    /// <summary>
    /// 得到某张收付款单已核销金额
    /// </summary>
    /// <param name="id">收付款单主表</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string GetCanceledAmount(int sfk_id)
    {
        try
        {
            SFKuanDAL dal = new SFKuanDAL();
            DataTable dt = dal.GetCanceledAmount(sfk_id);
            DataRow dr = dt.Rows[0];
            string res = dr["hx_amount"].ToString() + "|" + dr["nat_hx_amount"].ToString();
            return res;
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }
    
    /// <summary>
    /// 自动分配表体核销金额
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string AutoFenPei(int sfk_id)
    {
        try
        {
            SFKuanDAL sfk_dal = new SFKuanDAL();
            SFKuan sfk = sfk_dal.Get(sfk_id);
            decimal amount = Convert.ToDecimal(sfk.amount);
            APCancelDAL dal = new APCancelDAL();
            foreach (DataRow dr in sfk_dal.GetDetailsUnCancel(sfk_id).Rows)
            {
                APCancel m = dal.Get(Convert.ToInt32(dr["acl_id"]));
                int acl_id = Convert.ToInt32(dr["acl_id"]);
                decimal wait_hx = Convert.ToDecimal(dr["wait_hx_amount"]);
                //蓝票
                if (sfk.amount > 0)
                {
                    if (amount > 0)
                    {
                        if (amount > wait_hx)
                        {
                            m.hx_amount = wait_hx;
                        }
                        else
                        {
                            m.hx_amount = amount;
                        }
                        m.nat_hx_amount = Decimal.Round((decimal)m.hx_amount * (decimal)sfk.exchange_rate, 2);
                        dal.Update(m);
                        amount = amount - (decimal)m.hx_amount;

                    }
                }
                else//红票退货
                {
                    if (amount < 0)
                    {
                        if (amount < wait_hx)
                        {
                            m.hx_amount = wait_hx;
                        }
                        else
                        {
                            m.hx_amount = amount;
                        }
                        m.nat_hx_amount = Decimal.Round((decimal)m.hx_amount * (decimal)sfk.exchange_rate, 2);
                        dal.Update(m);
                        amount = amount - (decimal)m.hx_amount;
                    }
                }
            }
            return "success";
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }
}