﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;

public partial class ARAP_SFKuan_SFKuan_Document : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    public AuthUI auth = new AuthUI();
    AWGridFun aw = new AWGridFun();
    public SFKuan m;
    public int id;
    public string action;
    public Currency currency;
    public SettleStyle settle_style;
    public string title, rp_flag, prefix;
    protected void Page_Load(object sender, EventArgs e)
    {
        new LoginState().CheckLogin();
        rp_flag = Request.QueryString["rp_flag"];
        if (rp_flag.Equals("AR"))
        {
            title = "收款单";
            prefix = "ShouKuan";
        }
        else
        {
            title = "付款单";
            prefix = "FuKuan";
        }
        //模块权限编号,同时作为模块号
        string auth_code = "ARAP_" + prefix;
        //检查模块查看权限
        auth.AuthCheckAndResponse(auth_code);
        xview.Add("auth_code", auth_code);
        //创建grid控件的iframe
        xview.Add("grid_frame", aw.CreateGridFrameForDoc(""));
        SFKuanDAL dal = new SFKuanDAL();

        if(Request["action"] != null)
        {
            action = Request.QueryString["action"];
        }else{
            action = "Add";
        }
        if(action.Equals("Add")){
            currency = new CurrencyDAL().GetStandard();
            settle_style = new SettleStyleDAL().GetDefault();
            try
            {
                //带出本位币当月汇率
                decimal exchange_rate = new CurrencyRateDAL().GetCurrentMonthExchangeRate(currency.crc_id);
                xview.Add("exchange_rate", exchange_rate);
            }
            catch
            {
                xview.Add("exchange_rate", 1);
            }
        }
        if (Request["id"] != null)
        {
            id = Convert.ToInt32(Request["id"]);
            m = dal.Get(id);
            //把sql放入session中供打印用
            string sql_print_main_session_id = "sql_print_main_" + prefix;
            Session[sql_print_main_session_id] = dal.sql_print;
            xview.Add("sql_print_main_session_id", sql_print_main_session_id);
        }
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        InputUI ui = new InputUI();
        string sql_select_field = "";//SQL所需选择列
        string module = "ARAP_" + prefix + "_Header";//格式模块编号
        mfd.CreateInput(module, ref ui, ref sql_select_field, m);
        xview.Add("input_ui", ui.CreateUI());
        Hashtable ht_js = mfd.MakeJavaScript_GetInput(module);
        xview.Add("Script_GetInput", ht_js["Script_GetInput"].ToString());
        xview.Add("Script_SaveJSON", ht_js["Script_SaveJSON"].ToString());
        
        
        LoginInfo li = new LoginInfo();
        xview.Add("login_date", li.login_date);
    }
}