﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="SFKuan_Document.aspx.cs" Inherits="ARAP_SFKuan_SFKuan_Document" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/DocumentHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html>
<head>
    <title></title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript" src="../../Scripts/ModuleScript/StockFunction.js"></script>
    <script type="text/javascript">
        var id = "<%=id%>";
        var action = "<%=action%>";
        //搜索
        function search_grid() {
            var fg = document.getElementById("frame_grid");
            var url = "APCancel_Grid.aspx?rp_flag=<%=rp_flag%>&id=" + id + "&action=" + action;
            fg.src = url;
        }
        //新增单据
        function add_doc() {
            window.location = "SFKuan_Document.aspx?rp_flag=<%=rp_flag%>&action=Add";
        }
        //保存单据
        function save_doc() {
            <%=xview["Script_GetInput"] %>
            ShowLoadingMask(); //显示遮罩
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'SFKuan_Service.asmx/Save',
                data: "{action:'" + action + "',rp_flag:'<%=rp_flag%>',<%=xview["Script_SaveJSON"]%>}",
                dataType: 'json',
                success: function (result) {
                    HideLoadingMask(); //关闭遮罩
                    var arr = result.d.split("|");
                    if (arr[0] == "success") {
                        AlertOK('保存成功!');
                        if(action == "Add"){
                            action = "Update";
                            id = arr[1];
                            window.location = 'SFKuan_Document.aspx?rp_flag=<%=rp_flag%>&action=Update&id=' + id;
                        }
                        CloseDivWin(); //关闭窗口
                    } else {
                        AlertNO(arr[0]);
                    }
                }
            });
        }
        //删除单据
        function delete_doc(){
            asyncbox.confirm('确定要删除本单据吗?', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: 'SFKuan_Service.asmx/Delete',
                        data: "{ids:'" + id + "',rp_flag:'<%=rp_flag%>'}",
                        dataType: 'json',
                        success: function (result) {
                            HideLoadingMask(); //关闭遮罩
                            var arr = result.d.split('|');
                            if(arr[0] == "success"){
                                AlertOK("删除成功！");
                                if(arr[1] != "0"){
                                    window.location = 'SFKuan_Document.aspx?rp_flag=<%=rp_flag%>&action=Update&id=' + arr[1];
                                }else{
                                    add_doc();
                                }
                            }else{
                                AlertNO(result.d);
                            }
                        }
                    });
                }
            });
        }
        //审核
        function verify_doc(action_type) {
            var title = '审核';
            if(action_type==-1)
                title = '弃审';
            asyncbox.confirm('确定要' + title + '本单据吗?', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: 'SFKuan_Service.asmx/Verify',
                        data: "{ids:'" + id + "',action_type:'" + action_type + "'}",
                        dataType: 'json',
                        success: function (result) {
                            HideLoadingMask(); //关闭遮罩
                            if (result.d == "success") {
                                var title = '审核';
                                if (action_type == -1)
                                    title = '弃审';
                                asyncbox.success(title + '成功！', '操作成功！', function (buttonResult) {
                                    window.location.reload();
                                });
                            } else {
                                AlertNO(result.d);
                            }
                        }
                    });
                }
            });
        }
        //检查单据
        function check_doc(){
            ShowLoadingMask(); //显示遮罩
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'SFKuan_Service.asmx/Check',
                data: "{id:'" + id + "',action_type:'1'}",
                dataType: 'json',
                success: function (result) {
                    HideLoadingMask(); //关闭遮罩
                    if(result.d == "success"){
                        AlertOK("检查没问题！");
                    }else{
                        AlertNO(result.d);
                    }
                }
            });
        }
        //核销
        function cancel_doc() {
            asyncbox.confirm('此操作会自动带出未核销的单据，同时会先清空本单表体，确定要进行此操作吗?', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: 'SFKuan_Service.asmx/CancelDoc',
                        data: "{id:'" + id + "'}",
                        dataType: 'json',
                        success: function (result) {
                            HideLoadingMask(); //关闭遮罩

                            if (result.d == "success") {
                                asyncbox.confirm('是否需要自动分配本次核销金额?', '提示', function (buttonResult) {
                                    if (buttonResult == "ok") {
                                        ShowLoadingMask(); //显示遮罩
                                        $.ajax({
                                            type: "POST",
                                            contentType: "application/json",
                                            url: 'SFKuan_Service.asmx/AutoFenPei',
                                            data: "{sfk_id:'" + id + "'}",
                                            dataType: 'json',
                                            success: function (result) {
                                                HideLoadingMask(); //关闭遮罩
                                                if (result.d != "success") {
                                                    AlertNO(result.d);
                                                    return;
                                                }
                                                search_grid();
                                            }
                                        });
                                    } else {
                                        search_grid();
                                    }
                                });
                                
                            } else {
                                AlertNO(result.d);
                            }
                        }
                    });
                }
            });
        }
        //新增行
        function add_row() {
            if(action == "Add")return;
            if(action == "Add"){
                AlertNO("请先保存表头后才进行表体数据添加！");
                return;
            }
            asyncbox.open({
                id: 'win_modify',
                url: 'SFKuans_Edit.aspx?rp_flag=<%=rp_flag%>&action=Add&id=' + id,
                modal: true,
                title: '新增'
            });
            
        }
        //修改行
        function edit_row() {
            if(action == "Add")return;
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var did = cw.aw_GetSelectRows(cw._skf_id); //返回一维数组
            if (did == "")
                return;
            if (did.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            if (did.length > 1) {
                AlertNO('一次只可以查看一条记录!');
                return;
            }
            asyncbox.open({
                id: 'win_modify',
                url: 'SFKuans_Edit.aspx?rp_flag=<%=rp_flag%>&action=Update&id=' + id + '&did=' + did,
                modal: true,
                title: '修改'
            });
        }

        //删除行
        function del_row(){
            if(action == "Add")return;
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var ids = cw.aw_GetSelectRows(cw._acl_id); //返回一维数组
            if (ids.length == 0) {
                AlertNO('请选择要删除的记录!');
                return;
            }
            asyncbox.confirm('确定要删除该行吗?', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: 'APCancel_Service.asmx/Delete',
                        data: "{ids:'" + ids + "'}",
                        dataType: 'json',
                        success: function (result) {
                            HideLoadingMask(); //关闭遮罩
                            if(result.d != "success"){
                                AlertNO(result.d);
                                return;
                            }
                            AlertOK("删除成功!");
                            fg.src=fg.src;
                        }
                    });
                }
            });
        }
        //上张下张
        function prev_next_doc(type){
            ShowLoadingMask(); //显示遮罩
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'SFKuan_Service.asmx/GetPrevNextID',
                data: "{id:'" + id + "',type:'" + type + "',rp_flag:'<%=rp_flag%>'}",
                dataType: 'json',
                success: function (result) {
                    HideLoadingMask(); //关闭遮罩
                    if(result.d==0){
                        AlertNO("不能再翻了！");
                        return;
                    }
                    window.location = 'SFKuan_Document.aspx?rp_flag=<%=rp_flag%>&action=Update&id=' + result.d;
                }
            });
        }

        //禁用按钮
        function disable_button(){
            if(action == "Add"){
                $('#btn_delete_doc').linkbutton('disable');
                $('#btn_save_doc').linkbutton('enable');
                $('#btn_check_doc').linkbutton('disable');
                $('#btn_verify_doc').linkbutton('disable');
                $('#btn_add_row').linkbutton('disable');
                $('#btn_del_row').linkbutton('disable');
                $('#btn_prev_doc').linkbutton('enable');
                $('#btn_next_doc').linkbutton('enable');
                $('#btn_print').linkbutton('disable');
                $('#m_trace').menubutton('disable');
                $('#btn_cancel_doc').linkbutton('disable');
            }else{
                $('#btn_delete_doc').linkbutton('enable');
                $('#btn_save_doc').linkbutton('enable');
                $('#btn_verify_doc').linkbutton('enable');
                $('#btn_add_row').linkbutton('enable');
                $('#btn_del_row').linkbutton('enable');
                $('#btn_prev_doc').linkbutton('enable');
                $('#btn_next_doc').linkbutton('enable');
                $('#btn_print').linkbutton('enable');
                $('#m_trace').menubutton('enable');
                if(b_verify){
                    //禁止所有文本框进行输入
                    disable_all_input();
                    $('#btn_add_row').linkbutton('disable');
                    $('#btn_del_row').linkbutton('disable');
                    $('#btn_delete_doc').linkbutton('disable');
                    $('#btn_save_doc').linkbutton('disable');
                    $('#btn_check_doc').linkbutton('disable');
                    $('#btn_cancel_doc').linkbutton('disable');
                }
            }
            
        }
        //找单
        function find_doc(){
            var url = '../../ARAP/Report/SFKuan_List.aspx?rp_flag=<%=rp_flag%>';
            var tab_id = 'ARAP_Report_SFKuan_List_<%=rp_flag%>';
            top.OpenWindow('Activate', tab_id, '<%=title%>明细表', url);
        }
        //打印表头用的SQL
        var sql_print_main_session_id = "<%=xview["sql_print_main_session_id"]%>";
        //选择打印模板
        function grf_print(){
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            choice_print_template('<%=xview["auth_code"]%>',sql_print_main_session_id,cw.sql_print_detail_session_id);
        }

    </script>
</head>
<body onload="search_grid();">
    <!--工具栏-->
    <div style="height:30px;" class="list_menu_bar" id="list_menu_bar">
        <a plain="true" class="easyui-linkbutton" onClick="add_doc()" id="btn_add_doc" style='<%=auth.AuthView("ARAP_" + prefix + "_Edit")%>'>新增</a>
        <a plain="true" class="easyui-linkbutton" onClick="delete_doc()" id="btn_delete_doc" style='<%=auth.AuthView("ARAP_" + prefix + "_Delete")%>'>删单</a>
        <a plain="true" class="easyui-linkbutton" onClick="save_doc()" id="btn_save_doc" style='color:Green;<%=auth.AuthView("ARAP_" + prefix + "_Edit")%>'>保存</a>
        <a plain="true" class="easyui-linkbutton" onClick="check_doc()" id="btn_check_doc" style="display:none">检查</a>
        <a plain="true" class="easyui-linkbutton" onClick="cancel_doc()" id="btn_cancel_doc" style='color:green;<%=auth.AuthView("ARAP_" + prefix + "_Edit")%>'>核销</a>
        <a plain="true" class="easyui-linkbutton" onClick="verify_doc(1)" id="btn_verify_doc" style='<%=auth.AuthView("ARAP_" + prefix + "_Verify")%>'>审核</a>
        <a plain="true" class="easyui-linkbutton" onClick="verify_doc(-1)" id="btn_unverify_doc" style='<%=auth.AuthView("ARAP_" + prefix + "_CancelVerify")%>'>弃审</a>
        <a plain="true" class="easyui-linkbutton" onClick="add_row()" id="btn_add_row" style='display:none;color:Green;<%=auth.AuthView("ARAP_" + prefix + "_Edit")%>'>增行</a>
        <a plain="true" class="easyui-linkbutton" onClick="del_row()" id="btn_del_row" style='<%=auth.AuthView("ARAP_" + prefix + "_Edit")%>'>删行</a>
        <a plain="true" class="easyui-linkbutton" onClick="search_grid()" id="btn_reflesh">刷新</a>
        <a plain="true" class="easyui-linkbutton" onClick="find_doc()" id="btn_find_doc">找单</a>
        <a plain="true" class="easyui-linkbutton" id="btn_prev_doc" onclick='prev_next_doc(1)'>上张</a>
        <a plain="true" class="easyui-linkbutton" id="btn_next_doc" onclick='prev_next_doc(2)'>下张</a>
        <a plain="true" class="easyui-linkbutton" id="btn_print" onclick='grf_print()' style='<%=auth.AuthView("ARAP_" + prefix + "_Print")%>'>打印</a>
        <a plain="true" id="m_format" class="easyui-menubutton" menu="#menu_format" style='<%=auth.FormatView()%>'>格式</a>
    </div>
    <!--表头-->
    <div id="doc_head">
        <div id="doc_caption"><%=title%></div>
        <%=xview["input_ui"]%>
    </div>
    <!--表体-->
    <%=xview["grid_frame"]%>
    <!--页脚-->
    <div id="doc_footer">
    </div>

    <!--格式定义下拉菜单-->
    <div id="menu_format" style="width:150px;">
        <div onclick="DesignModuleFormat('ARAP_<%=prefix%>_Header')">表头</div>
        <div onclick="DesignModuleFormat('ARAP_APCancel_<%=prefix%>_Input')">明细</div>
	</div>
    <script type="text/javascript">
        //指定当前的WebService，供引入JavaScript库时方便调用
        var Main_Service = "SFKuan_Service.asmx";
        var b_verify = false;//是否审核
        //初始化页面
        function init_page() {
            FastSearch_Customer(); //查询客户
            FastSearch_Vendor(); //查询供应商
            FastSearch_Currency(); //查询币种
            FastSearch_SettleStyle(); //查询结算方式
            FastSearch_Account(); //查询结算账户
            FastSearch_Department(); //查询部门
            FastSearch_Employee(); //业务员
            //选择自定义项档案
            <%for(int i=1;i<=5;i++){ %>
                $F("trigger_sdefine<%=i%>").onclick = function () {
                    AdvancedSearch_DefineItem($("#sdefine<%=i%>").val(),'SFKuan_sdefine<%=i%>','sdefine<%=i%>');
                };
            <%}
              for(int i=1;i<=5;i++){ %>
                $F("trigger_ndefine<%=i%>").onclick = function () {
                    AdvancedSearch_DefineItem($("#ndefine<%=i%>").val(),'SFKuan_ndefine<%=i%>','ndefine<%=i%>');
                };
            <%} %>
            <%if(action.Equals("Update")){ %>
                $F("ss_name").value = '<%=m.settle_style==null?"":m.settle_style.ss_name%>';
                $F("ac_name").value = '<%=m.account==null?"":m.account.ac_name%>';
                $F("cus_name").value = '<%=m.customer==null?"":m.customer.cus_name%>';
                $F("vd_name").value = '<%=m.vendor==null?"":m.vendor.vd_name%>';
                $F("crc_name").value = '<%=m.currency==null?"":m.currency.crc_name%>';
                $F("dep_name").value = '<%=m.department==null?"":m.department.dep_name%>';
                $F("ele_name").value = '<%=m.employee==null?"":m.employee.ele_name%>';
                <%if (m.customer != null)
                {%>
                    $F("cus_sdefine1").value = '<%=m.customer.sdefine1%>';//客户字符自定义项1
                    $F("cus_sdefine2").value = '<%=m.customer.sdefine2%>';//客户字符自定义项2
                    $F("cus_sdefine3").value = '<%=m.customer.sdefine3%>';//客户字符自定义项3
                    $F("cus_sdefine4").value = '<%=m.customer.sdefine4%>';//客户字符自定义项4
                    $F("cus_sdefine5").value = '<%=m.customer.sdefine5%>';//客户字符自定义项5

                    $F("cus_ndefine1").value = '<%=m.customer.ndefine1%>';//客户数值自定义项1
                    $F("cus_ndefine2").value = '<%=m.customer.ndefine2%>';//客户数值自定义项2
                    $F("cus_ndefine3").value = '<%=m.customer.ndefine3%>';//客户数值自定义项3
                    $F("cus_ndefine4").value = '<%=m.customer.ndefine4%>';//客户数值自定义项4
                    $F("cus_ndefine5").value = '<%=m.customer.ndefine5%>';//客户数值自定义项5
                <%}%>
                <%if(m.vendor!=null)
                {%>
                    $F("vd_sdefine1").value = '<%=m.vendor.sdefine1%>';//供应商字符自定义项1
                    $F("vd_sdefine2").value = '<%=m.vendor.sdefine2%>';//供应商字符自定义项2
                    $F("vd_sdefine3").value = '<%=m.vendor.sdefine3%>';//供应商字符自定义项3
                    $F("vd_sdefine4").value = '<%=m.vendor.sdefine4%>';//供应商字符自定义项4
                    $F("vd_sdefine5").value = '<%=m.vendor.sdefine5%>';//供应商字符自定义项5

                    $F("vd_ndefine1").value = '<%=m.vendor.ndefine1%>';//供应商数值自定义项1
                    $F("vd_ndefine2").value = '<%=m.vendor.ndefine2%>';//供应商数值自定义项2
                    $F("vd_ndefine3").value = '<%=m.vendor.ndefine3%>';//供应商数值自定义项3
                    $F("vd_ndefine4").value = '<%=m.vendor.ndefine4%>';//供应商数值自定义项4
                    $F("vd_ndefine5").value = '<%=m.vendor.ndefine5%>';//供应商数值自定义项5
                <%}%>
                var verify_uid = '<%=m.verify_uid%>';
                if(verify_uid != ''){
                    b_verify = true;
                    $F("btn_verify_doc").style.display = 'none';
                }else{
                    $F("btn_unverify_doc").style.display = 'none';
                }
            <%}else{ %>
                $F("new_date").value = '<%=xview["login_date"]%>';
                $F("crc_id").value = '<%=currency==null?0:currency.crc_id%>';
                $F("crc_name").value = '<%=currency==null?"":currency.crc_name%>';
                $F("ss_id").value = '<%=settle_style==null?0:settle_style.ss_id%>';
                $F("ss_name").value = '<%=settle_style==null?"":settle_style.ss_name%>';
                $F("btn_unverify_doc").style.display = 'none';
                $F("exchange_rate").value = '<%=currency==null?"":xview["exchange_rate"]%>';
            <%} %>
            disable_button();
        }
        $(document).ready(function(){
            init_page();
        });

        //计算金额
        function count_amount() {
            if (IsSpaceOrNaN($F('exchange_rate').value)) {
                $F('exchange_rate').value = '1';
            } 
            //本币收款金额=收款金额*汇率
            $F('nat_amount').value = (parseFloat($F('amount').value) * parseFloat($F('exchange_rate').value)).toFixed(2);
            var fg = document.getElementById("frame_grid");
            var cw = fg.contentWindow;
            //cw.GetCanceledAmount();//计算未核销金额
        }
        //改金额
        $F("amount").onchange = function () {
            count_amount();
        }
        //改折让金额
        $F("zr_amount").onchange = function () {
            count_amount();
        }
        //改汇率
        $F("exchange_rate").onchange = function () {
            count_amount();
        }
    </script>
</body>
</html>
