﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="APCancel_Grid.aspx.cs" Inherits="ARAP_SFKuan_APCancel_Grid" Debug="true" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/DocumentGridObject.ascx" TagPrefix="include" TagName="GridObject" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/GridHeader.ascx" TagPrefix="include" TagName="GridHeader" %>


<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <include:GridHeader runat="server" ID="GridHeader" />
    <script type="text/javascript" src="../../Scripts/jquery-1.9.1.min.js"></script>
    <script type="text/javascript" src="../../Scripts/WebSite.js"></script>
    <script type="text/javascript">
        var id = '<%=Request["id"]%>';
         //打印表体用的SQL
        var sql_print_detail_session_id = "<%=xview["sql_print_detail_session_id"]%>";
    </script>
</head>
<body>
    <form id="main_form">
        <!--列表标题与样式-->
        <style type="text/css">
            <%=xview["aw_column_style"]%>
        </style>
        <!--为控件提供参数与数据-->
        <script type="text/javascript">
            <%=xview["fields_index"]%>
            <%=xview["aw_grid_info"]%>
        </script>
        <!--创建列表控件-->
        <include:GridObject runat="server" ID="GridObject" />
    </form>
<script type="text/javascript">
    obj.setSelectionMode("multi-cell"); //开启单元格多选模式
    obj.setCellEditable(true, _hx_amount);//让本次核销金额列可编辑
    //取消自带的双击事件
    obj.onRowDoubleClicked = function (event, row) {
    }

    //开始验证
    obj.onCellValidating = function (text, col, row) {
        //已审核禁止编辑
        if (parent.$("#verify_user").val() != "")
            return true;
        //返回true代理验证不通过
        if (isNaN(text)) {
            return true;
        }

    }
    //通过验证
    obj.onCellValidated = function (text, col, row) {
        //回写单据单价
        if (col == _hx_amount) {
            var acl_id = aw_myData[row][_acl_id];
            var hx_amount = aw_myData[row][_hx_amount];
            var nat_hx_amount = (hx_amount * parent.$('#exchange_rate').val()).toFixed(2);//本币核销金额
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'APCancel_Service.asmx/Save',
                data: "{acl_id:'" + acl_id + "',hx_amount:'" + hx_amount + "',nat_hx_amount:'" + nat_hx_amount + "'}",
                dataType: 'json',
                success: function (result) {
                    var r = result.d;
                    if (r == "success") {
                        obj.setCellText(nat_hx_amount, _nat_hx_amount, row);
                        //GetCanceledAmount();//计算未核销金额
                    } else {
                        alert(r);
                        //parent.AlertNO(r);
                    }
                }
            });
        }
    }
    //得到某张收付款单已核销金额
    function GetCanceledAmount() {
        
        $.ajax({
            type: "POST",
            contentType: "application/json",
            url: 'SFKuan_Service.asmx/GetCanceledAmount',
            data: "{sfk_id:'" + id + "'}",
            dataType: 'json',
            success: function (result) {
                var r = result.d;
                var arr = r.split("|");
                var acc_hx_amount = arr[0];//已核销金额
                var acc_hx_nat_amount = arr[1];//本币已核销金额
                parent.$("#acc_hx_amount").val(acc_hx_amount);
                parent.$("#acc_hx_nat_amount").val(acc_hx_nat_amount);
                var amount = parent.$("#amount").val();//收款金额
                var nat_amount = parent.$("#nat_amount").val();//本币收款金额
                var zr_amount = parent.$('#zr_amount').val();//折让金额
                var zr_nat_amount = parent.$('#zr_nat_amount').val();//本币折让金额
                if (isNaN(amount) || amount == "") amount = 0;
                if (isNaN(zr_amount) || zr_amount == "") zr_amount = 0;
                if (isNaN(nat_amount) || nat_amount == "") nat_amount = 0;
                if (isNaN(zr_nat_amount) || zr_nat_amount == "") zr_nat_amount = 0;
                //未核销金额=收款金额+折让金额-已核销金额
                var wait_hx_amount = parseFloat(amount) + parseFloat(zr_amount) - parseFloat(acc_hx_amount);
                var wait_hx_nat_amount = parseFloat(nat_amount) + parseFloat(zr_nat_amount) - parseFloat(acc_hx_nat_amount);
                wait_hx_amount = JSRound(wait_hx_amount,2);
                wait_hx_nat_amount = JSRound(wait_hx_nat_amount,2);
                parent.$("#wait_hx_amount").val(wait_hx_amount);
                parent.$("#wait_hx_nat_amount").val(wait_hx_nat_amount);
            }
        });
    }
    window.onload = function () {
        //GetCanceledAmount();
    }
</script>
</body>
</html>
