﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;
public partial class ARAP_Report_CancelOrder_List_Grid : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    AWGridFun aw = new AWGridFun();
    public string title, rp_flag, prefix;
    protected void Page_Load(object sender, EventArgs e)
    {
        new LoginState().CheckLogin();
        if(!Page.IsPostBack)
        {
             CreateGrid();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //设置标题与样式
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        string sql_select_field = "";//SQL所需选择列
        string module = "ARAP_Report_CancelOrder_List";//模块
        string fields_index = "";//列索引
        mfd.CreateTitlesAndStyles(module, ref aw, ref sql_select_field, ref fields_index);
        xview.Add("fields_index", fields_index);
        //把样式传递到页面
        xview.Add("aw_column_style",aw.GetStyles());
        int page = 1;//当前页
        if (Request.QueryString["page"] != null)
            page = Convert.ToInt32(Request.QueryString["page"]);
        int page_size = aw.GetDefaultPageSize();//每页显示条数
        if (Request.QueryString["page_size"] != null)
            page_size = Convert.ToInt32(Request.QueryString["page_size"]);
        
        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by new_date desc,co_id desc";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        if (!Request["keyword"].Equals(""))
        {
            //要搜索关键字
            string keyword = Request["keyword"].ToString();
            //要搜索的字段
            string search_fields = "order_number,new_user,verify_user,crc_name,remark,"
                                + "cus_name,vd_name,cl_type_name,total_nat_amount";

            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, search_fields);
        }
        if (Request["so_id"] != null && !Request["so_id"].Equals(""))
        {
            sql_end += " and so_id='" + Request["so_id"] + "' ";
        }
        if (!Request["begin_date"].Equals(""))
        {
            sql_end += " and t.new_date>='" + Request["begin_date"] + "'";
        }
        if (!Request["end_date"].Equals(""))
        {
            sql_end += " and t.new_date<='" + Request["end_date"] + "'";
        }
        if (!Request["order_number"].Equals(""))
        {
            sql_end += " and order_number like '%" + Request["order_number"] + "%'";
        }

        if (!Request["cus_name"].Equals(""))
        {
            sql_end += " and cus_name='" + Request["cus_name"] + "'";
        }
        if (!Request["vd_name"].Equals(""))
        {
            sql_end += " and vd_name='" + Request["vd_name"] + "'";
        }

        if (Request["is_verify"].Equals("0"))
        {
            sql_end += " and isnull(verify_user,'')='' ";
        }
        if (Request["is_verify"].Equals("1"))
        {
            sql_end += " and isnull(verify_user,'')!='' ";
        }
        if (!Request["cl_type"].Equals(""))
        {
            sql_end += " and isnull(cl_type,'')='" + Request["cl_type"] + "' ";
        }
        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = GetList(ht, sql_select_field);
        //把sql放入session中供打印用
        string sql_print_detail_session_id = "sql_print_detail_" + module;
        Session[sql_print_detail_session_id] = sql_print;
        //Response.Write(sql_print);
        xview.Add("sql_print_detail_session_id", sql_print_detail_session_id);
        //供导出Excel用
        string field_for_export = mfd.field_for_export;
        Session[sql_print_detail_session_id + "_export_field"] = field_for_export;
        //得到总记录数为分页提供依据
        int rows_count = GetList_TotalNumbers(ht);
        //开启合计行功能
        aw.to_sum_row = true;
        //从模板读出哪些列需要合计
        aw.last_row_info = mfd.last_row_info;
        string aw_grid_info = aw.MakeGridObject(dt, rows_count, page_size, page);
        //把控件参数与数据源传递到页面
        xview.Add("aw_grid_info", aw_grid_info);
    }
    //打印用的sql
    public string sql_print = "";
    //列表查询用的sql
    string sql_list = @"
                    select top 1000000000 co.co_id,co.order_number,
                    convert(char(10),co.new_date,23) as new_date,co.cl_type,ct.cl_type_name,
                    co.cus_id,co.vd_id,cus.cus_name,vd.vd_name,co.crc_id,crc.crc_name,co.exchange_rate,
                    co.new_user,co.verify_user,co.remark,
                    cl.total_amount,cl.total_nat_amount
                    from ARAP_CancelOrder co
                    left join Base_Customer cus on co.cus_id=cus.cus_id
                    left join Base_Vendor vd on co.vd_id=vd.vd_id
                    left join Base_Currency crc on co.crc_id=crc.crc_id
                    left join ARAP_CancelType ct on co.cl_type=ct.cl_type
                    left join (select co_id,sum(hx_amount) as total_amount,sum(nat_hx_amount) as total_nat_amount 
                                from ARAP_APCancel where isnull(apd_id,0)<>0 group by co_id) cl 
                    on co.co_id=cl.co_id
                    where 1=1 ";
    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(@sql_list)t where 1=1 ";
        sql = sql.Replace("@sql_list", sql_list)
                 .Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);
        sql_print = "select top 1000000000 * from (" + sql_list + ") t where 1=1 " + pg["sql_end"] + " " + pg["order_field"].ToString();
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        //Response.Write(sql);
        //Response.End();
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from (" + sql_list + ")t where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
}
