﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="CancelOrder_List.aspx.cs" Inherits="ARAP_Report_CancelOrder_List" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        //搜索
        function search_grid() {
            var fg = document.getElementById("frame_grid");
            var keyword = $("#keyword").val();
            var begin_date = $("#begin_date").val();
            var end_date = $("#end_date").val();
            var order_number = $("#order_number").val();
            var cus_name = $("#cus_name").val();
            var vd_name = $("#vd_name").val();
            var is_verify = $("#is_verify").val();
            var cl_type = $("#cl_type").val();
            var url = "CancelOrder_List_Grid.aspx?keyword=" + keyword
                    + "&begin_date=" + begin_date + "&end_date=" + end_date
                    + "&order_number=" + order_number
                    + "&cus_name=" + cus_name + "&vd_name=" + vd_name
                    + "&is_verify=" + is_verify + "&cl_type=" + cl_type;
            fg.src = url;
        }
        //联查
        function modify() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._co_id); //返回一维数组
            var order_number = cw.aw_GetSelectRows(cw._order_number); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以查看一条记录!');
                return;
            }
            if (id == "")
                return;
            var url = '../../ARAP/CancelOrder/CancelOrder_Document.aspx?action=Update&id=' + id;
            top.OpenWindow('Activate', 'ARAP_CancelOrder_' + id, '<%=title%>' + order_number, url);
        }
        //选择打印模板
        function grf_print() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            choice_print_template('<%=xview["auth_code"]%>', "", cw.sql_print_detail_session_id);
        }
        //删除单据
        function delete_doc() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._co_id); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要删除的记录!');
                return;
            }
            asyncbox.confirm('确定要删除本单据吗?', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: '../CancelOrder/CancelOrder_Service.asmx/Delete',
                        data: "{ids:'" + id + "'}",
                        dataType: 'json',
                        success: function (result) {
                            HideLoadingMask(); //关闭遮罩
                            var arr = result.d.split('|');
                            if (arr[0] == "success") {
                                AlertOK("删除成功！");
                                fg.src = fg.src;
                            } else {
                                AlertNO(result.d);
                            }
                        }
                    });
                }
            });
        }
        //审核
        function verify_doc(action_type) {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._co_id); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要' + title + '的记录!');
                return;
            }
            var title = '审核';
            if (action_type == -1)
                title = '弃审';
            asyncbox.confirm('确定要' + title + '本单据吗?', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: '../CancelOrder/CancelOrder_Service.asmx/Verify',
                        data: "{ids:'" + id + "',action_type:'" + action_type + "'}",
                        dataType: 'json',
                        success: function (result) {
                            HideLoadingMask(); //关闭遮罩
                            if (result.d == "success") {
                                AlertOK(title + "成功！");
                                fg.src = fg.src;
                            } else {
                                AlertNO(result.d);
                            }
                        }
                    });
                }
            });
        }
    </script>
</head>
<body>
    <!--工具栏-->
    <div style="height:30px;" class="list_menu_bar">
        <input type="text" class="keyword_box" id="keyword"/>
        <a plain="true" class="easyui-linkbutton" onclick="search_grid()">搜索</a>
        <a plain="true" class="easyui-linkbutton" onclick="$('#search_win').window('open')" iconcls="icon-search">高级搜索</a>
        <a plain="true" class="easyui-linkbutton" onclick="modify()">联查</a>
        <a plain="true" id="m_operate" class="easyui-menubutton" menu="#menu_operate">操作</a>
        <a plain="true" class="easyui-linkbutton" id="btn_print" onclick='grf_print()'>打印</a>
        <a plain="true" class="easyui-linkbutton" onclick="DesignModuleFormat('ARAP_Report_<%=prefix%>_List')">格式</a>
    </div>
    <!--操作下拉菜单-->
    <div id="menu_operate" style="width:150px;">
        <div onclick="delete_doc()" style='<%=auth.AuthView("ARAP_CancelOrder_Delete")%>'>删除</div>
        <div onclick="verify_doc(1)" style='<%=auth.AuthView("ARAP_CancelOrder_Verify")%>'>审核</div>
        <div onclick="verify_doc(-1)" style='<%=auth.AuthView("ARAP_CancelOrder_CancelVerify")%>'>弃审</div>
	</div>
    <!--Grid控件所在的iframe-->
    <%=xview["grid_frame"]%>
    <!--搜索窗口-->  
	<div id="search_win" class="easyui-dialog" title="搜索"
        data-options="modal:true,closed:false,closable: false,iconCls:'icon-search'"
        style="width:500px;height:450px;padding:10px;">
		<table style="margin:auto;">
            <tr>
                <td style="text-align:right">是否审核:</td>
                <td>
                <select id='is_verify' class='select_box' style='margin-left:4px'>
                    <option value=""></option>
                    <option value="0">未审核</option>
                    <option value="1">已审核</option>
                </select></td>
            </tr>
            <tr>
                <td style="text-align:right">核销类型:</td>
                <td>
                <select id='cl_type' class='select_box' style='margin-left:4px'>
                    <option value=""></option>
                    <option value="3">预收冲应收</option>
                    <option value="4">预付冲应付</option>
                </select></td>
            </tr>
            <tr>
                <td style="text-align:right">起始日期:</td>
                <td>
                    <input type="text" class="edit_text_box" id="begin_date" style='width:120px' onclick='ShowDateControl()' value='<%=xview["begin_date"]%>'/></td>
            </tr>
            <tr>
                <td style="text-align:right">截止日期:</td>
                <td>
                    <input type="text" class="edit_text_box" id="end_date" style='width:120px' onclick='ShowDateControl()' value='<%=xview["end_date"]%>'/></td>
            </tr>
            <tr>
                <td style="text-align:right">单号:</td>
                <td><input type="text" class="edit_text_box" id="order_number"/></td>
            </tr>
            <tr id="tr_customer">
                <td style="text-align:right">客户:</td>
                <td>
                    <input type="hidden" class="edit_text_box" id="cus_id"/>
                    <input type="text" class="edit_text_box" id="cus_name" style='width:98px'/></td>
            </tr>
            <tr id="tr_vendor">
                <td style="text-align:right">供应商:</td>
                <td>
                    <input type="hidden" class="edit_text_box" id="vd_id"/>
                    <input type="text" class="edit_text_box" id="vd_name" style='width:98px'/></td>
            </tr>
		</table>
        <div style="margin-top:20px;text-align:center">
            <a href="javascript:search_grid()" class="easyui-linkbutton" onclick="javascript:$('#search_win').dialog('close')">搜索</a>
        </div>
	</div>
    <!--end of 搜索窗口--> 
    <script type="text/javascript">
        $(document).ready(function(){
            FastSearch_Customer(); //查询客户
            FastSearch_Vendor(); //查询供应商
            $F("keyword").focus();
            $F("keyword").onkeypress = function (evt) {
                evt = evt ? evt : (window.event ? window.event : null);
                if (evt.keyCode == "13") {
                    search_grid();
                }
            }
        });
    </script>
</body>
</html>
