﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;
public partial class ARAP_Report_APDetail_Grid : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    AWGridFun aw = new AWGridFun();
    public string title, rp_flag, prefix;
    protected void Page_Load(object sender, EventArgs e)
    {
        rp_flag = Request.QueryString["rp_flag"];
        if (rp_flag.Equals("AR"))
        {
            title = "应收明细账";
            prefix = "AR";
        }
        else
        {
            title = "应付明细账";
            prefix = "AP";
        }
        if(!Page.IsPostBack)
        {
            CreateGrid();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //设置标题与样式
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        string sql_select_field = "";//SQL所需选择列
        string module = "ARAP_Report_APDetail_" + prefix;//模块
        string fields_index = "";//列索引
        mfd.CreateTitlesAndStyles(module, ref aw, ref sql_select_field, ref fields_index);
        xview.Add("fields_index", fields_index);
        //把样式传递到页面
        xview.Add("aw_column_style",aw.GetStyles());
        int page = 1;//当前页
        if (Request.QueryString["page"] != null)
            page = Convert.ToInt32(Request.QueryString["page"]);
        int page_size = aw.GetDefaultPageSize();//每页显示条数
        if (Request.QueryString["page_size"] != null)
            page_size = Convert.ToInt32(Request.QueryString["page_size"]);
        
        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by new_date desc,apd_id desc";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        if (!Request["keyword"].Equals(""))
        {
            //要搜索关键字
            string keyword = Request["keyword"].ToString();
            //要搜索的字段
            string search_fields = "from_type,bus_type,remark,from_order_number,bus_order_number,"
                                + "i_code,i_name,standard,munit,aunit,dep_name,"
                                + "cus_name,vd_name,"
                                + "d_sdefine1,d_sdefine2,d_sdefine3,d_sdefine4,d_sdefine5";

            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, search_fields);
        }
        if (!Request["begin_date"].Equals(""))
        {
            sql_end += " and t.new_date>='" + Request["begin_date"] + "'";
        }
        if (!Request["end_date"].Equals(""))
        {
            sql_end += " and t.new_date<='" + Request["end_date"] + "'";
        }

        if (!Request["i_code"].Equals(""))
        {
            sql_end += " and i_code like '%" + Request["i_code"] + "%'";
        }
        if (!Request["i_name"].Equals(""))
        {
            sql_end += " and i_name like '%" + Request["i_name"] + "%'";
        }
        if (!Request["standard"].Equals(""))
        {
            sql_end += " and standard like '%" + Request["standard"] + "%'";
        }
        if (!Request["free1"].Equals(""))
        {
            sql_end += " and free1 like '%" + Request["free1"] + "%'";
        }
        if (!Request["free2"].Equals(""))
        {
            sql_end += " and free2 like '%" + Request["free2"] + "%'";
        }
        if (!Request["cus_name"].Equals(""))
        {
            sql_end += " and cus_name='" + Request["cus_name"] + "'";
        }
        if (!Request["vd_name"].Equals(""))
        {
            sql_end += " and vd_name='" + Request["vd_name"] + "'";
        }
        if (!Request["dep_name"].Equals(""))
        {
            sql_end += " and dep_name='" + Request["dep_name"] + "'";
        }

        if (Request["is_verify"].Equals("0"))
        {
            sql_end += " and isnull(verify_user,'')='' ";
        }
        if (Request["is_verify"].Equals("1"))
        {
            sql_end += " and isnull(verify_user,'')!='' ";
        }
        sql_end += " and rp_flag='" + Request["rp_flag"] + "'";
        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = GetList(ht, sql_select_field);
        //把sql放入session中供打印用
        string sql_print_detail_session_id = "sql_print_detail_" + module;
        Session[sql_print_detail_session_id] = sql_print;
        //Response.Write(sql_print);
        xview.Add("sql_print_detail_session_id", sql_print_detail_session_id);
        //供导出Excel用
        string field_for_export = mfd.field_for_export;
        Session[sql_print_detail_session_id + "_export_field"] = field_for_export;
        //得到总记录数为分页提供依据
        int rows_count = GetList_TotalNumbers(ht);
        //开启合计行功能
        aw.to_sum_row = true;
        //从模板读出哪些列需要合计
        aw.last_row_info = mfd.last_row_info;
        string aw_grid_info = aw.MakeGridObject(dt, rows_count, page_size, page);
        //把控件参数与数据源传递到页面
        xview.Add("aw_grid_info", aw_grid_info);
    }
    //打印用的sql
    public string sql_print = "";
    //列表查询用的sql
    string sql_list = @"
                    select top 1000000000 cus.cus_name,vd.vd_name,
                    i.i_code,i.i_name,i.standard,i.munit,i.aunit,
                    crc.crc_name,d.dep_name,i.sdefine1 as inv_sdefine1,
                    i.sdefine2 as inv_sdefine2,i.sdefine3 as inv_sdefine3,
                    i.sdefine4 as inv_sdefine4,i.sdefine5 as inv_sdefine5,
                    i.ndefine1 as inv_ndefine1,i.ndefine2 as inv_ndefine2,i.ndefine3 as inv_ndefine3,
                    i.ndefine4 as inv_ndefine4,i.ndefine5 as inv_ndefine5,
                    ap.apd_id,convert(char(10),ap.new_date,23) as new_date,
                    ap.rp_flag,ap.i_id,ap.free1,ap.free2,ap.batch,
                    ap.unit_price,ap.tax_unit_price,ap.quantity,ap.num,
                    ap.convert_rate,ap.total_price,ap.tax_total_price,
                    ap.nat_unit_price,ap.nat_total_price,ap.nat_tax_unit_price,ap.nat_tax_total_price,
                    ap.acc_hx_amount,ap.acc_hx_nat_amount,
                    isnull(ap.nat_tax_total_price,0)-isnull(ap.acc_hx_nat_amount,0) as wait_hx_nat_amount,
                    ap.tax_rate,ap.crc_id,ap.exchange_rate,ap.order_type,ap.cus_id,
                    ap.vd_id,ap.dep_id,ap.ele_id,ap.from_id,ap.from_type,ap.bus_type,ap.remark,ap.invoice_no,
                    ap.from_order_number,ap.bus_order_number,
                    ap.new_uid,ap.new_user,ap.update_uid,ap.update_user,ap.update_date,ap.verify_uid,ap.verify_user,
                    ap.d_sdefine1,ap.d_sdefine2,ap.d_sdefine3,ap.d_sdefine4,ap.d_sdefine5,
                    ap.d_ndefine1,ap.d_ndefine2,ap.d_ndefine3,ap.d_ndefine4,ap.d_ndefine5
                    from ARAP_APDetail ap
                    left join Base_Customer cus on ap.cus_id=cus.cus_id
                    left join Base_Vendor vd on ap.vd_id=vd.vc_id
                    left join Base_Currency crc on ap.crc_id=crc.crc_id
                    left join Base_Department d on ap.dep_id=d.dep_id
                    left join Base_Inventory i on ap.i_id=i.i_id
                     where 1=1 ";
    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(@sql_list)t where 1=1 ";
        sql = sql.Replace("@sql_list", sql_list)
                 .Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);
        sql_print = "select top 1000000000 * from (" + sql_list + ") t where 1=1 " + pg["sql_end"] + " " + pg["order_field"].ToString();
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        //Response.Write(sql);
        //Response.End();
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from (" + sql_list + ")t where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
}
