﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;

public partial class ARAP_OtherRP_OtherRP_Document : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    public AuthUI auth = new AuthUI();
    AWGridFun aw = new AWGridFun();
    public OtherRP m;
    public int id;
    public string action;
    public Currency currency;
    public ShipWay ship_way;
    public string title, rp_flag, prefix;
    protected void Page_Load(object sender, EventArgs e)
    {
        new LoginState().CheckLogin();
        rp_flag = Request.QueryString["rp_flag"];
        if (rp_flag.Equals("AR"))
        {
            title = "其它应收单";
            prefix = "AR";
        }
        else
        {
            title = "其它应付单";
            prefix = "AP";
        }
        //模块权限编号,同时作为模块号
        string auth_code = "ARAP_OtherRP_" + prefix;
        //检查模块查看权限
        auth.AuthCheckAndResponse(auth_code);
        xview.Add("auth_code", auth_code);
        //创建grid控件的iframe
        xview.Add("grid_frame", aw.CreateGridFrameForDoc(""));
        OtherRPDAL dal = new OtherRPDAL();

        if(Request["action"] != null)
        {
            action = Request.QueryString["action"];
        }else{
            action = "Add";
        }
        if(action.Equals("Add")){
            currency = new CurrencyDAL().GetStandard();
            ship_way = new ShipWayDAL().GetDefault();
            try
            {
                //带出本位币当月汇率
                decimal exchange_rate = new CurrencyRateDAL().GetCurrentMonthExchangeRate(currency.crc_id);
                xview.Add("exchange_rate", exchange_rate);
            }
            catch
            {
                xview.Add("exchange_rate", 1);
            }
        }
        if (Request["id"] != null)
        {
            id = Convert.ToInt32(Request["id"]);
            m = dal.Get(id);
            //把sql放入session中供打印用
            string sql_print_main_session_id = "sql_print_main_OtherRP_" + rp_flag;
            Session[sql_print_main_session_id] = dal.sql_print;
            xview.Add("sql_print_main_session_id", sql_print_main_session_id);
        }
        //Session["no_session"] = "select 1 as abc";
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        InputUI ui = new InputUI();
        string sql_select_field = "";//SQL所需选择列
        string module = "ARAP_OtherRP_" + prefix + "_Header";//模块
        mfd.CreateInput(module, ref ui, ref sql_select_field, m);
        xview.Add("input_ui", ui.CreateUI());
        Hashtable ht_js = mfd.MakeJavaScript_GetInput(module);
        xview.Add("Script_GetInput", ht_js["Script_GetInput"].ToString());
        xview.Add("Script_SaveJSON", ht_js["Script_SaveJSON"].ToString());
        
        
        LoginInfo li = new LoginInfo();
        xview.Add("login_date", li.login_date);
    }
}