﻿<%@ WebService Language="C#" Class="ARAP_CheckAccounts_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
//using SysCore.Model;
//using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class ARAP_CheckAccounts_Service : System.Web.Services.WebService
{
    
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        CheckAccountsDAL dal = new CheckAccountsDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                if (!id.Equals(""))
                {
                    dal.Delete(Convert.ToInt32(id));
                }
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }

    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string ca_id, string cas_id, string ios_id, 
        string d_wh_id, string d_wh_name, string i_id, string free1, string free2, string batch, string i_code, string i_name,
        string standard,string munit,string aunit,string unit_price,string tax_unit_price,
        string quantity,string num,string convert_rate,string total_price,string tax_total_price,string tax,
        string nat_unit_price, string nat_total_price,string nat_tax_unit_price, string nat_tax_total_price, string nat_tax,
        string d_tax_rate, string d_remark, 
        string d_sdefine1, string d_sdefine2, string d_sdefine3, string d_sdefine4, string d_sdefine5,
        string d_ndefine1, string d_ndefine2, string d_ndefine3, string d_ndefine4, string d_ndefine5)
    {
        if (string.IsNullOrWhiteSpace(i_id) || i_id.Equals("0"))
        {
            return "请输入存货！";
        }
        if (string.IsNullOrWhiteSpace(quantity) || quantity.Equals("0"))
        {
            return "数量不可为空或零！";
        }
        try
        {
            CheckAccountsDAL dal = new CheckAccountsDAL();

            CheckAccounts m = new CheckAccounts();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(cas_id));
            }
            m.ios_id = XTools.ObjectNullToInt(ios_id);
            m.ca_id = Convert.ToInt32(ca_id);
            if (d_wh_name.Equals("") || d_wh_id.Equals("0"))
            {
                d_wh_id = "";
            }
            m.d_wh_id = XTools.ObjectNullToInt(d_wh_id);
            m.i_id = Convert.ToInt32(i_id);
            free1 = free1.Trim(); 
            free2 = free2.Trim();
            Inventory inv = new InventoryDAL().Get(Convert.ToInt32(i_id));
            if (!free1.Equals("") && inv.on_free1 == 0)
                return "存货不允许输入自由项1！";
            if (!free2.Equals("") && inv.on_free2 == 0)
                return "存货不允许输入自由项2！";
            if (free1.Equals("") && inv.on_free1 == 1)
                return "存货必须输入自由项1！";
            if (free2.Equals("") && inv.on_free2 == 1)
                return "存货必须输入自由项2！";
            m.free1 = free1;
            m.free2 = free2;
            if (!batch.Equals("") && inv.on_batch == 0)
                return "存货不允许输入批次！";
            if (batch.Equals("") && inv.on_batch == 1)
                return "存货必须输入批次！";
            if (inv.aunit.Equals("") && !num.Equals(""))
                return "未启用辅计量单位，启不要输入件数！";
            if (!inv.aunit.Equals(""))
            {
                if (num.Equals("") || num.Equals("0"))
                {
                    return "存货启用了辅计量单位，必须输入件数！";
                }
                if (convert_rate.Equals("") || convert_rate.Equals("0"))
                {
                    return "存货启用了辅计量单位，必须输入换算率！";
                }
            }
            m.batch = batch;
            m.unit_price = XTools.ObjectNullToDecimal(unit_price);
            m.tax_unit_price = XTools.ObjectNullToDecimal(tax_unit_price);
            m.quantity = XTools.ObjectNullToDecimal(quantity);
            m.num = XTools.ObjectNullToDecimal(num);
            m.convert_rate = XTools.ObjectNullToDecimal(convert_rate);
            m.total_price = XTools.ObjectNullToDecimal(total_price);
            m.tax_total_price = XTools.ObjectNullToDecimal(tax_total_price);
            m.tax = XTools.ObjectNullToDecimal(tax);
            m.nat_unit_price = XTools.ObjectNullToDecimal(nat_unit_price);
            m.nat_total_price = XTools.ObjectNullToDecimal(nat_total_price);
            m.nat_tax_unit_price = XTools.ObjectNullToDecimal(nat_tax_unit_price);
            m.nat_tax_total_price = XTools.ObjectNullToDecimal(nat_tax_total_price);
            m.nat_tax = XTools.ObjectNullToDecimal(nat_tax);
            m.d_tax_rate = XTools.ObjectNullToDecimal(d_tax_rate);
            m.d_remark = d_remark;
            m.d_sdefine1 = d_sdefine1;
            m.d_sdefine2 = d_sdefine2;
            m.d_sdefine3 = d_sdefine3;
            m.d_sdefine4 = d_sdefine4;
            m.d_sdefine5 = d_sdefine5;
            m.d_ndefine1 = XTools.ObjectNullToDecimal(d_ndefine1);
            m.d_ndefine2 = XTools.ObjectNullToDecimal(d_ndefine2);
            m.d_ndefine3 = XTools.ObjectNullToDecimal(d_ndefine3);
            m.d_ndefine4 = XTools.ObjectNullToDecimal(d_ndefine4);
            m.d_ndefine5 = XTools.ObjectNullToDecimal(d_ndefine5);
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                dal.Add(m);
            }
        }
        catch (Exception e)
        {
            return e.Message;
        }
        return "success";
    }
 
    /// <summary>
    /// 出库单多选
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string MultiSelect(string ca_id, string ids)
    {
        try
        {
            CheckAccountDAL tdal = new CheckAccountDAL();
            CheckAccount t = tdal.Get(Convert.ToInt32(ca_id));
            string[] arr = ids.Split(',');
            InOutsDAL sdal = new InOutsDAL();
            CheckAccountsDAL cas_dal = new CheckAccountsDAL();
            int total_numbers = cas_dal.GetOneOrder_TotalNumbers(Convert.ToInt32(ca_id));
            bool has_get_from = false;//是否有从订单取数到表头
            for (int i = 0; i < arr.Length; i++)
            {
                int ios_id = Convert.ToInt32(arr[i]);
                InOuts ios = sdal.Get(ios_id, 0);
                //如果还没从订单取数到表头
                if (!has_get_from)
                {
                    //如果表体为零行，代表新增第一条记录，则默认从订单带出相关表头项
                    if (total_numbers == 0)
                    {
                        InOutDAL dal = new InOutDAL();
                        InOut io = dal.Get(ios.io_id);
                        t.cus_id = io.cus_id;
                        t.dep_id = io.dep_id;
                        t.ele_id = io.ele_id;
                        t.tax_rate = ios.d_tax_rate;
                        if (ios.purchase_orders != null)
                        {
                            t.tax_rate = ios.purchase_orders.d_tax_rate;
                            t.exchange_rate = ios.purchase_orders.parent_object.exchange_rate;
                            t.crc_id = ios.purchase_orders.parent_object.crc_id;
                        }
                        t.remark = io.remark;
                        t.sdefine1 = io.sdefine1;
                        t.sdefine2 = io.sdefine2;
                        t.sdefine3 = io.sdefine3;
                        t.sdefine4 = io.sdefine4;
                        t.sdefine5 = io.sdefine5;
                        t.ndefine1 = io.ndefine1;
                        t.ndefine2 = io.ndefine2;
                        t.ndefine3 = io.ndefine3;
                        t.ndefine4 = io.ndefine4;
                        t.ndefine5 = io.ndefine5;
                        tdal.Update(t);
                    }
                    has_get_from = true;
                }
                CheckAccounts m = new CheckAccounts();
                m.ca_id = Convert.ToInt32(ca_id);
                m.d_wh_id = ios.d_wh_id;
                m.ios_id = ios.ios_id;
                m.i_id = ios.i_id;
                m.free1 = ios.free1;
                m.free2 = ios.free2;
                m.batch = ios.batch;

                if (t.rp_flag.Equals("AR"))
                {
                    //如果出库来自发货单
                    if (ios.delivery_orders != null)
                    {
                        m.unit_price = ios.delivery_orders.unit_price;//无税单价=发货无税单价
                        m.tax_unit_price = ios.delivery_orders.tax_unit_price;//含税单价=发货含税单价
                        m.nat_unit_price = ios.delivery_orders.nat_unit_price;//本币无税单价=发货本币无税单价
                        m.nat_tax_unit_price = ios.delivery_orders.nat_tax_unit_price;//本币含税单价=发货本币含税单价
                        m.d_tax_rate = ios.delivery_orders.d_tax_rate;//税率=发货表体税率
                    }
                    else
                    {
                        return "对账业务需要做发货单，不允许直接对出库单进行对账！";
                    }
                }
                else
                {
                    //如果入库来自采购订单
                    if (ios.purchase_orders != null)
                    {
                        m.unit_price = ios.purchase_orders.unit_price;//无税单价=订单无税单价
                        m.tax_unit_price = ios.purchase_orders.tax_unit_price;//含税单价=订单含税单价
                        m.nat_unit_price = ios.purchase_orders.nat_unit_price;//本币无税单价=订单本币无税单价
                        m.nat_tax_unit_price = ios.purchase_orders.nat_tax_unit_price;//本币含税单价=订单本币含税单价
                        m.d_tax_rate = ios.purchase_orders.d_tax_rate;//税率=订单表体税率
                    }
                    else //否则来自入库单
                    {
                        m.unit_price = ios.unit_price;//无税单价=入库单无税单价
                        m.tax_unit_price = ios.tax_unit_price;//含税单价=入库单含税单价
                        m.nat_unit_price = ios.unit_price;//本币无税单价=入库单本币无税单价
                        m.nat_tax_unit_price = ios.tax_unit_price;//本币含税单价=入库单本币含税单价
                        m.d_tax_rate = ios.d_tax_rate;//税率=入库单表体税率
                    }
                }
                decimal? wait_dz_quan = ios.quantity - XTools.DecimalNullToZero(ios.dz_quantity);//待对账数
                decimal? wait_dz_num = ios.num - XTools.DecimalNullToZero(ios.dz_num);//待对账数
                m.quantity = wait_dz_quan;
                if (!ios.inventory.aunit.Equals(""))
                {
                    m.num = wait_dz_num;
                    m.convert_rate = ios.convert_rate;
                }
                //无税金额=无税单价*数量
                m.total_price = Math.Round((decimal)(XTools.DecimalNullToZero(m.unit_price) * wait_dz_quan), 2);
                //本币无税金额=金额*对账单汇率
                m.nat_total_price = Math.Round((decimal)(XTools.DecimalNullToZero(m.total_price) * t.exchange_rate), 2);
                //含税金额=含税单价*数量
                m.tax_total_price = Math.Round((decimal)(XTools.DecimalNullToZero(m.tax_unit_price) * wait_dz_quan), 2);
                //本币含税金额=含税金额*汇率
                m.nat_tax_total_price = Math.Round((decimal)(XTools.DecimalNullToZero(m.tax_total_price) * t.exchange_rate), 2);
                //税额=含税金额-金额
                m.tax = XTools.DecimalNullToZero(m.tax_total_price) - XTools.DecimalNullToZero(m.total_price);
                //本币税额=税额*汇率
                m.nat_tax = XTools.DecimalNullToZero(m.nat_tax_total_price) - XTools.DecimalNullToZero(m.nat_total_price);

                m.d_sdefine1 = ios.d_sdefine1;
                m.d_sdefine2 = ios.d_sdefine2;
                m.d_sdefine3 = ios.d_sdefine3;
                m.d_sdefine4 = ios.d_sdefine4;
                m.d_sdefine5 = ios.d_sdefine5;
                m.d_ndefine1 = ios.d_ndefine1;
                m.d_ndefine2 = ios.d_ndefine2;
                m.d_ndefine3 = ios.d_ndefine3;
                m.d_ndefine4 = ios.d_ndefine4;
                m.d_ndefine5 = ios.d_ndefine5;
                cas_dal.Add(m);
                
            }
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }

    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public CheckAccounts Get(string cas_id)
    {
        CheckAccountsDAL dal = new CheckAccountsDAL();
        return dal.Get(Convert.ToInt32(cas_id));
    }
}