﻿<%@ WebService Language="C#" Class="ARAP_CancelOrder_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Collections;
using System.Transactions;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.DAL;
using SysCore.Model;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class ARAP_CancelOrder_Service : System.Web.Services.WebService
{
    /// <summary>
    /// 保存单据
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string cl_type, string action, string co_id, string order_number, string new_date,
        string cus_id, string cus_name,string vd_id, string vd_name,
        string crc_id, string crc_name, string exchange_rate, string remark)
    {
        string title = "核销单";
        if (cus_name.Equals("")) cus_id = "";
        if (vd_name.Equals("")) vd_id = "";
        if (crc_name.Equals("")) crc_id = "";

        if (string.IsNullOrWhiteSpace(new_date))
        {
            return "对账单日期不可为空！";
        }
        
        if (cl_type.Equals("3"))
        {
            if (string.IsNullOrWhiteSpace(cus_id))
            {
                return "客户不可为空！";
            }
        }
        else if (cl_type.Equals("4"))
        {
            if (string.IsNullOrWhiteSpace(vd_id))
            {
                return "供应商不可为空！";
            }
        }

        if (string.IsNullOrWhiteSpace(crc_id))
        {
            return "币种不可为空！";
        }
        //汇率为空或0时让等于1
        if (exchange_rate.Trim().Equals("") || exchange_rate.Trim().Equals("0"))
        {
            exchange_rate = "1";
        }
        try
        {
            if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(new_date)))
            {
                return "操作月份已业务结账,不允许修改!";
            }
            CancelOrderDAL dal = new CancelOrderDAL();
            CancelOrder m = new CancelOrder();
            LoginInfo li = new LoginInfo();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(co_id));
                m.update_uid = li.uid;
                m.update_user = li.nickname;//修改人名称
                m.update_date = DateTime.Now;//修改日期
                if (m.verify_uid != null)
                {
                    return "已审核不允许改单";
                }
                if (!m.order_number.Equals(order_number))
                {
                    if (dal.CheckExist(order_number))
                    {
                        return "您修改了单号，然而单号：" + order_number + "已存在，请尝试别的号码！";
                    }
                }
            }
            else
            {
                m.new_uid = li.uid;
                m.new_user = li.nickname;//新增人名称
            }
            try
            {
                m.cl_type = Convert.ToInt32(cl_type);//AR应收(收款),AP应付(付款)
                m.new_date = Convert.ToDateTime(new_date);
                m.order_number = order_number;
                m.cus_id = XTools.ObjectNullToInt(cus_id);
                m.vd_id = XTools.ObjectNullToInt(vd_id);
                m.crc_id = XTools.ObjectNullToInt(crc_id);
                m.exchange_rate = XTools.ObjectNullToDecimal(exchange_rate);
                m.remark = remark.ToString();
            }
            catch (Exception err)
            {
                return err.Message;
            }
            if (action.Equals("Update"))
            {
                                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    //更新表头
                    dal.Update(m);
                    new UserLogDAL().AddUserLog(title, "修改表头", m.co_id, m.order_number);
                    //提交事务
                    scope.Complete();
                }
            }
            else
            {
                //如果新增时单据号不为空说明是手工输入单号
                if (!order_number.Equals(""))
                {
                    if (dal.CheckExist(order_number))
                    {
                        return "单据号：" + order_number + "已存在！";
                    }
                }
                new UserLogDAL().AddUserLog(title, "新增单据", m.co_id, m.order_number);
                
                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    try
                    {
                        //新增表头
                        dal.Add(m);
                    }
                    catch (Exception err)
                    {
                        return err.Message;
                    } 
                    //得到新增保存后的最大ID号
                    int MaxID = dal.GetMaxID();
                    co_id = MaxID.ToString();
                    m = dal.Get(MaxID);
                    //如果流水号为空代表是系统自动流水
                    if (order_number.Equals(""))
                    {
                        //更新实体
                        try
                        {
                            //根据规则生成流水号
                            Hashtable ht_num = new Hashtable();
                            /*
                            if(m.customer != null)
                                ht_num.Add("[cus_code]", m.customer.cus_code);
                            if (m.vendor != null)
                                ht_num.Add("[vd_code]", m.vendor.vd_code);*/
                            string running_number = new RunningNumberRuleDAL().GetModuleRunningNumber("ARAP_CancelOrder", ht_num);
                            if(running_number.LastIndexOf("[") > -1)
                                return "自动生成流水号出错,请检查必填项目!";
                            m.order_number = running_number;
                            //更新实体
                            dal.Update(m);
                        }
                        catch(Exception err)
                        {
                            return "自动生成流水号出错!" + err.Message;
                        }
                    }
                    //提交事务
                    scope.Complete();
                }
            }
        }
        catch (Exception e)
        {
            return e.Message;
        }
        return "success|" + co_id;
    }

    /// <summary>
    /// 删单
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        string prev_id = "";
        try
        {
            CancelOrderDAL dal = new CancelOrderDAL();
            string sql = "select distinct co_id from ARAP_CancelOrder where co_id in (" + ids + ")";
            using(SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
            {
                while (reader.Read())
                {
                    int id = reader.GetInt32(0);
                    CancelOrder m = dal.Get(id);
                    if (m.verify_uid != null)
                    {
                        return "单据:" + m.order_number + "已审核不允许删单!";
                    }
                    if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(m.new_date)))
                    {
                        return "操作月份已业务结账,不允许修改!";
                    }
                    prev_id = GetPrevNextID(id, "1");//得到上一张单据ID
                    string msg = "";
                    //启用事务
                    using (TransactionScope scope = new TransactionScope())
                    {
                        new UserLogDAL().AddUserLog("核销单", "删除单据", m.co_id, m.order_number);
                        msg = dal.Delete(id);
                        if (!msg.Equals("success"))
                        {
                            return msg;
                        }
                        //提交事务
                        scope.Complete();
                    }
                }//end of reader
            }//end of using
            return "success|" + prev_id;
        }
        catch (Exception err)
        {
            return err.Message;
        }
        
    }
    /// <summary>
    /// 核销
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string CancelDoc(int id)
    {
        try
        {
            CancelOrderDAL dal = new CancelOrderDAL();
            CancelOrder m = dal.Get(id);
            if (m.cl_type.Equals("3"))
            {
                if (m.cus_id == null)
                {
                    return "请填写客户!";
                }
            }
            else if (m.cl_type.Equals("4"))
            {
                if (m.vd_id == null)
                {
                    return "请填写供应商!";
                }
            }
            //加载待核销数据
            dal.LoadNeedForCancel(id);

            return "success";
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }
    
        
    /// <summary>
    /// 检查
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Check(int id, int action_type)
    {
        try
        {
            CancelOrderDAL dal = new CancelOrderDAL();
            CancelOrder m = dal.Get(id);
            if (m.cl_type.Equals("3"))
            {
                if (m.cus_id == null)
                {
                    return "请填写客户!";
                }
            }
            else if (m.cl_type.Equals("4"))
            {
                if (m.vd_id == null)
                {
                    return "请填写供应商!";
                }
            }
            //检查必填项
            string result = dal.CheckMustInput(id);
            if (!result.Equals("success"))
            {
                return result;
            }
            //检查是否应收款是否超预收款单金额核销
            result = dal.CheckCancelOverSFKuanAmount(id);
            if (!result.Equals("success"))
            {
                return result;
            }
            //检查本次核销金额是否超应收金额
            result = dal.CheckCurrentOverAPAmount(id);
            if (!result.Equals("success"))
            {
                return result;
            }
            //检查本次核销金额是否超收付款金额
            result = dal.CheckCurrentOverSFKuanAmount(id);
            if (!result.Equals("success"))
            {
                return result;
            }
            return "success";
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }
    /// <summary>
    /// 审核或弃审
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Verify(string ids, int action_type)
    {
        try
        {
            CancelOrderDAL dal = new CancelOrderDAL();
            string sql = "select distinct co_id from ARAP_CancelOrder where co_id in (" + ids + ")";
            if (action_type == 1)
            {
                sql += " and isnull(verify_user,'')=''";
            }
            else
            {
                sql += " and isnull(verify_user,'')!=''";
            }

            using(SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
            {
                while (reader.Read())
                {
                    int id = reader.GetInt32(0);
                    CancelOrder m = dal.Get(id);
                    string title = "核销单";
                    if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(m.new_date)))
                    {
                        return "操作月份已业务结账,不允许修改!";
                    }
                    LoginInfo li = new LoginInfo();
                    if (action_type == 1)
                    {
                        
                        if (m.verify_uid != null)
                        {
                            return "不允许重复审核";
                        }
                        /*
                        if (new APCancelDAL().GetOneOrder_TotalNumbers(id) == 0)
                        {
                            return "表体为空不允许审核!";
                        }*/
                        m.verify_uid = li.uid;
                        m.verify_user = li.nickname;
                        //审核前检查
                        string result = Check(id, action_type);
                        if (!result.Equals("success"))
                        {
                            return result;
                        }
                    }
                    else
                    {
                        if (m.verify_uid == null)
                        {
                            return "不允许重复弃审";
                        }
                        m.verify_uid = null;
                        m.verify_user = null;
                    }
                    
                    //启用事务
                    using (TransactionScope scope = new TransactionScope())
                    {
                        //更新实体
                        dal.Update(m);
                        AccountDAL ac_dal = new AccountDAL();
                        if (action_type == 1)
                        {
                            new UserLogDAL().AddUserLog(title, "审核单据", m.co_id, m.order_number);
                        }
                        else
                        {
                            new UserLogDAL().AddUserLog(title, "弃审单据", m.co_id, m.order_number);
                        }
                        
                        CancelOrderDAL co_dal = new CancelOrderDAL();
                        APCancelDAL acl_dal = new APCancelDAL();
                        try
                        {
                            //更新应收应付账款的累计核销金额
                            co_dal.UpdateAPDetailHxAmount(m.co_id, action_type);
                        }
                        catch (Exception err)
                        {
                            return err.Message;
                        }
                        
                        //提交事务
                        scope.Complete();
                    }//end of trans
                }//end of while
            }//end of reader
            return "success";
        }//end of try
        catch (Exception e)
        {
            return e.Message;
        }

    }
    
    /// <summary>
    /// 上张或下张
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="type">操作类型</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string GetPrevNextID(int id, string type)
    {
        CancelOrderDAL dal = new CancelOrderDAL();
        return dal.GetPrevNextID(id, type).ToString();
    }
    /// <summary>
    /// 得到某张收付款单已核销金额
    /// </summary>
    /// <param name="id">收付款单主表</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string GetCanceledAmount(int co_id)
    {
        /*
        try
        {
            CancelOrderDAL dal = new CancelOrderDAL();
            DataTable dt = dal.GetCanceledAmount(co_id);
            DataRow dr = dt.Rows[0];
            string res = dr["hx_amount"].ToString() + "|" + dr["nat_hx_amount"].ToString();
            return res;
        }
        catch (Exception err)
        {
            return err.Message;
        }*/
        return "";
    }
    
    /// <summary>
    /// 自动分配表体核销金额
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string AutoFenPei(int co_id)
    {
        /*
        try
        {
            CancelOrderDAL co_dal = new CancelOrderDAL();
            CancelOrder sfk = co_dal.Get(co_id);
            decimal amount = Convert.ToDecimal(sfk.amount);
            APCancelDAL dal = new APCancelDAL();
            foreach (DataRow dr in co_dal.GetDetailsUnCancel(co_id).Rows)
            {
                APCancel m = dal.Get(Convert.ToInt32(dr["acl_id"]));
                int acl_id = Convert.ToInt32(dr["acl_id"]);
                decimal wait_hx = Convert.ToDecimal(dr["wait_hx_amount"]);
                //蓝票
                if (sfk.amount > 0)
                {
                    if (amount > 0)
                    {
                        if (amount > wait_hx)
                        {
                            m.hx_amount = wait_hx;
                        }
                        else
                        {
                            m.hx_amount = amount;
                        }
                        m.nat_hx_amount = Decimal.Round((decimal)m.hx_amount * (decimal)m.d_exchange_rate, 2);
                        dal.Update(m);
                        amount = amount - (decimal)m.hx_amount;

                    }
                }
                else//红票退货
                {
                    if (amount < 0)
                    {
                        if (amount < wait_hx)
                        {
                            m.hx_amount = wait_hx;
                        }
                        else
                        {
                            m.hx_amount = amount;
                        }
                        m.nat_hx_amount = Decimal.Round((decimal)m.hx_amount * (decimal)m.d_exchange_rate, 2);
                        dal.Update(m);
                        amount = amount - (decimal)m.hx_amount;
                    }
                }
            }
            return "success";
        }
        catch (Exception err)
        {
            return err.Message;
        }
         */
        return "";
    }
}