﻿<%@ WebService Language="C#" Class="ARAP_Cancel1_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Data;
using System.Data.SqlClient;
using SysCore;

//using SysCore.Model;
//using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class ARAP_Cancel1_Service : System.Web.Services.WebService
{
    
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        APCancelDAL dal = new APCancelDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                if (!id.Equals(""))
                {
                    
                    dal.Delete(Convert.ToInt32(id));
                }
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }


    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public APCancel Get(string acl_id)
    {
        APCancelDAL dal = new APCancelDAL();
        return dal.Get(Convert.ToInt32(acl_id));
    }

    /// <summary>
    /// 保存核销金额
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(int acl_id, string hx_amount, string nat_hx_amount)
    {
        try{
            APCancelDAL dal = new APCancelDAL();
            APCancel m = dal.Get(acl_id);
            m.hx_amount = XTools.ObjectNullToDecimal(hx_amount);
            m.nat_hx_amount = XTools.ObjectNullToDecimal(nat_hx_amount);
            dal.Update(m);
           
            return "success";
        }catch(Exception err){
            return err.Message;   
        }
    }

}