﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;
public partial class ARAP_CancelOrder_Cancel1_Grid : System.Web.UI.Page
{
    public string id;
    public string action;
    public Hashtable xview = new Hashtable();
    AWGridFun aw = new AWGridFun();
    protected void Page_Load(object sender, EventArgs e)
    {
        new LoginState().CheckLogin();
        id = Request["id"].ToString();
        action = Request["action"].ToString();
        if(!Page.IsPostBack)
        {
            CreateGrid();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        string pager_info = "预收款";
        if (Request["id"] != null)
        {
            CancelOrder m = new CancelOrderDAL().Get(Convert.ToInt32(id));
            if (m.cl_type == 4)
            {
                pager_info = "预付款";
            }
        }
        xview.Add("pager_info", pager_info);
        
        //设置标题与样式
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        string sql_select_field = "";//SQL所需选择列
        string module = "ARAP_Cancel1_Input";//模块
        string fields_index = "";//列索引
        mfd.CreateTitlesAndStyles(module, ref aw, ref sql_select_field, ref fields_index);
        xview.Add("fields_index", fields_index);
        //把样式传递到页面
        xview.Add("aw_column_style",aw.GetStyles());
        int page = 1;//当前页
        if (Request.QueryString["page"] != null)
            page = Convert.ToInt32(Request.QueryString["page"]);
        int page_size = aw.GetDefaultPageSize();//每页显示条数
        if (Request.QueryString["page_size"] != null)
            page_size = Convert.ToInt32(Request.QueryString["page_size"]);
        APCancelDAL dal = new APCancelDAL();
        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by acl_id";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        sql_end += " and isnull(sfk_id,0)<>0 and co_id=" + id;
        /*
        if (!Request["i_code"].Equals(""))
        {
            //sql_end += " and wh_code like '%" + Request["wh_code"] + "%'";
        }
        if (!Request["i_name"].Equals(""))
        {
            //sql_end += " and wh_name like '%" + Request["wh_name"] + "%'";
        }*/
        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = dal.GetList_For_SFKuan(ht, sql_select_field);
        //把sql放入session中供打印用
        string sql_print_detail_session_id = "sql_print_detail_Cancel1";
        Session[sql_print_detail_session_id] = dal.sql_print;
        xview.Add("sql_print_detail_session_id", sql_print_detail_session_id);
        //得到总记录数为分页提供依据
        int rows_count = dal.GetList_TotalNumbers_For_SFKuan(ht);
        //开启合计行功能
        aw.to_sum_row = true;
        //从模板读出哪些列需要合计
        aw.last_row_info = mfd.last_row_info;
        string aw_grid_info = aw.MakeGridObject(dt, rows_count, page_size, page);
        //把控件参数与数据源传递到页面
        xview.Add("aw_grid_info", aw_grid_info);
    }
}
