/*
 @description: 广告交易-设置公众号
 @date: 2015-12-24
 @author: Nero(Nero@Nero-zou.com)
 */
var LoginWXB=window.top.LoginWXB;
var Util=window.top.Util;
var AppViewUtil=window.top.AppViewUtil;
var Accounts=window.top.Accounts;
var WechatFetch=window.top.WechatFetch;
var openUrlToBrowser=window.top.openUrlToBrowser
var I_WXB_COM_URL='http://i.wxb.com/'

function fixAvatar(target){
    target.src='./img/default-avatar.png';
}

var utils = {
    showLoading: function (target) {
        var oldHtml = target.html();
        target.addClass('js-loading disabled');
        var fa = target.find('i.fa');
        if (fa.length === 0) {
            try {
                target.prepend('<i class="fa fa-spinner fa-loading"></i> ');
            } catch (e) {
                console.log(e);
            }
        } else {
            fa.attr('class', 'fa fa-spinner fa-loading');
        }
        return {
            revert: function () {
                target.html(oldHtml);
                target.removeClass('js-loading disabled');
            }
        };
    }
};

Vue.filter('raw_to_avatar', function (raw_id) {
    return "http://open.weixin.qq.com/qr/code/?username="+raw_id;
});

Vue.filter('getPosition', function (position,total_idx) {
    if(total_idx===1){
        return '单图文'
    }
    var map={
        '1':'多图文第一条',
        '2':'多图文第二条',
        '3':'多图文第三条',
        '4':'多图文第四条',
        '5':'多图文第五条',
        '6':'多图文第六条',
        '7':'多图文第七条',
        '8':'多图文第八条'
    };
    if(map[position]){
        return map[position];
    }
    return position;
});

Vue.filter('income_coin_estimate', function (income_coin, status) {
    if (status+"" === "20" || income_coin+"" === "0") {
        return '--';
    } else {
        return income_coin;
    }
});

Vue.filter('income_coin_actual', function (income_coin, status) {
    if (status+"" === "20" && income_coin > 0 ) {
        return income_coin;
    } else {
        return '--';
    }
});

Vue.filter('status_name_class', function (status) {
    status += "";
    if (status === "20") {
        return "green";
    } else if (status === "15" ||status === "10" ||status === "0" ) {
        return "yellow";
    }else{
        return "gray"
    }
});

Vue.filter('timeToDate', function (time) {
    return new Date(time*1000).toLocaleDateString();
});


var vm = new Vue({
    el: '#iMediaOrder',
    data: {
        orderList: [],
        listParam: {
            page: 1,
            pageSize: 10,
            status: "all",
            position: "all",
            s_date: "",
            e_date: "",
            q: ""
        },
        listPager: {
            firstRecord: 0,
            lastRecord: 0,
            numPages: 0,
            numRecords: 0,
            page: 0,
            perPage: "10"
        },//分页数据
        status:{
            loading:false,
            showAddLink:false,
            showApplySettle:false
        },
        addLink:{
            order_id:"",
            raw_id:"",
            nick_name:"",
            alias:"",
            data:[],
            pager:{},
            checkedId:'',
            loading:false,
            param: {
                page: 1,
                pageSize: 10
            }
        },
        applySettle:{
            processStep:1,
            errorInfo:''
        }

    },
    computed:{

    },
    methods: {
        init: function () {
            $('.js-s-date,.js-e-date').datepicker({
                autoclose:true
            });
            $('.popovers').popover();
            this.getiMediaOrderList();
        },
        search:function(){
            this.listParam.page=1;
            this.getiMediaOrderList();
        },
        getiMediaOrderList:function(){
            if(this.status.loading){
                return
            }
            var _this=this;
            var param={};
            for (var key in this.listParam) {
                var value= (this.listParam[key]+'').trim();
                if(value && value!=='' && value!=='all'){
                    param[key]=value
                }
            }
            _this.status.loading=true;
            LoginWXB.getiMediaOrderList(param).then(function (response) {
                _this.status.loading=false;
                if(response.errcode===0){
                    _this.orderList=response.data;
                    for (var i = 0; i < _this.orderList.length; i++) {
                        var obj = _this.orderList[i];
                        if(obj.real_push_time && (Date.now()-obj.real_push_time*1000)<1000*60*60*48){
                            obj.disable_settle=true;
                        }
                    }
                    _this.listPager=response.pager;
                    setTimeout(function () {
                        $('.js-popovers').popover();
                    },100);
                }else{
                    toastr.error(response.message,"加载订单列表失败");
                }
            }).catch(function (e) {
                _this.status.loading=false;
                toastr.error(e,"加载订单列表失败");
            })


        },
        pagePrev:function(){
            this.listParam.page--;
            this.getiMediaOrderList();
        },
        pageNext:function(){
            this.listParam.page++;
            this.getiMediaOrderList();
        },
        checkPageGo:function(){
            this.listParam.page=Math.max(this.listParam.page,1);
            this.listParam.page=Math.min(this.listParam.page,this.listParam.numPages);
        },
        pageGo:function(){
            this.getiMediaOrderList();
        },
        orderDonePush:function(order){
            this.status.showAddLink=true;
            this.addLink.param.page=1;
            this.addLink.data=[];
            this.addLink.pager={};
            this.addLink.raw_id=order.raw_id;
            this.addLink.nick_name=order.weixin_name;
            this.addLink.alias=order.weixin_id;
            this.addLink.order_id=order.id;
            this.getAccountLatestSendMsg();
        },
        orderApplySettle:function(order){
            var _this=this;
            var order_id=order.id;
            var raw_id=order.raw_id;
            var wx_article_url=order.wx_article_url;
            if(!wx_article_url){
                toastr.error("","未发现推送的文章地址");
                return;
            }
            var pushTime=order.real_push_time*1000;
            var pushDate=Util.dateParse(pushTime).seeRet;
            if((Date.now()-pushTime)<1000*60*60*48){
                toastr.error("","请在推送成功的48小时之后再结算");
                return
            }


            var msg_id = wx_article_url.replace(/.+&mid=(\d+).?&idx=(\d+).+/, '$1_$2');
            var accountInfo = Accounts.getAccountInfo(raw_id);
            if (accountInfo.wxid !== raw_id) {
                Win.alert({
                    content: '您本地还未添加这个公众号，是否去添加？',
                    yesFunc:function(){
                        AppViewUtil.addMpAccount();
                    }
                })
                this.status.showApplySettle=false;
                return;
            }

            this.applySettle.processStep=1;
            this.status.showApplySettle=true;

            WechatFetch.getAccountSendMsgStat(accountInfo,pushDate,pushDate).then(function (stat_data) {
                _this.applySettle.processStep=2;

                var saveData=[];
                for (var i = 0; i < stat_data.length; i++) {
                    var obj = stat_data[i];
                    if(obj.msgid===msg_id){
                        saveData.push(obj);
                    }
                }

                if(saveData.length===0){
                    _this.applySettle.errorInfo='无法获取推送的文章信息';
                    _this.applySettle.processStep=-2;
                    return;
                }
                LoginWXB.report_iMediaOrderMsgStat(order_id,JSON.stringify(saveData)).then(function () {
                    _this.applySettle.processStep=3;
                }).catch(function (e) {
                    _this.applySettle.errorInfo=e;
                    _this.applySettle.processStep=-2;
                });
            }).catch(function (e) {
                console.log(e);
                _this.applySettle.processStep=-1;
                _this.applySettle.errorInfo=e;
            });
        },
        showDetail:function(id){
            openUrlToBrowser(I_WXB_COM_URL+'order/detail/'+id+'?type=1');
        },
        showMediaList:function(){
            openUrlToBrowser(I_WXB_COM_URL+'media/list');
        },
        showMyBill:function(){
            openUrlToBrowser(I_WXB_COM_URL+'coin/log');
        },
        showExpandList:function(){
            openUrlToBrowser(I_WXB_COM_URL+'expand/list');
        },
        goToMediaList:function(){
            openUrlToBrowser(I_WXB_COM_URL+'media/list');
        },
        getAccountLatestSendMsg:function(){
            var page=(this.addLink.param.page-1)*this.addLink.param.pageSize;
            var _this=this;
            var raw_id=_this.addLink.raw_id;
            var accountInfo=Accounts.getAccountInfo(raw_id);
            if(accountInfo.wxid!==raw_id){
                Win.alert({
                    content:'您本地还未添加这个公众号，是否去添加？',
                    yesFunc:function(){
                        AppViewUtil.addMpAccount();
                    }
                })
                this.status.showAddLink=false;
                return;
            }
            this.addLink.loading=true;
            WechatFetch.getLatestMsgSend(accountInfo,page).then(function (response) {
                var _param=_this.addLink.param;
                var data=[];
                var pager = {
                    numPages: Math.ceil(_param.pageSize/_param.page),
                    numRecords: response.total_count,
                    page: _param.page,
                    perPage: _param.pageSize
                };

                for (var i = 0; i < response.msg_item.length; i++) {
                    var msg_item_i = response.msg_item[i];
                    for (var j = 0,len=msg_item_i.multi_item.length; j < len; j++) {
                        var multi_item_j = msg_item_i.multi_item[j];
                        multi_item_j.date_time=msg_item_i.date_time;
                        multi_item_j.total_idx=len;
                        multi_item_j.id=multi_item_j.msg_id+ (multi_item_j.seq+1);
                        multi_item_j.content_url=multi_item_j.content_url.replace(/&amp;/gim,'&');
                        data.push(multi_item_j);
                    }
                }

                _this.addLink.data=data;
                _this.addLink.pager=pager;
                _this.addLink.loading=false;
            }).catch(function (e) {
                _this.addLink.loading=false;
                toastr.error(e,"加载已发送图文消息失败");
            });
        },
        addLinkPrev:function(){
            this.addLink.param.page--;
            this.getAccountLatestSendMsg()
        },
        addLinkNext:function(){
            this.addLink.param.page++;
            this.getAccountLatestSendMsg()
        },
        addLinkSure:function(){
            var _this=this;
            var checkedId=this.addLink.checkedId;
            var checkedMsg={};
            var order_id=this.addLink.order_id;
            for (var i = 0; i < this.addLink.data.length; i++) {
                var msg_i = this.addLink.data[i];
                if(msg_i.id===checkedId){
                    checkedMsg=msg_i;
                }
            }
            if(checkedMsg.title && checkedMsg.content_url){
                var win=Win.confirm({
                    content:'您是否要自动上传带粉文案【 <a target="_blank" href="'+checkedMsg.content_url+'">'+checkedMsg.title+'</a>】的文章链接？',
                    yesFunc:function(){
                        var btn=win.find('._model-sure-btn');
                        var loading=utils.showLoading(btn);
                        LoginWXB.setiMediaOrderUrl(order_id.replace(/^P/,''),checkedMsg.content_url).then(function () {
                            loading.revert();
                            win.modal('hide');
                            _this.status.showAddLink=false;
                            toastr.success("","添加文章链接成功");
                            _this.getiMediaOrderList();
                        }).catch(function (e) {
                            toastr.error(e,"添加文章链接失败");
                            loading.revert();
                        });
                        return false;
                    }
                });
            }else{
                toastr.error("","请选择文章");
            }
        },

        applySettleSure:function(){
            this.status.showApplySettle=false;
            if(this.applySettle.processStep===3){
                this.getiMediaOrderList()
            }
        }

    }

});