$(function() {
	var ue = UE.getEditor( 'editor' );
	
	$( "#sswzlb" ).button({
		text: false,
		icons: {
			primary: "ui-icon-search"
		}
    })
    .click(function() {
		$( "#dialog-sswz" ).dialog( "open" );
    });
	$( "#gettitle" ).click(function() {
		$( "#gjc" ).val( $( "#articleTitle" ).val().replace(/[^\u4e00-\u9fa5\uf900-\ufa2d\w]/g, '') + ' ' );
    });
	$( "#ss" ).click(function() {
		$.ajax({
			type: "POST",
			url: $("#baseurl").attr('href') + 'internals/list/index.m.01.php',
			data: {
				gjc: $( "#gjc" ).val(),
				xsts: $( "#xsts" ).val(),
				clitem: $( "#clitem" ).val()
			},
			success: function( msg ) {
				$( "#alb" ).html( msg );
			}
		});
    });
	$( "#xsts" ).spinner({
		spin: function( event, ui ) {
			if ( ui.value > 999 ) {
				$( this ).spinner( "value", 0 );
				$( this ).change();
				return false;
			} else if ( ui.value < 0 ) {
				$( this ).spinner( "value", 999 );
				$( this ).change();
				return false;
			}
			$( this ).change();
		}
    });
	$( "#dialog-sswz" ).dialog({
		dialogClass: "sswzClass",
		autoOpen: false,
		width: 550,
		modal: true,
		show: {
			effect: "blind",
			duration: 200
		},
		hide: {
			effect: "blind",
			duration: 10
		},
		buttons: {
			"插入": function() {
				ue.execCommand('insertHtml', $( "#alb" ).html());
				$( this ).dialog( "close" );
			},
			"取消": function() {
				$( this ).dialog( "close" );
			}
		},
		close: function() {
			$( "#alb" ).html( '' );
		}
    });

	var autoset = getCookie( 'niuxcms_autotypeset' );
	if ( autoset ) {
		var lines = autoset.split( "|" );
		var atsv = {
              mergeEmptyline : lines[0]=='on'?true:false,
              removeEmptyline : lines[1]=='on'?true:false,
              removeClass : lines[2]=='on'?true:false,
              indent : lines[3]=='on'?true:false,
              textAlign : lines[4]=='on'?lines[5]:false,
              imageBlockLine : lines[6]=='on'?lines[7]:false,
              clearFontSize : lines[8]=='on'?true:false,
              clearFontFamily : lines[9]=='on'?true:false,
              removeEmptyNode : lines[10]=='on'?true:false,
              pasteFilter : lines[11]=='on'?true:false,
			  removeTagNames : {标签名字:1},
              indentValue : '2em'
          }
		ue.setOpt({ autotypeset:atsv });
	}
	$( document ).on("click", "td[class='edui-default'] button[class='edui-default']", function() {
		var co = $( "input[name='mergeEmptyline']:checked" ).val()+'|'+$( "input[name='removeEmptyline']:checked" ).val()+'|'+
		$( "input[name='removeClass']:checked" ).val()+'|'+$( "input[name='indent']:checked" ).val()+'|'+
		$( "input[name='textAlign']:checked" ).val()+'|'+$( "input[name='textAlignValue0']:checked" ).val()+'|'+
		$( "input[name='imageBlockLine']:checked" ).val()+'|'+$( "input[name='imageBlockLineValue0']:checked" ).val()+'|'+
		$( "input[name='clearFontSize']:checked" ).val()+'|'+$( "input[name='clearFontFamily']:checked" ).val()+'|'+
		$( "input[name='removeEmptyNode']:checked" ).val()+'|'+$( "input[name='pasteFilter']:checked" ).val();
		if ( co ){
			setCookie( 'niuxcms_autotypeset' , co , 120 , '/');
		}
	});

	if ( getCookie( 'niuxcms_ifremoteimage' ) != 'no' ) {
		$( "#RemoteImage" ).attr( "checked" , true );
	} else {
		ue.setOpt({ catchRemoteImageEnable:false });
	}
	$( "#RemoteImage" ).button({
		text: false,
		icons: {
			primary: "ui-icon-transferthick-e-w"
		}
    }).click(function() {
		if ( this.checked ) {
			setCookie( 'niuxcms_ifremoteimage' , 'yes' , 120 , '/');
		} else {
			setCookie( 'niuxcms_ifremoteimage' , 'no' , 120 , '/');
		}
		if(confirm( '参数已经设置，但需要刷新当前页才能生效，点确定立即刷新当前页，点取消暂不刷新，保存数据后再自行刷新！' )){
			window.location.reload();
		}
    });
	
	var wslider = $( "#wslider" ).slider({
		range: "min",
		value: $( "#slt_w" ).val(),
		min: 0,
		max: 999,
		step: 10,
		slide: function( event, ui ) {
			$( "#slt_w" ).val( ui.value );
		}
    });
	var hslider = $( "#hslider" ).slider({
		range: "min",
		value: $( "#slt_h" ).val(),
		min: 0,
		max: 999,
		step: 10,
		slide: function( event, ui ) {
			$( "#slt_h" ).val( ui.value );
		}
    });
	$( "#slt_w" ).change(function() {
		wslider.slider( "value", $( this ).val() );
    });
	$( "#slt_h" ).change(function() {
		hslider.slider( "value", $( this ).val() );
    });
	
	$( "#dialog-slt" ).dialog({
		dialogClass: "sltClass",
		autoOpen: false,
		width: 350,
		modal: true,
		position: {
			my: "left top",
			at: "left bottom",
			of: $( "#slt" )
		},
		show: {
			effect: "blind",
			duration: 200
		},
		hide: {
			effect: "drop",
			duration: 200
		},
		buttons: {
			"设置": function() {
				var slt_w = $( "#slt_w" ),
				slt_h = $( "#slt_h" ),
				slttips = $( "#slttips" ),
				allFields = $( [] ).add( slt_w ).add( slt_h );
				var bValid = true;
				allFields.removeClass( "ui-state-error" );
				bValid = bValid && checkLength( slt_w, "缩略图-宽：", 1, 3, slttips );
				bValid = bValid && checkLength( slt_h, "缩略图-高：", 1, 3, slttips );
				bValid = bValid && checkRegexp( slt_w, /^[0-9]([0-9])*$/i, '缩略图-宽：必须是数字啊！冰冰棒！', slttips );
				bValid = bValid && checkRegexp( slt_h, /^[0-9]([0-9])*$/i, '缩略图-高：必须是数字啊！冰冰棒！', slttips );
				if ( bValid ) {
					setCookie( 'niuxcms_suoluetu_w' , slt_w.val() , 120 , '/');
					setCookie( 'niuxcms_suoluetu_h' , slt_h.val() , 120 , '/');
					$( "#slt" ).find("span").eq(1).text( '略:' + slt_w.val() + '×' + slt_h.val() )
					$( this ).dialog( "close" );
				}
			},
			"取消": function() {
				$( this ).dialog( "close" );
			}
		},
		close: function() {
			$( "#slt_w , #slt_h" ).removeClass( "ui-state-error" );
		}
    });
    $( "#slt" ).text( '略:' + $( "#slt_w" ).val() + '×' + $( "#slt_h" ).val() ).button({
		icons: {
			primary: "ui-icon-newwin"
		}
    })
    .click(function() {
		$( "#dialog-slt" ).dialog( "open" );
    });
    $( "#slt_w , #slt_h" ).spinner({
		spin: function( event, ui ) {
			if ( ui.value > 999 ) {
				$( this ).spinner( "value", 0 );
				$( this ).change();
				return false;
			} else if ( ui.value < 0 ) {
				$( this ).spinner( "value", 999 );
				$( this ).change();
				return false;
			}
			$( this ).change();
		}
    });
	
	$( "#waterPos" ).text( $( "#setWaterPos" ).find("li").eq($( "#waterPos" ).val()).find("a").text() ).button({
		icons: {
			primary: "ui-icon-triangle-1-s"
		}
    }).click(function() {
		var menu = $( "#setWaterPos" ).show().position({
            my: "left top",
            at: "left bottom",
            of: this
        });
        $( document ).one( "click", function() {
            menu.hide({
				effect: "scale",
				duration: 500
			});
        });
		return false;
	});
	$( "#setWaterPos" ).find("li").eq($( "#waterPos" ).val()).addClass( "ui-state-disabled" );
	$( ".waterpos" ).click(function() {
		$( "#waterPos" ).find("span").eq(1).text( $(this).text() );
		setCookie( 'niuxcms_waterpos' , $(this).next("input").val() , 120 , '/');
		$(this).parent('li').siblings().removeClass( "ui-state-disabled" );
		$(this).parent('li').addClass( "ui-state-disabled" );
	});
	
	$( "#mblist" ).button({
		icons: {
			primary: "ui-icon-triangle-1-s"
		}
    }).click(function() {
		var menu = $( "#setWzmb" ).show().position({
            my: "left top",
            at: "left bottom",
            of: this
		});
		$( document ).one( "click", function() {
			menu.hide({
				effect: "explode",
				duration: 500
			});
		});
		return false;
	});
	$( ".mbselect" ).click(function() {
		$( "#mblist" ).val($(this).next("input").val());
		$( "#mblist" ).find("span").eq(1).text( $(this).text() );
		$(this).parent('li').siblings().removeClass( "ui-state-disabled" );
		$(this).parent('li').addClass( "ui-state-disabled" );
	});
	
	var t , ats = $( '#autosavetemp' ) , ifas = getCookie( 'niuxcms_autosavetemp' );
	function timedSave(){
		var articleTitle = $( "#articleTitle" ).val(), articlehasContents = ue.hasContents(), articleContent = ue.getContent();
		if ( articlehasContents ){
			$.post( location.href, { menu: "savetemp", title: escape(articleTitle), content: escape(articleContent) } );
		}
		t=setTimeout( function(){timedSave()} , 120000 );
	}
	if ( ifas == '1' ) { ats.attr( "checked" , true ); t = setTimeout( function(){timedSave()} , 120000 ) }
	ats.button({
		text: false,
		icons: {
			primary: "ui-icon-disk"
		}
    }).click(function() {
		if ( this.checked ) {
			setCookie( 'niuxcms_autosavetemp' , 1 , 120 , '/');
			timedSave();
		} else {
			setCookie( 'niuxcms_autosavetemp' , 0 , 120 , '/');
			clearTimeout( t );
		}
    });
	
	$( '#readtemp' ).button({
		text: false,
		icons: {
			primary: "ui-icon-folder-open"
		}
    }).click(function() {
		if(confirm( '此操作将覆盖当前文章内容，你确定要读取草稿吗？' )){
			$.post(
				location.href,
				{ menu: "readtemp" },
				function( data ){
					var dd = eval( '(' + data + ')' );
					$( "#articleTitle" ).val( unescape(dd.title) );
					ue.setContent( unescape(dd.content) );
			});
		}
	});
	
	$( '#autofull' ).click( function() {
		var articleTitle = $( "#articleTitle" ).val(), articleContentTxt = ue.getContentTxt(), articleContent = ue.getContent();
		if ( articleTitle.length < 1 || !ue.hasContents() ){
			if( !confirm("文章标题为空或文章内容没有可显示的内容，无法正常完成自动填写工作！是否继续自动填写？") ){
				return false;
			}
		}
		$( "#keywords" ).val( articleTitle.replace(/[^\u4e00-\u9fa5\uf900-\ufa2d\w]/g, '') + ' ' );
		$( "#description" ).val( articleContentTxt.replace(/\s+/g, '').substring(0,140) );
		var domain = articleContent.match(/http:\/\/(((?!img.baidu.com|www.macromedia.com).)+?)\//im);
		if ( domain != null ) {
			$( "#articlesource" ).val( "www." + domain[1].match(/[^.]+\.[^.]+$/) );
		} else if ( getCookie( 'niuxcms_articlesource' ).length > 4 ) {
			$( "#articlesource" ).val( getCookie( 'niuxcms_articlesource' ) );
		} else {
			$( "#articlesource" ).val( location.hostname );
		}
	});
	
	var xxximg = 0;
	$( '#getsimg' ).button({
		text: false,
		icons: {
			primary: "ui-icon-gear"
		}
    }).tooltip({
		tooltipClass: "getsimg",
		show: {
			delay: 200,
			duration: 1
		},
		track: true,
		content: function() {
			return $( "#getsimg" ).text();
		},
		position: {
			my: "left+15 bottom-15",
			at: "left bottom"
		}
	}).click(function() {
		var x, i = 0 , j = 0 , f = '' , articleContent = ue.getContent(),
		allimgs = articleContent.match(/<img(.*?)src(.*?)=(.*?)['"]http:\/\/(.+?)['"]/igm);
		for (x in allimgs){
			if ( allimgs[x].indexOf( location.hostname ) != -1 ){
				allimgs[x] = allimgs[x].replace(/<img(.*?)src(.*?)=(.*?)['"]([^'"]*)['"]/ig, "$4");
				allimgs[x] = allimgs[x].replace(/([^\.]+?)\.([^\.]{3,4}$)/ig, "$1_s.$2");
				if ( !f ){
					f = allimgs[x];
				}
				if ( ( i == 1 && parseInt(x) > xxximg ) || $( "#titleslt" ).val() == '' ){
					$( "#titleslt" ).val( allimgs[x] );
					xxximg = parseInt(x);
					j = 1;
					break;
				}
				if ( allimgs[x] == $( "#titleslt" ).val() ){
					i = 1;
				}
			}
		}
		if ( !j && f ){
			$( "#titleslt" ).val( f );
			xxximg = 0;
			j = 1;
		}
		if ( j && f ){
			$( '#getsimg' ).tooltip({
				tooltipClass: "getsimg",
				show: null,
				track: true,
				content: function() {
					return "<img src='" + $( "#titleslt" ).val() + "' />";
				},
				position: {
					my: "left+15 bottom-15",
					at: "left bottom"
				}
			})
		}
    });
	
	$( '#getText' ).button({
		text: false,
		icons: {
			primary: "ui-icon-gear"
		}
    }).click(function() {
		var range = ue.selection.getRange();
        range.select();
        var txt = ue.selection.getText();
		$( "#keywords" ).val( $( "#keywords" ).val() + txt + ' ' );
    });
	
	$( '#getartiText' ).button({
		text: false,
		icons: {
			primary: "ui-icon-gear"
		}
    }).click(function() {
		if ($( "#description" ).val().length < 130 ){
			$( "#description" ).val( $( "#description" ).val() + $( "#articleTitle" ).val() );
		}
    });
	
	$( "#articlesource" ).val( location.hostname );
	
	$( '#xzsource' ).button({
		text: false,
		icons: {
			primary: "ui-icon-wrench"
		}
    }).click(function() {
		$( "#articlesource" ).val( location.hostname );
    });
	
	if ( getCookie( 'niuxcms_ifshenhe' ) == '1' ) { $( "#shenhe" ).attr( "checked" , true ); }
	$( "#shenhe" ).button({
		text: false,
		icons: {
			primary: "ui-icon-pin-s"
		}
    }).click(function() {
		if ( this.checked ) {
			setCookie( 'niuxcms_ifshenhe' , 1 , 120 , '/');
		} else {
			setCookie( 'niuxcms_ifshenhe' , 0 , 120 , '/');
		}
    });
	
	$( "input[name='bj']" ).click(function() {
		var val = $( this ).val();
		if ( this.checked ) {
			$( "#articleTitle" ).val( $( "#articleTitle" ).val() + val );
		} else {
			$( "#articleTitle" ).val( $( "#articleTitle" ).val().replace(val, '') );
		}
    });
	
	$( "input[name='submit']" ).click( function() {
		var action = $( this ),
		articleTitle = $( "#articleTitle" ).val(),
		articleContent = ue.getContent(),
		articlefile = $( '#articlefile' ).val(),
		keywords = $( "#keywords" ).val(),
		description = $( "#description" ).val(),
		articlesource = $( "#articlesource" ).val(),
		writer = $( "#writer" ).val(),
		mb = $( "#mblist" ).val(),
		titleslt = $( "#titleslt" ).val(),
		shenhe = $( "#shenhe:checked" ).val();
		if ( articleTitle.length < 1 ){
			$( "#articleTitle" ).focus();
			alert('文章标题不能为空啊！');
			return false;
		}
		if ( !ue.hasContents() ){
			if( !confirm( '文章内容没有可显示的内容，是否继续' + action.val() + '？' ) ){
				return false;
			}
		}
		if ( articlefile.length > 0 && articlefile.match(/[^\w\/]/ig) ){
			alert( '自定义文件名不能包含特殊字符：' + articlefile.match(/[^\w\/]/ig) );
			return false;
		}
		if ( titleslt.length > 0 && titleslt.match(/^[^(http:\/\/)]|[^\w:-_\/\.]/i) ){
			alert( '标题缩略图格式不对噢！亲：' + titleslt.match(/^[^(http:\/\/)]|[^\w:-_\/\.]/i) );
			return false;
		}
		setCookie( 'niuxcms_articlesource' , articlesource , 120 , '/');
		if ( action.val() == '带模板预览' ) myWindow=window.open('');
		action.addClass( "ui-state-error ").attr( "disabled" , true );
		var titlestyle='';
		$("input[name='titlestyle']:checked").each(function(){if(this.value.length<3){titlestyle=titlestyle+this.value+' ';}});
		$.ajax({
			type: "POST",
			url: location.href,
			data: {
				menu: 'addarticle',
				title: articleTitle,
				content: articleContent,
				titlestyle: titlestyle,
				keywords: keywords,
				description: description,
				articlesource: articlesource,
				writer: writer,
				mb: mb,
				articlefile: articlefile,
				titleslt: titleslt,
				lid: lid,
				shenhe: shenhe,
				action: action.val()
			},
			success: function( msg ) {
				if ( action.val() == '发布文章' ) {
					if ( msg == '1' ) {
						if(confirm( '恭喜你，添加文章成功！是否继续发布文章？' )){
							location = location.href;
						} else {
							location = $("#baseurl").attr('href') + 'internals/list/?lid=' + lid;
						}
					} else {
						if ( msg.indexOf('{') == 0 && msg.indexOf('}') == msg.length-1 ){
							var dd = eval( '(' + msg + ')' );
							$.get($("#baseurl").attr('href') + 'internals/shenhe/', { lid: dd.lid, wzID: dd.wzID },
							function( data ){
								if ( data == '1' ){
									if(confirm( '恭喜你，添加文章成功！审核文章成功！是否继续发布文章？' )){
										location = location.href;
									} else {
										location = $("#baseurl").attr('href') + 'internals/list/?lid=' + lid;
									}
								} else if ( data.length > 200 ) {
									setCookie( 'niuxcms_ifshenhe' , 0 , 120 , '/');
									if(confirm( '恭喜你，添加文章成功！但是“您没有审核权限！”，审核失败！是否继续发布文章？' )){
										location = location.href;
									} else {
										location = $("#baseurl").attr('href') + 'internals/list/?lid=' + lid;
									}
								} else {
									if(confirm( '恭喜你，添加文章成功！但是“' + data + '”，审核失败！是否继续发布文章？' )){
										location = location.href;
									} else {
										location = $("#baseurl").attr('href') + 'internals/list/?lid=' + lid;
									}
								}
							});
						}else{
							alert( msg );
						}
					}
				} else {
					myWindow.document.write( msg );
				}
				action.removeClass( "ui-state-error" ).attr( "disabled" , false );
			}
		});
	});
});