local assets=
{
	Asset("ANIM", "anim/bb_axe.zip"),
    Asset("ANIM", "anim/swap_bb_axe.zip"),
  
 Asset("ATLAS", "images/inventoryimages/bb.xml"), 
    Asset("IMAGE", "images/inventoryimages/bb.tex"),
}



local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_bb_axe", "swap_lucy_axe")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	
     MakeInventoryPhysics(inst)
 
    inst:AddComponent("inspectable")
  inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(250)
    inst.components.finiteuses:SetUses(250)
inst.components.finiteuses:SetOnFinished(inst.Remove)
    inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 1)
   
    
    anim:SetBank("Lucy_axe")
    anim:SetBuild("bb_axe")
    anim:PlayAnimation("idle")
    MakeInventoryPhysics(inst)
    MakeInventoryFloatable(inst, "idle_water", "idle")
    
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.AXE_DAMAGE*.5)

    -----
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 2)

    -------
    
    

  
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/bb.xml"
   
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip)

    
    
    
 
    
    
    
    return inst
end


return Prefab( "common/inventory/bb", fn, assets)
	   

