#ifndef __QT_WINDOW_BASE__
#define __QT_WINDOW_BASE__
#include "WindowsHeader.h"
#include <QtCore/QtCore>
#include <QtGui/QtGui>
#include <QtUiTools/QtUiTools>
#include "LogBase.h"
#include "JobType.h"


#define MSG_WINDOW_STYLE                ULONG

#define MSG_WINDOW_STYLE_NOTIFY         1
#define MSG_WINDOW_STYLE_CONFIRM        2


class CQtWindowBaseEventFilter;

class CQtWindowBase : public QWidget, public CLogBase
{
    Q_OBJECT

public:
	CQtWindowBase(QWidget *parent = 0);
	~CQtWindowBase();

private:
protected:
	BOOL              m_bInited;
	QWidget           *m_pMainWidget;
	CQtWindowBaseEventFilter *m_pEventFilter;
	BOOL              m_bClosing;

	CStringA m_straUiFilePath;

	JOB_TYPE m_ulCurrentJob;
	HANDLE m_hEvent_Job_ThreadExited;

	// ؼ

	void closeEvent(QCloseEvent *event);
	
	BOOL Job(JOB_TYPE ulJob);
	static UINT Job_TR(LPVOID pParam);
	virtual BOOL JobDispatcher() = 0;

	void SetMsg(char *pszMsg, char *pszLogFormat = NULL, ...);
	void SetClosing();
	virtual ULONG ShowMsg(CStringA straMsg, MSG_WINDOW_STYLE ulStyle = MSG_WINDOW_STYLE_NOTIFY, CStringA straCaption = "", BOOL bAnimate = FALSE);

signals:
	void my_sg_MessageBox(QString qstrText);
	void my_sg_SetMsg(QString qstrText);
	void my_sg_SetEnabledAll(bool bEnabled);

private slots:
	virtual void my_on_MessageBox(QString qstrText);
	virtual void my_on_SetMsg(QString qstrMsg) = 0;
	virtual void my_on_SetEnabledAll(bool bEnabled) = 0;

public:
	BOOL Init_N_Show(CStringA straUiFilePath, BOOL bShow = TRUE);
	BOOL Free();
	void *GetMainWidget();

	void RedirectEventFromMainWidget(QEvent *e);
};


class CQtWindowBaseEventFilter : public QObject
{
	Q_OBJECT

public:
	CQtWindowBaseEventFilter(CQtWindowBase *pWindow, BOOL bRedirectAllEventToParent)
	{
		m_pWindow = pWindow;
		m_bRedirectAllEventToParent = bRedirectAllEventToParent;
	};

protected:
	CQtWindowBase *m_pWindow;
	BOOL m_bRedirectAllEventToParent;

	bool eventFilter(QObject *obj, QEvent *e)
	{
		BOOL bRedirect = FALSE;

		if (e->type() == QEvent::MouseMove
			|| e->type() == QEvent::MouseButtonPress
			|| e->type() == QEvent::MouseButtonDblClick   )
			bRedirect = TRUE;
		else if (e->type() == QEvent::Resize)
		{
			if (obj->parent() == (QObject*)m_pWindow)
			bRedirect = TRUE;
		}
		else if (e->type() == QEvent::Paint)
		{
			if (obj->parent() == (QObject*)m_pWindow)
			bRedirect = TRUE;
		}

		if (m_bRedirectAllEventToParent)
			bRedirect = TRUE;
		if (bRedirect)
			m_pWindow->RedirectEventFromMainWidget(e);

		return false;
		// standard event processing
		return QObject::eventFilter(obj, e);
	};

public:
};


#endif  // #ifndef __QT_WINDOW_BASE__