uniform vec3 lightPos;
uniform vec3 eyePos;

varying vec2 uv;
varying vec3 eyeDir;
varying vec3 lightDir;

void main(void) {
	gl_Position = ftransform();

	uv = gl_MultiTexCoord0.xy;

	vec4 objectPosition = gl_ModelViewMatrix * gl_Vertex;

	vec3 fvEyeDir  = eyePos - objectPosition.xyz;
	vec3 fvLightDir = lightPos - objectPosition.xyz;
	
	vec3 fvNormal = gl_NormalMatrix * gl_Normal;
	vec3 fvBinormal = gl_NormalMatrix * gl_MultiTexCoord1.xyz;
	vec3 fvTangent = gl_NormalMatrix * gl_MultiTexCoord2.xyz;
	
	mat3 TBN=mat3(fvTangent, fvBinormal, fvNormal);

	eyeDir=TBN*fvEyeDir;
	lightDir=TBN*fvLightDir;
}