uniform sampler2D diffuseMap;
uniform sampler2D bumpMap;
uniform sampler2D specularMap;
uniform sampler2D transparentMap;

uniform vec4 ambient;
uniform vec4 specular;
uniform vec4 diffuse;
uniform float specularPower;

varying vec2 uv;
varying vec3 eyeDir;
varying vec3 lightDir;

void main (void) {
    
	vec3  fvLightDirection = normalize( lightDir );
	vec3 fvNormal = normalize(texture2D(bumpMap, uv).rgb * 2.0 - 1.0);
	float fNDotL           = dot( fvNormal, fvLightDirection ); 

	vec3  fvReflection     = normalize( ( ( 2.0 * fvNormal ) * fNDotL ) - fvLightDirection ); 
	vec3  fvViewDirection  = normalize( eyeDir );
	float fRDotV           = max( 0.0, dot( fvReflection, fvViewDirection ) );

	vec4 baseColor = texture2D(diffuseMap, uv);
	float specularStrength = texture2D( specularMap, uv.xy ).r;

	vec4  fvTotalAmbient   = ambient * baseColor; 
	vec4  fvTotalDiffuse   = diffuse * fNDotL * baseColor;
	fvTotalDiffuse.a=1.0;
	vec4  fvTotalSpecular  = specular * ( pow( fRDotV, specularPower ) )*specularStrength;

	vec4 color = ( fvTotalAmbient + fvTotalDiffuse + fvTotalSpecular );

	float alpha=texture2D(transparentMap, uv).r;
	color.a*=alpha;
	gl_FragColor = color;
}