/**
 * QQ 旋风 Chrome 扩展
 * @class XF_POPOP
 * @author wangezhu <wangezhu@tencent.com>
 * @date 2014-03-11
 */
function XF_POPOP() {
    this.chrome = chrome || {};
    this.extension = this.chrome.extension.getBackgroundPage() || {};
    this.isExtEnabled = !!this.extension.XF_BK.isExtEnabled;
    this.xfBackground = new this.extension.XF_BK() || {};
    this.clsName = {
        normal: 'item',
        disable: 'item-disable',
        active: 'item item-select'
    }
}

/**
 * 获取元素
 */
XF_POPOP.prototype.$ = function(el) {
    return document.querySelector(el);
}

/**
 * 点击启用
 */
XF_POPOP.prototype.onChromeSupport = function() {
    this.xfBackground.changeExtensionStatus(!this.isExtEnabled);
    window.close();
    
    return;
}

/**
 * 事件绑定
 */
XF_POPOP.prototype.eventHandler = function() {
    var _this = this;
    _this.$('#xf-chrome-support').addEventListener('click', function() {
        _this.onChromeSupport();
    });
    
    return;
}

/**
 * 设置 className
 */
XF_POPOP.prototype.setClass = function() {
    var xfChromeSupport = '',
        thisPageDisabledXf = '';
    if (this.isExtEnabled) {
        xfChromeSupport = this.clsName.active;
        thisPageDisabledXf = this.clsName.normal;
    } else {
        xfChromeSupport = this.clsName.normal;
        thisPageDisabledXf = this.clsName.disable;
    }
    
    this.$('#xf-chrome-support').className = xfChromeSupport;
    
    return;
}

/**
 * 初始化
 */
XF_POPOP.prototype.init = function() {
    this.setClass();
    this.eventHandler();
    
    return;
}

/**
 * 实例化
 */
new XF_POPOP().init();

