﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO;
using System.IO.Compression;
using System.Text.RegularExpressions;
using System.Security.Cryptography.X509Certificates;
using System.Net.Security;

namespace Post发帖机
{
    public class HttpHelper
    {

        //HttpWebRequest对象用来发起请求
        private HttpWebRequest request = null;
        private HttpWebResponse response = null;
        private Encoding encoding = Encoding.Default;
        //Post数据编码
        private Encoding postencoding = Encoding.Default;
        public bool CheckValidationResult(object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors errors) { return true; }
        
        public HttpResult GetHtml(HttpItem objhttpitem)
        {
            //返回参数
            HttpResult result = new HttpResult();
            try
            {
                //准备参数
                SetRequest(objhttpitem);
            }
            catch (Exception ex)
            {
                result = new HttpResult();
                result.Cookie = string.Empty;
                result.Header = null;
                result.Html = ex.Message;
                result.StatusDescription = "配置参数时出错：" + ex.Message;
                return result;
            }
            try
            {
                #region 得到请求的response
                using (response = (HttpWebResponse)request.GetResponse())
                {
                    result.StatusCode = response.StatusCode;
                    result.StatusDescription = response.StatusDescription;
                    result.Header = response.Headers;
                    if (response.Cookies != null) result.CookieCollection = response.Cookies;
                    if (response.Headers["set-cookie"] != null) result.Cookie = response.Headers["set-cookie"];
                    MemoryStream _stream = new MemoryStream();
                    //GZIIP处理
                    if (response.ContentEncoding != null && response.ContentEncoding.Equals("gzip", StringComparison.InvariantCultureIgnoreCase))
                    {
                        //开始读取流并设置编码方式
                        //new GZipStream(response.GetResponseStream(), CompressionMode.Decompress).CopyTo(_stream, 10240);
                        //.net4.0以下写法
                        _stream = GetMemoryStream(new GZipStream(response.GetResponseStream(), CompressionMode.Decompress));
                    }
                    else
                    {
                        //开始读取流并设置编码方式
                        //response.GetResponseStream().CopyTo(_stream, 10240);
                        //.net4.0以下写法
                        _stream = GetMemoryStream(response.GetResponseStream());
                    }
                    //获取Byte
                    byte[] RawResponse = _stream.ToArray();
                    _stream.Close();
                    //是否返回Byte类型数据
                    if (objhttpitem.ResultType == ResultType.Byte) result.ResultByte = RawResponse;
                    //从这里开始我们要无视编码了
                    if (encoding == null)
                    {
                        Match meta = Regex.Match(Encoding.Default.GetString(RawResponse), "<meta([^<]*)charset=([^<]*)[\"']", RegexOptions.IgnoreCase);
                        string charter = (meta.Groups.Count > 1) ? meta.Groups[2].Value.ToLower() : string.Empty;
                        if (charter.Length > 2)
                            encoding = Encoding.GetEncoding(charter.Trim().Replace("\"", "").Replace("'", "").Replace(";", "").Replace("iso-8859-1", "gbk"));
                        else
                        {
                            if (string.IsNullOrEmpty(response.CharacterSet)) encoding = Encoding.UTF8;
                            else encoding = Encoding.GetEncoding(response.CharacterSet);
                        }
                    }
                    //得到返回的HTML
                    result.Html = encoding.GetString(RawResponse);
                }

            }
            catch (WebException ex)
            {
                //这里是在发生异常时返回的错误信息
                response = (HttpWebResponse)ex.Response;
                result.Html = ex.Message;
                if (response != null)
                {
                    result.StatusCode = response.StatusCode;
                    result.StatusDescription = response.StatusDescription;
                }
            }
            catch (Exception ex)
            {
                result.Html = ex.Message;
            }
            if (objhttpitem.IsToLower) result.Html = result.Html.ToLower();
            return result;
        }
        private static MemoryStream GetMemoryStream(Stream streamResponse)
        {
            MemoryStream _stream = new MemoryStream();
            int Length = 256;
            Byte[] buffer = new Byte[Length];
            int bytesRead = streamResponse.Read(buffer, 0, Length);
            while (bytesRead > 0)
            {
                _stream.Write(buffer, 0, bytesRead);
                bytesRead = streamResponse.Read(buffer, 0, Length);
            }
            return _stream;
        }
        private void SetCer(HttpItem objhttpItem)
        {
            if (!string.IsNullOrEmpty(objhttpItem.CerPath))
            {
                //这一句一定要写在创建连接的前面。使用回调的方法进行证书验证。
                ServicePointManager.ServerCertificateValidationCallback = new System.Net.Security.RemoteCertificateValidationCallback(CheckValidationResult);
                //初始化对像，并设置请求的URL地址
                request = (HttpWebRequest)WebRequest.Create(objhttpItem.URL);
                SetCerList(objhttpItem);
                //将证书添加到请求里
                request.ClientCertificates.Add(new X509Certificate(objhttpItem.CerPath));
            }
            else
            {
                //初始化对像，并设置请求的URL地址
                request = (HttpWebRequest)WebRequest.Create(objhttpItem.URL);
                SetCerList(objhttpItem);
            }
        }
        private void SetRequest(HttpItem objhttpItem)
        {
            // 验证证书
            SetCer(objhttpItem);
            //设置Header参数
            if (objhttpItem.Header != null && objhttpItem.Header.Count > 0) foreach (string item in objhttpItem.Header.AllKeys)
                {
                    request.Headers.Add(item, objhttpItem.Header[item]);
                }
            // 设置代理
            SetProxy(objhttpItem);
            if (objhttpItem.ProtocolVersion != null) request.ProtocolVersion = objhttpItem.ProtocolVersion;
            request.ServicePoint.Expect100Continue = objhttpItem.Expect100Continue;
            //请求方式Get或者Post
            request.Method = objhttpItem.Method;
            request.Timeout = objhttpItem.Timeout;
            request.ReadWriteTimeout = objhttpItem.ReadWriteTimeout;
            //Accept
            request.Accept = objhttpItem.Accept;
            //ContentType返回类型
            request.ContentType = objhttpItem.ContentType;
            //UserAgent客户端的访问类型，包括浏览器版本和操作系统信息
            request.UserAgent = objhttpItem.UserAgent;
            // 编码
            encoding = objhttpItem.Encoding;
            //设置Cookie
            SetCookie(objhttpItem);
            //来源地址
            request.Referer = objhttpItem.Referer;
            //是否执行跳转功能
            request.AllowAutoRedirect = objhttpItem.Allowautoredirect;
            //设置Post数据
            SetPostData(objhttpItem);
            //设置最大连接
            if (objhttpItem.Connectionlimit > 0)
                request.ServicePoint.ConnectionLimit = objhttpItem.Connectionlimit;
        }
        private void SetPostData(HttpItem objhttpItem)
        {
            //验证在得到结果时是否有传入数据
            if (request.Method.Trim().ToLower().Contains("post"))
            {
                if (objhttpItem.PostEncoding != null)
                {
                    postencoding = objhttpItem.PostEncoding;
                }
                byte[] buffer = null;
                //写入Byte类型
                if (objhttpItem.PostDataType == PostDataType.Byte && objhttpItem.PostdataByte != null && objhttpItem.PostdataByte.Length > 0)
                {
                    //验证在得到结果时是否有传入数据
                    buffer = objhttpItem.PostdataByte;
                }//写入文件
                else if (objhttpItem.PostDataType == PostDataType.FilePath && !string.IsNullOrEmpty(objhttpItem.Postdata))
                {
                    StreamReader r = new StreamReader(objhttpItem.Postdata, postencoding);
                    buffer = postencoding.GetBytes(r.ReadToEnd());
                    r.Close();
                } //写入字符串
                else if (!string.IsNullOrEmpty(objhttpItem.Postdata))
                {
                    buffer = postencoding.GetBytes(objhttpItem.Postdata);
                }
                if (buffer != null)
                {
                    request.ContentLength = buffer.Length;
                    request.GetRequestStream().Write(buffer, 0, buffer.Length);
                }
            }
        }
        private void SetCookie(HttpItem objhttpItem)
        {
            if (!string.IsNullOrEmpty(objhttpItem.Cookie))
                //Cookie
                request.Headers[HttpRequestHeader.Cookie] = objhttpItem.Cookie;
            //设置Cookie
            if (objhttpItem.CookieCollection != null)
            {
                request.CookieContainer = new CookieContainer();
                request.CookieContainer.Add(objhttpItem.CookieCollection);
            }
        }
        private void SetCerList(HttpItem objhttpItem)
        {
            if (objhttpItem.ClentCertificates != null && objhttpItem.ClentCertificates.Count > 0)
            {
                foreach (X509Certificate item in objhttpItem.ClentCertificates)
                {
                    request.ClientCertificates.Add(item);
                }
            }
        }
        private void SetProxy(HttpItem objhttpItem)
        {
            if (!string.IsNullOrEmpty(objhttpItem.ProxyIp))
            {
                //设置代理服务器
                if (objhttpItem.ProxyIp.Contains(":"))
                {
                    string[] plist = objhttpItem.ProxyIp.Split(':');
                    WebProxy myProxy = new WebProxy(plist[0].Trim(), Convert.ToInt32(plist[1].Trim()));
                    //建议连接
                    myProxy.Credentials = new NetworkCredential(objhttpItem.ProxyUserName, objhttpItem.ProxyPwd);
                    //给当前请求对象
                    request.Proxy = myProxy;
                }
                else
                {
                    WebProxy myProxy = new WebProxy(objhttpItem.ProxyIp, false);
                    //建议连接
                    myProxy.Credentials = new NetworkCredential(objhttpItem.ProxyUserName, objhttpItem.ProxyPwd);
                    //给当前请求对象
                    request.Proxy = myProxy;
                }
                //设置安全凭证
                request.Credentials = CredentialCache.DefaultNetworkCredentials;
            }
        }
        //public HttpResult GetHtml(HttpItem objhttpitem)
        //{
        //    //返回参数
        //    HttpResult result = new HttpResult();
        //    try
        //    {
        //        //准备参数
        //        SetRequest(objhttpitem);
        //    }
        //    catch (Exception ex)
        //    {
        //        result = new HttpResult();
        //        result.Cookie = string.Empty;
        //        result.Header = null;
        //        result.Html = ex.Message;
        //        result.StatusDescription = "配置参数时出错：" + ex.Message;
        //        return result;
        //    }
        //    try
        //    {
        //        #region 得到请求的response
        //        using (response = (HttpWebResponse)request.GetResponse())
        //        {
        //            result.StatusCode = response.StatusCode;
        //            result.StatusDescription = response.StatusDescription;
        //            result.Header = response.Headers;
        //            if (response.Cookies != null) result.CookieCollection = response.Cookies;
        //            if (response.Headers["set-cookie"] != null) result.Cookie = response.Headers["set-cookie"];
        //            MemoryStream _stream = new MemoryStream();
        //            //GZIIP处理
        //            if (response.ContentEncoding != null && response.ContentEncoding.Equals("gzip", StringComparison.InvariantCultureIgnoreCase))
        //            {
        //                //开始读取流并设置编码方式
        //                //new GZipStream(response.GetResponseStream(), CompressionMode.Decompress).CopyTo(_stream, 10240);
        //                //.net4.0以下写法
        //                _stream = GetMemoryStream(new GZipStream(response.GetResponseStream(), CompressionMode.Decompress));
        //            }
        //            else
        //            {
        //                //开始读取流并设置编码方式
        //                //response.GetResponseStream().CopyTo(_stream, 10240);
        //                //.net4.0以下写法
        //                _stream = GetMemoryStream(response.GetResponseStream());
        //            }
        //            //获取Byte
        //            byte[] RawResponse = _stream.ToArray();
        //            _stream.Close();
        //            //是否返回Byte类型数据
        //            if (objhttpitem.ResultType == ResultType.Byte) result.ResultByte = RawResponse;
        //            //从这里开始我们要无视编码了
        //            if (encoding == null)
        //            {
        //                Match meta = Regex.Match(Encoding.Default.GetString(RawResponse), "<meta([^<]*)charset=([^<]*)[\"']", RegexOptions.IgnoreCase);
        //                string charter = (meta.Groups.Count > 1) ? meta.Groups[2].Value.ToLower() : string.Empty;
        //                if (charter.Length > 2)
        //                    encoding = Encoding.GetEncoding(charter.Trim().Replace("\"", "").Replace("'", "").Replace(";", "").Replace("iso-8859-1", "gbk"));
        //                else
        //                {
        //                    if (string.IsNullOrEmpty(response.CharacterSet)) encoding = Encoding.UTF8;
        //                    else encoding = Encoding.GetEncoding(response.CharacterSet);
        //                }
        //            }
        //            //得到返回的HTML
        //            result.Html = encoding.GetString(RawResponse);
        //        }
        //        #endregion
        //    }
        //    catch (WebException ex)
        //    {
        //        //这里是在发生异常时返回的错误信息
        //        response = (HttpWebResponse)ex.Response;
        //        result.Html = ex.Message;
        //        if (response != null)
        //        {
        //            result.StatusCode = response.StatusCode;
        //            result.StatusDescription = response.StatusDescription;
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        result.Html = ex.Message;
        //    }
        //    if (objhttpitem.IsToLower) result.Html = result.Html.ToLower();
        //    return result;
        //}
    }

    public class HttpItem
    {
        //请求的网页链接
        public string URL { get; set; }
        //网页的数据传输的编码类型
        public Encoding Encoding { get; set; }
        //请求方式为Get或者Post
        private string method = "GET";

        public string Method
        {
            get { return method; }
            set { method = value; }
        }
       
        //请求时的Cookie
        public string Cookie { get; set; }
        //Post请求时要发送的字符串Post数据
        public string Postdata { get; set; }
        //用户浏览器类型
        public string UserAgent { get; set; }
        //返回类型
        public string ContentType { get; set; }
        //设置返回类型String和Byte
        public ResultType ResultType { get; set; }
        //是否设置为全文小写，默认为不转化
        public Boolean IsToLower { get; set; }
        //证书绝对路径
        public string CerPath { get; set; }
        //header对象
        public WebHeaderCollection Header { get; set; }
        // 获取或设置用于请求的 HTTP 版本。
        public Version ProtocolVersion { get; set; }
        // 获取或设置一个 System.Boolean 值，该值确定是否使用 100-Continue 行为。
        public Boolean Expect100Continue { get; set; }
        //默认请求超出时间
        public int  Timeout { get; set; }
        // 默认写入Post数据超时间
        public int ReadWriteTimeout { get; set; }
        //请求标头值 
        public string Accept { get; set; }
        // 来源地址，上次访问地址
        public string Referer { get; set; }
        //支持跳转页面，查询结果将是跳转后的页面，
        public Boolean Allowautoredirect { get; set; }
        // 最大连接数
        public int Connectionlimit { get; set; }
        // 设置或获取Post参数编码,默认的为Default编码
        public Encoding PostEncoding { get; set; }
        // Post的数据类型    
        public PostDataType PostDataType { get; set; }
        // Post请求时要发送的Byte类型的Post数据
        public byte[] PostdataByte  { get; set; }
        //cookie对象集合
        public CookieCollection CookieCollection { get; set; }
        private X509CertificateCollection _ClentCertificates;
        /// <summary>
        /// 设置509证书集合
        /// </summary>
        public X509CertificateCollection ClentCertificates
        {
            get { return _ClentCertificates; }
            set { _ClentCertificates = value; }
        }
        private string proxyusername = string.Empty;
        /// <summary>
        /// 代理Proxy 服务器用户名
        /// </summary>
        public string ProxyUserName
        {
            get { return proxyusername; }
            set { proxyusername = value; }
        }
        private string proxyip = string.Empty;
        /// <summary>
        /// 代理 服务IP
        /// </summary>
        public string ProxyIp
        {
            get { return proxyip; }
            set { proxyip = value; }
        }
        private string proxypwd = string.Empty;
        /// <summary>
        /// 代理 服务器密码
        /// </summary>
        public string ProxyPwd
        {
            get { return proxypwd; }
            set { proxypwd = value; }
        }
    }

    #region 返回参数类
    public class HttpResult
    {
        private string _Cookie;
        /// <summary>
        /// Http请求返回的Cookie
        /// </summary>
        public string Cookie
        {
            get { return _Cookie; }
            set { _Cookie = value; }
        }

        private CookieCollection _CookieCollection;
        /// <summary>
        /// Cookie对象集合
        /// </summary>
        public CookieCollection CookieCollection
        {
            get { return _CookieCollection; }
            set { _CookieCollection = value; }
        }
        private string _Html;
        /// <summary>
        /// 返回的String类型数据 只有ResultType.String时才返回数据，其它情况为空
        /// </summary>
        public string Html
        {
            get { return _Html; }
            set { _Html = value; }
        }
        private byte[] _ResultByte;
        /// <summary>
        /// 返回的Byte数组 只有ResultType.Byte时才返回数据，其它情况为空
        /// </summary>
        public byte[] ResultByte
        {
            get { return _ResultByte; }
            set { _ResultByte = value; }
        }

        private WebHeaderCollection _Header;
        /// <summary>
        /// header对象
        /// </summary>
        public WebHeaderCollection Header
        {
            get { return _Header; }
            set { _Header = value; }
        }

        private string _StatusDescription;
        /// <summary>
        /// 返回状态说明
        /// </summary>
        public string StatusDescription
        {
            get { return _StatusDescription; }
            set { _StatusDescription = value; }
        }
        private HttpStatusCode _StatusCode;
        /// <summary>
        /// 返回状态码,默认为OK
        /// </summary>
        public HttpStatusCode StatusCode
        {
            get { return _StatusCode; }
            set { _StatusCode = value; }
        }
    }
    #endregion
    public enum PostDataType
    {
        /// <summary>
        /// 字符串类型，这时编码Encoding可不设置
        /// </summary>
        String,
        /// <summary>
        /// Byte类型，需要设置PostdataByte参数的值编码Encoding可设置为空
        /// </summary>
        Byte,
        /// <summary>
        /// 传文件，Postdata必须设置为文件的绝对路径，必须设置Encoding的值
        /// </summary>
        FilePath
    }
    public enum ResultType
    {
        /// <summary>
        /// 表示只返回字符串 只有Html有数据
        /// </summary>
        String,
        /// <summary>
        /// 表示返回字符串和字节流 ResultByte和Html都有数据返回
        /// </summary>
        Byte
    }

}
                #endregion