(function($) {
	var defaults = {
			attr : "data-url",
			container : $(window),
			callback : $.noop,
			placeholder : "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAANSURBVBhXYzh8+PB/AAffA0nNPuCLAAAAAElFTkSuQmCC",
			defaultimg : "./images/img_default.png",
			isStopScrollLoading : false
		};
	
	$.fn.stopScrollLoading = function() {
//		params.container.unbind("scroll");
		var params = $(this).data("params");
		if(!params){
			return;
		}
		params.isStopScrollLoading = true;
		params.cache = [];
	};
	$.fn.scrollLoading = function(options) {
		var params = $.extend({}, defaults, options || {}),
			isLowerIE = false;
		params.cache = [];
		
		var browser=navigator.appName,
			b_version=navigator.appVersion,
			version=b_version.split(";"),
			trim_Version=version[1].replace(/[ ]/g,"");
		if(browser=="Microsoft Internet Explorer" && (trim_Version=="MSIE7.0" || trim_Version=="MSIE6.0")){
			isLowerIE = true;
		}
		
		$(this).data("params", params);
		$(this).each(function() {
			var $self = $(this), node = this.nodeName
					.toLowerCase(), url = $(this).attr(
					params["attr"]);

			if ($self.attr("src") === undefined
					|| $self.attr("src") === false) {
				if ($self.is("img")) {
					$self.attr("src", (isLowerIE ? defaults.defaultimg : defaults.placeholder));
				}
			}
			// 重组
			var data = {
				obj : $(this),
				tag : node,
				url : url
			};
			params.cache.push(data);
		});

		var callback = function(call) {
			if ($.isFunction(params.callback)) {
				params.callback.call(call.get(0));
			}
		};
		// 动态显示数据
		var loading = function() {
			if(params.isStopScrollLoading){
				return;
			}

			var contHeight = params.container.height();
			if ($(window).get(0) === window) {
				contop = $(window).scrollTop();
			} else {
				contop = params.container.offset().top;
			}
			
			containerTopBtn(params.container.scrollTop());
			
			$.each(params.cache, function(i, data) {
				var o = data.obj, tag = data.tag, url = data.url, post, posb;

				if (o) {
					post = o.offset().top - contop, post + o.height();

					if ((post >= 0 && post < contHeight)
							|| (posb > 0 && posb <= contHeight)) {
						if (url) {
							// 在浏览器窗口内
							if (tag === "img") {
								if (url.indexOf("blendTemplate(") > -1 || url.indexOf("downloadTemplate(") > -1) {
									new Function(url)();
								} else {
									// 图片，改变src
									callback(o.attr("src", url));
								}
							} else {
								o.load(url, {}, function() {
									callback(o);
								});
							}
						} else {
							// 无地址，直接触发回调
							callback(o);
						}
						data.obj = null;
					}
				}
			});
		};
		
		params.container.scrollTop(0);
		// 事件触发
		// 加载完毕即执行
		loading();
		// 滚动执行
		params.container.bind("scroll", loading);
	};
})(jQuery);