/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.bo;
import sun.security.krb5.internal.util.m;
import sun.security.util.BitArray;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class TicketFlags
extends m {
    public TicketFlags() {
        super(32);
    }

    public byte[] asn1Encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putUnalignedBitString(new BitArray(this.a()));
        return derOutputStream.toByteArray();
    }

    public TicketFlags(int n2, byte[] byArray) throws Asn1Exception {
        super(n2, byArray);
        if (n2 > byArray.length * 8 || n2 > 32) {
            throw new Asn1Exception(502);
        }
    }

    public TicketFlags(boolean[] blArray) throws Asn1Exception {
        super(blArray);
        if (blArray.length > 32) {
            throw new Asn1Exception(502);
        }
    }

    public Object clone() {
        try {
            return new TicketFlags(this.a());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean[] blArray = this.a();
        int n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                switch (n2) {
                    case 0: {
                        stringBuffer.append("RESERVED;");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("FORWARDABLE;");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("FORWARDED;");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("PROXIABLE;");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("PROXY;");
                        break;
                    }
                    case 5: {
                        stringBuffer.append("MAY-POSTDATE;");
                        break;
                    }
                    case 6: {
                        stringBuffer.append("POSTDATED;");
                        break;
                    }
                    case 7: {
                        stringBuffer.append("INVALID;");
                        break;
                    }
                    case 8: {
                        stringBuffer.append("RENEWABLE;");
                        break;
                    }
                    case 9: {
                        stringBuffer.append("INITIAL;");
                        break;
                    }
                    case 10: {
                        stringBuffer.append("PRE-AUTHENT;");
                        break;
                    }
                    case 11: {
                        stringBuffer.append("HW-AUTHENT;");
                    }
                }
            }
            ++n2;
        }
        String string = stringBuffer.toString();
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public boolean match(TicketFlags ticketFlags) {
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < 12) {
            if (this.a(n2) != ticketFlags.a(n2)) {
                return false;
            }
            ++n2;
        }
        return bl2;
    }

    public boolean match(bo bo2) {
        boolean bl2 = false;
        if (this.a(1) == bo2.a(1) && this.a(3) == bo2.a(3) && this.a(8) == bo2.a(8)) {
            bl2 = true;
        }
        return bl2;
    }

    public TicketFlags(DerValue derValue) throws IOException, Asn1Exception {
        this(derValue.getUnalignedBitString(true).toBooleanArray());
    }

    public static TicketFlags parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new TicketFlags(derValue2);
    }
}

