/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;

public abstract class Size2DSyntax
implements Serializable,
Cloneable {
    private int x;
    private int y;
    public static final int INCH = 25400;
    public static final int MM = 1000;

    protected int getXMicrometers() {
        return this.x;
    }

    protected int getYMicrometers() {
        return this.y;
    }

    public int hashCode() {
        return this.x & 0xFFFF | (this.y & 0xFFFF) << 16;
    }

    protected Size2DSyntax(float f2, float f3, int n2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("x < 0");
        }
        if (f3 < 0.0f) {
            throw new IllegalArgumentException("y < 0");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("units < 1");
        }
        this.x = (int)(f2 * (float)n2 + 0.5f);
        this.y = (int)(f3 * (float)n2 + 0.5f);
    }

    public float getX(int n2) {
        return Size2DSyntax.convertFromMicrometers(this.x, n2);
    }

    public float getY(int n2) {
        return Size2DSyntax.convertFromMicrometers(this.y, n2);
    }

    public float[] getSize(int n2) {
        return new float[]{this.getX(n2), this.getY(n2)};
    }

    private static float convertFromMicrometers(int n2, int n3) {
        if (n3 < 1) {
            throw new IllegalArgumentException("units is < 1");
        }
        return (float)n2 / (float)n3;
    }

    protected Size2DSyntax(int n2, int n3, int n4) {
        if (n2 < 0) {
            throw new IllegalArgumentException("x < 0");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("y < 0");
        }
        if (n4 < 1) {
            throw new IllegalArgumentException("units < 1");
        }
        this.x = n2 * n4;
        this.y = n3 * n4;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Size2DSyntax && this.x == ((Size2DSyntax)object).x && this.y == ((Size2DSyntax)object).y;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.x);
        stringBuffer.append('x');
        stringBuffer.append(this.y);
        stringBuffer.append(" um");
        return stringBuffer.toString();
    }

    public String toString(int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getX(n2));
        stringBuffer.append('x');
        stringBuffer.append(this.getY(n2));
        if (string != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

