/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.MixerClip;
import com.sun.media.sound.MixerSourceLine;
import com.sun.media.sound.Platform;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.EnumControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.ReverbType;
import javax.sound.sampled.SourceDataLine;

class HeadspaceMixer
extends AbstractMixer {
    private static int oldDeviceExists;
    public static final int INTERPOLATION_DROP_SAMPLE = 0;
    public static final int INTERPOLATION_2_POINT = 1;
    public static final int INTERPOLATION_LINEAR = 2;
    private static int TOTAL_VOICES;
    private static int DEFAULT_BUFFER_SIZE;
    static final int MAX_SAMPLES = 0x100000;
    static final int MAX_FRAME_SIZE = 4;
    private static final AudioFormat.Encoding encoding8;
    private static final AudioFormat[] sourceLineFormats;
    private DataLine.Info sourceDataLineInfo = new DataLine.Info(SourceDataLine.class, sourceLineFormats, 0, -1);
    private final DataLine.Info clipInfo = new DataLine.Info(Clip.class, sourceLineFormats, 0, 0x400000);
    static final AudioFormat defaultFormat;
    private static final int defaultMixLevel = 6;
    private static final int defaultInterpolationMode = 2;
    private int sampledVoices;
    private int midiVoices;
    private int mixLevel;
    private int terpMode;
    private static final HeadspaceMixer mixerInstance;
    static /* synthetic */ Class class$javax$sound$sampled$DataLine;

    public float getCpuLoad() {
        return this.nGetCpuLoad();
    }

    private native float nGetCpuLoad();

    private native float nGetLevel();

    public int getInterpolationMode() {
        return this.terpMode;
    }

    public int getMidiVoices() {
        return this.midiVoices;
    }

    public int getMixLevel() {
        return this.mixLevel;
    }

    public int getSampledVoices() {
        return this.sampledVoices;
    }

    public int getSystemVoices() {
        return TOTAL_VOICES;
    }

    private static native int nGetDefaultBufferSize();

    private static native int nGetTotalVoices();

    private native long nGetPosition();

    static {
        Platform.initialize();
        oldDeviceExists = -1;
        DEFAULT_BUFFER_SIZE = -1;
        encoding8 = Platform.isSigned8() ? AudioFormat.Encoding.PCM_SIGNED : AudioFormat.Encoding.PCM_UNSIGNED;
        sourceLineFormats = new AudioFormat[]{new AudioFormat(-1.0f, 8, 1, true, false), new AudioFormat(-1.0f, 8, 1, false, false), new AudioFormat(-1.0f, 8, 2, true, false), new AudioFormat(-1.0f, 8, 2, false, false), new AudioFormat(-1.0f, 16, 1, true, !Platform.isBigEndian()), new AudioFormat(-1.0f, 16, 1, true, Platform.isBigEndian()), new AudioFormat(-1.0f, 16, 2, true, !Platform.isBigEndian()), new AudioFormat(-1.0f, 16, 2, true, Platform.isBigEndian())};
        defaultFormat = new AudioFormat(44100.0f, 16, 2, true, Platform.isBigEndian());
        mixerInstance = new HeadspaceMixer();
    }

    private HeadspaceMixer() {
        super(new MixerInfo(), new Control[1], null, null);
        this.init();
    }

    protected synchronized void implClose() {
        this.nPause();
        this.nCloseMixer();
    }

    protected synchronized void implOpen() throws LineUnavailableException {
        if (oldDeviceExists == 0) {
            throw new LineUnavailableException("no audio device available for Java Sound Audio Engine");
        }
        AudioFormat audioFormat = defaultFormat;
        this.nOpenMixer(audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), (int)audioFormat.getSampleRate(), this.terpMode, this.midiVoices, this.sampledVoices, this.mixLevel);
        try {
            this.nResume();
        }
        catch (LineUnavailableException lineUnavailableException) {
            this.implClose();
            throw lineUnavailableException;
        }
    }

    protected synchronized void implStart() {
    }

    protected synchronized void implStop() {
    }

    void init() {
        boolean bl2 = this.nSetMixerFormat(0, 0, 0);
        if (oldDeviceExists == 0 && !bl2 || oldDeviceExists == 1 && bl2) {
            return;
        }
        if (!bl2) {
            this.controls = new Control[0];
            this.sourceLineInfo = new Line.Info[0];
            this.targetLineInfo = new DataLine.Info[0];
            oldDeviceExists = 0;
        } else {
            this.targetLineInfo = new DataLine.Info[0];
            TOTAL_VOICES = HeadspaceMixer.nGetTotalVoices();
            DEFAULT_BUFFER_SIZE = HeadspaceMixer.nGetDefaultBufferSize();
            if (DEFAULT_BUFFER_SIZE == 0) {
                DEFAULT_BUFFER_SIZE = -1;
            }
            this.controls = new Control[1];
            this.controls[0] = new MixerReverbControl();
            this.sourceLineInfo = new Line.Info[2];
            this.sourceLineInfo[0] = this.sourceDataLineInfo;
            this.sourceLineInfo[1] = this.clipInfo;
            this.targetLineInfo = new DataLine.Info[0];
            this.sampledVoices = TOTAL_VOICES / 2;
            this.midiVoices = TOTAL_VOICES / 2;
            this.mixLevel = 6;
            this.terpMode = 2;
            oldDeviceExists = 1;
        }
    }

    private native void nCloseMixer();

    private native void nDrain();

    private native void nFlush();

    private native void nPause();

    private native void nResume() throws LineUnavailableException;

    boolean audioDeviceExists() {
        this.init();
        return oldDeviceExists == 1;
    }

    private static native int nSetReverb(int var0);

    private native boolean nSetInterpolation(int var1);

    private native boolean nSetMixLevel(int var1);

    public boolean setInterpolationMode(int n2) {
        if (!this.nSetInterpolation(n2)) {
            return false;
        }
        this.terpMode = n2;
        return true;
    }

    public boolean setMixLevel(int n2) {
        if (!this.nSetMixLevel(n2)) {
            return false;
        }
        this.mixLevel = n2;
        return true;
    }

    public boolean allocateVoices(int n2, int n3) {
        if (!this.nAllocateVoices(n2, n3)) {
            return false;
        }
        this.midiVoices = n2;
        this.sampledVoices = n3;
        return true;
    }

    private native boolean nAllocateVoices(int var1, int var2);

    private native boolean nSetMixerFormat(int var1, int var2, int var3);

    private native void nOpenMixer(int var1, int var2, int var3, int var4, int var5, int var6, int var7) throws LineUnavailableException;

    private native void nStopLinkedStreams(long var1);

    private native boolean nStartLinkedStreams(long var1);

    private native long nCreateLinkedStreams(long[] var1);

    static HeadspaceMixer getMixerInstance() {
        return mixerInstance;
    }

    synchronized void close(MidiDevice midiDevice) {
        MidiLine midiLine = this.getMidiLine(midiDevice);
        if (midiLine != null) {
            midiLine.stop();
            midiLine.close();
        }
    }

    synchronized void open(MidiDevice midiDevice) throws LineUnavailableException {
        if (this.getMidiLine(midiDevice) == null) {
            MidiLine midiLine = new MidiLine(this, midiDevice);
            midiLine.open();
            midiLine.start();
        }
    }

    AudioFormat getDefaultFormat() {
        return defaultFormat;
    }

    public int getMaxLines(Line.Info info) {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            return 0;
        }
        if (info2 instanceof DataLine.Info && this.isSourceLine(info2)) {
            return this.sampledVoices;
        }
        if (info2 instanceof DataLine.Info && this.isTargetLine(info2)) {
            return 0;
        }
        return 0;
    }

    boolean isSourceLine(Line.Info info) {
        return info instanceof MidiLineInfo || super.isSourceLine(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MidiLine getMidiLine(MidiDevice midiDevice) {
        Vector vector = this.sourceLines;
        synchronized (vector) {
            for (int i2 = 0; i2 < this.sourceLines.size(); ++i2) {
                if (!(this.sourceLines.elementAt(i2) instanceof MidiLine) || ((MidiLine)this.sourceLines.elementAt(i2)).getMidiDevice() != midiDevice) continue;
                return (MidiLine)this.sourceLines.elementAt(i2);
            }
        }
        return null;
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info2 instanceof DataLine.Info) {
            AudioFormat audioFormat;
            DataLine.Info info3 = (DataLine.Info)info2;
            int n2 = -1;
            AudioFormat[] audioFormatArray = null;
            if (info instanceof DataLine.Info) {
                audioFormatArray = ((DataLine.Info)info).getFormats();
                n2 = ((DataLine.Info)info).getMaxBufferSize();
            }
            if (audioFormatArray == null || audioFormatArray.length == 0) {
                audioFormat = defaultFormat;
            } else {
                audioFormat = audioFormatArray[audioFormatArray.length - 1];
                boolean bl2 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
                boolean bl3 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
                if ((bl2 || bl3) && audioFormat.getSampleRate() == -1.0f) {
                    audioFormat = new AudioFormat(defaultFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), bl2, audioFormat.isBigEndian());
                }
            }
            if (n2 == -1) {
                n2 = info3.getMaxBufferSize();
            }
            if (info3.getLineClass().isAssignableFrom(MixerSourceLine.class)) {
                return new MixerSourceLine(this.sourceDataLineInfo, this, audioFormat, n2);
            }
            if (info3.getLineClass().isAssignableFrom(MixerClip.class)) {
                return new MixerClip(this.clipInfo, this, audioFormat, n2);
            }
        }
        throw new SecurityException("Access to line not granted: " + info);
    }

    private static class MidiLine
    extends AbstractDataLine {
        private MidiDevice device;
        private boolean closed = true;
        private boolean started = false;

        protected void implClose() {
            if (!this.closed) {
                this.closed = true;
                this.started = false;
                this.device.close();
            }
        }

        protected void implStart() {
            if (!this.started) {
                this.started = true;
            }
        }

        protected void implStop() {
            if (this.started) {
                this.started = false;
            }
        }

        private MidiDevice getMidiDevice() {
            return this.device;
        }

        protected void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
            this.closed = false;
        }

        private MidiLine(AbstractMixer abstractMixer, MidiDevice midiDevice) {
            super(new MidiLineInfo(), abstractMixer, null, defaultFormat, DEFAULT_BUFFER_SIZE);
            this.device = midiDevice;
        }
    }

    private static class MidiLineInfo
    extends DataLine.Info {
        private MidiLineInfo() {
            super(class$javax$sound$sampled$DataLine == null ? (class$javax$sound$sampled$DataLine = HeadspaceMixer.class$("javax.sound.sampled.DataLine")) : class$javax$sound$sampled$DataLine, defaultFormat, DEFAULT_BUFFER_SIZE);
        }
    }

    private static class MixerInfo
    extends Mixer.Info {
        private static final String name = "Java Sound Audio Engine";
        private static final String vendor = "Sun Microsystems";
        private static final String description = "Software mixer and synthesizer";
        private static final String version = "1.0";

        private MixerInfo() {
            super(name, vendor, description, version);
        }
    }

    private static class MixerReverbControl
    extends EnumControl {
        private static final MixerReverbType NO_REVERB = new MixerReverbType("No Reverb", 0, 0.0f, 0, 0.0f, 0, 1);
        private static final MixerReverbType CLOSET = new MixerReverbType("Closet", 600, -7.0f, 2500, -10.0f, 150000, 2);
        private static final MixerReverbType GARAGE = new MixerReverbType("Garage", 3900, -4.0f, 14700, -6.0f, 900000, 3);
        private static final MixerReverbType ACOUSTIC_LAB = new MixerReverbType("Acoustic Lab", 2000, -2.0f, 8000, -3.0f, 280000, 4);
        private static final MixerReverbType CAVERN = new MixerReverbType("Cavern", 10300, -1.4f, 41300, -2.0f, 2250000, 5);
        private static final MixerReverbType DUNGEON = new MixerReverbType("Dungeon", 2600, -0.7f, 10300, -1.0f, 1600000, 6);
        private static final ReverbType[] types = new ReverbType[]{NO_REVERB, CLOSET, GARAGE, ACOUSTIC_LAB, CAVERN, DUNGEON};
        private static final ReverbType defaultReverb = ACOUSTIC_LAB;

        private MixerReverbControl() {
            super(EnumControl.Type.REVERB, types, defaultReverb);
        }

        private void initializeReverb() {
            try {
                this.setValue(defaultReverb);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setValue(NO_REVERB);
            }
        }

        public void setValue(Object object) {
            int n2;
            if (!(object instanceof ReverbType)) {
                throw new IllegalArgumentException("Value must be of type ReverbType");
            }
            ReverbType reverbType = (ReverbType)object;
            if (reverbType instanceof MixerReverbType) {
                n2 = ((MixerReverbType)reverbType).getReverbMode();
            } else if (object == NO_REVERB) {
                n2 = 1;
            } else {
                throw new IllegalArgumentException("Unknown reverb value: " + object);
            }
            int n3 = HeadspaceMixer.nSetReverb(n2);
            if (n3 == n2) {
                super.setValue(object);
            } else if (n3 != 1) {
                for (int i2 = 0; i2 < types.length; ++i2) {
                    if (!(types[i2] instanceof MixerReverbType) || ((MixerReverbType)MixerReverbControl.types[i2]).getReverbMode() != n3) continue;
                    super.setValue(types[i2]);
                }
            }
        }

        private static class MixerReverbType
        extends ReverbType {
            private final int reverbMode;

            private int getReverbMode() {
                return this.reverbMode;
            }

            private MixerReverbType(String string, int n2, float f2, int n3, float f3, int n4, int n5) {
                super(string, n2, f2, n3, f3, n4);
                this.reverbMode = n5;
            }
        }
    }
}

